
/* qddb/Headers/Index.h
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#if !defined(_QDDB_INDEX_H_)
#define _QDDB_INDEX_H_

typedef struct pnode {
    off_t		Start;
    size_t		Length, attr;
    char		*inst;
    struct pnode	*next;
} PosNode;

typedef struct knode {
    char		*s;
    PosNode		*pos;
    int			len;
    size_t		attr;
    char		*inst;
    struct knode	*next;
} KeyNode;

typedef struct kindex {
    char		*s;
    off_t		Start;
    size_t		Length;
} KeyIndexIn;

typedef struct nindex {
    double		s;
    off_t		Start;
    size_t		Length;
} NumericIndexIn;

typedef KeyNode	*Bucket;

/* Lib/LibQddb/BuildDB.c */
void Qddb_BuildDatabase _ANSI_ARGS_((Schema *));
void Qddb_WriteReducedAttributeIdentifiers _ANSI_ARGS_((Schema *));
void Qddb_BuildReducedAttributeTable _ANSI_ARGS_((Schema *, char *));

/* Lib/LibQddb/MakeKeys.c */
void Qddb_MakeKeys _ANSI_ARGS_((Schema *));

/* Lib/LibQddb/Index.c */
int Qddb_HashValue _ANSI_ARGS_((Schema *, char *));
void Qddb_MakeIndex _ANSI_ARGS_((Schema *));

#endif

