/*----------------------------------------------------------------------*
** File: pql_vars.c
** 
** 
** Project:	PQL
** =====================================================================*
** Description:	PQL (Subset II) - pql variable handling
**
**  Author:	Bjoern Lemke
**  E-Mail:	lemke@lf.net
**
** Copyright (c) 1994 Bjoern Lemke.
**----------------------------------------------------------------------*/

#include <stdio.h>
#include "eng.h"
#include <dirent.h>
#include <fcntl.h>
#include "pql_conf.h"

#define MAXDIRBUF 512

/*********************/
/* public prototypes */
/*********************
void loadvars();
void setvar(char *var, char *value);
char *getvar(char *var);
void expvar(char *var);
void showvars();
void listtables();

/********************/
/* global variables */
/********************/
typedef struct VarList {
  char varname[NAMELEN];
  char value[NAMELEN];
} VarList;

#define VARLISTLEN 10
VarList varlist[VARLISTLEN/2];
char *pqlvars[] = { VN_DBPATH, DBPATH,
		      VN_VERSEP, VERSEP,
		      VN_HORSEP, HORSEP,
                      VN_ATTMODE, ATTMODE,
		      VN_NFIELD, NFIELD };

/*******************/
/* public routines */
/*******************/
void loadvars()
{
  int i, j=0;
  for (i=0; i < VARLISTLEN; i=i+2) {
    strcpy(varlist[j].varname, pqlvars[i]);
    strcpy(varlist[j].value, pqlvars[i+1]);
    j++;
  }
}

void setvar(char *var, char *value) 
{
  int i;
  for (i=0; i<VARLISTLEN/2; i++)
    if (!strcmp(var, varlist[i].varname)) {
      strcpy(varlist[i].value, value);
      return;
    }
  fprintf(stderr, "PQL-ERROR: unknown variable\n");
  return;
}

char *getvar(char *var)
{
  int i;
  for (i=0; i<VARLISTLEN/2; i++) {
    if (!strcmp(var, varlist[i].varname)) {
      return(varlist[i].value);
    }
  }
  fprintf(stderr, "PQL-ERROR: unknown variable\n");
  return(NULL);
}

void showvars()
{
  int i;
  for (i=0; i < VARLISTLEN/2; i++)
    printf("%s   %s\n", varlist[i].varname, varlist[i].value);
}

/* add here more expanding values */

void expvar(char *var)
{
  char buf[STRINGLEN];
  char *evar;
  char *scan;

  scan = var;
  evar = buf;

  while (*scan != '\0') {
    if (*scan == 'T' && *(scan+1) == 'A' && *(scan+2) == 'B') {
      *evar='\t';
      evar++;
      scan=scan+3;
    } else if (*scan == 'N' && *(scan+1) == 'L') {
      *evar='\n';
      evar++;
      scan=scan+2;
      continue;
    } else {
      *evar = *scan;
      evar++;
      scan++;
    }
  }
  *evar='\0';
  strcpy(var, buf);
  return;
}

#ifdef SUNOS
void listtables()
{
  char *pathvar=getvar(VN_DBPATH);
  int dfd, n, dbufptr;
  char dbuf[MAXDIRBUF];
  struct dirent dlink;
  
  if ((dfd=open(pathvar, O_RDONLY)) == -1) {
    perror("PQL-ERROR: open");
    return;
  }
  
  while ((n = getdents(dfd, dbuf, MAXDIRBUF)) != 0) {
    dbufptr=0;
    while (dbufptr < n) {
      bcopy(dbuf + dbufptr, &dlink, 
	    MAXDIRBUF - dbufptr < sizeof(struct dirent) ?
	    MAXDIRBUF - dbufptr : sizeof(struct dirent));
      if (!strcmp(dlink.d_name + dlink.d_namlen - strlen(CTXSUF), CTXSUF)) {
	dlink.d_name[dlink.d_namlen - strlen(CTXSUF)] = '\0';
	printf("%s\n", dlink.d_name);
      }
      dbufptr += dlink.d_reclen;
    }
  }     
}
#endif SUNOS

#if defined(AIX) || defined (LINUX)
void listtables()
{
  char *pathvar=getvar(VN_DBPATH);
  int dfd, n, dbufptr;
  char dbuf[MAXDIRBUF];
  struct dirent *dp;
  DIR *DirectoryPointer = opendir(pathvar);

  for (dp = readdir(DirectoryPointer); dp != NULL; dp =
       readdir(DirectoryPointer))
     if (!strcmp(dp->d_name + dp->d_namlen - strlen(CTXSUF), CTXSUF)) {
       dp->d_name[dp->d_namlen - strlen(CTXSUF)] = '\0';
       printf("%s\n", dp->d_name);
     }
  closedir(DirectoryPointer);
}
#endif
