/*----------------------------------------------------------------------*
** File: pql_tree.h
** 
** 
** Project:	PQL
** =====================================================================*
** Description:	PQL (SQL Subset II) - syntax tree definition
**
**  Author:	Bjoern Lemke
**  E-Mail:	lemke@lf.net
**
** Copyright (c) 1994 Bjoern Lemke.
**----------------------------------------------------------------------*/

/* include the trigger values */
#include "pql_conf.h"

typedef struct JoinBuf JoinBuf;
typedef struct JFormat JFormat;
typedef struct AddTable AddTable;
typedef struct SubQueryFormat SubQueryFormat;
typedef struct SubQueryBuf SubQueryBuf;

/* join format information */
struct JFormat {
  char attribute[MAXATTLEN];
  int tableindex; /* index in JoinBuf; */
  int size;
  int type;
  int atype; /* key type of the attribute */
};

/* the join buffer */
struct JoinBuf {
  int stored; /* num of stored tuples */
  int tupsize; /* length of a stored tuples */
  char jbuf[2][TBUFSIZE];
  int bufptr[2];
  int actbuf; /* actual tuple buffer */
  int tnum; /* stored tables */
  char tables[MAXTABLES][MAXTNLEN];
  char talias[MAXTABLES][MAXTNLEN];
  int anum;
  JFormat entry[MAXJOINATTS];
  AddTable *atab;
};

/* linked list of adding tables */
struct AddTable {
  Relation *rel;
  char talias[MAXTNLEN];
  int recnum;
  int nextrec;
  char pktuplebuf[MAXTUPLEN];
  char attuplebuf[MAXTUPLEN];
  AddTable *next;
};


struct SubQueryBuf { 
  int anum; /* num of attributes */
  int stored; /* num of stored attributes */
  int size; /* size of stored attributes */
  int type; /* type of stored attributes */
  char sqbuf[SQBUFSIZE];
};

enum Comparsion { EQU, NEQUAL, LEQUAL, LESS, MEQUAL, MORE, INVALID };

/* rules */

enum CondRules { COND_PREDICATE, COND_NOT, COND_AND, COND_OR };
enum PredRules { PRED_EXPR, PRED_QUERY, PRED_ALL_QUERY, PRED_ANY_QUERY,
		   PRED_IN_ELIST, PRED_N_IN_ELIST, PRED_EXISTS, PRED_N_EXISTS,
		   PRED_LIKE, PRED_N_LIKE, PRED_IN_QUERY, PRED_N_IN_QUERY };
enum ExprRules { EXPR_LIT, EXPR_ATTSPEC, EXPR_PLUS, EXPR_MINUS, EXPR_MUL, 
		   EXPR_DIV, EXPR_FUNC };
enum FuncRules { FUNC_MIN, FUNC_MAX, FUNC_SUM, FUNC_AVG };

enum AttAccess { JOINBUF, BASETABLE, NONE };

enum QueryMode { SUBQUERY, MAINQUERY };

#define MAXCOND 10
#define MAXEXPR 10

/*
 *	syntax tree structure definition
 */

/* prototypes */
typedef struct Selection Selection;
typedef struct QueryOp QueryOp;
typedef struct SelCond SelCond;
typedef struct FromList FromList;
typedef struct TableSpec TableSpec;
typedef struct GroupCond GroupCond;
typedef struct OrderCond OrderCond;
typedef struct InsertOp InsertOp;
typedef struct InsertList InsertList;
typedef struct UpdateOp UpdateOp;
typedef struct SetList SetList;
typedef struct Assignment Assignment;
typedef struct DeleteOp DeleteOp;
typedef struct Condition Condition;
typedef struct Predicate Predicate;
typedef struct ExprList ExprList;
typedef struct Expr Expr;
typedef struct AttrSpecList AttrSpecList;
typedef struct Function Function;
typedef struct FuncArg FuncArg;
typedef struct AttrSpec AttrSpec;
typedef struct ConstantList ConstantList;
typedef struct Literal Literal;
typedef struct CreateOp CreateOp;
typedef struct ExtendOp ExtendOp;
typedef struct ShrinkOp ShrinkOp;
typedef struct ShrinkList ShrinkList;
typedef struct ExtList ExtList;
typedef struct Aspec Aspec;

struct QueryOp {
        int depth;
	int distinct; /* distinct=0 matches rule 1 */
	int countit;
	Selection *selectionptr;
	SelCond *selcondptr;
	QueryOp *prev; /* to reach daddy */
	SubQueryBuf *sqbuf;
	JoinBuf *jbuf[MAXCJ]; /* the join buffer */
	int cj; /* conjunction count */
	int selectmode;
	};

struct Selection {
	ExprList *exprlistptr; /* exprlistptr=NULL matches rule 1 */ 
	};

struct SelCond {
	FromList *fromlistptr;
	Condition *wherecondptr;
	GroupCond *groupcondptr;
	OrderCond *ordercondptr;
	};

struct FromList {
	TableSpec *tablespecptr;
	struct FromList *next;
	};

struct TableSpec {
	char tablename[MAXTNLEN];
	char tablealias[MAXTNLEN];
	};

struct GroupCond {
	AttrSpec *attrspecptr;
	Condition *havingcondptr;
	};

struct OrderCond {
	AttrSpecList *attrspeclistptr;
	int order; /* ASC or DESC */
	};

struct InsertOp {
	char tablename[MAXTNLEN];
	InsertList *insertlistptr;
	};

struct InsertList {
	int rule;
	QueryOp *queryopptr;
	ConstantList *constantlistptr;
	};

struct UpdateOp {
	char tablename[MAXTNLEN];
	SetList *setlistptr;
	Condition *conditionptr;
	};

struct SetList {
	Assignment *assignmentptr;
	struct SetList  *next;
	};

struct Assignment {
  	AttrSpec *attrspecptr;
 	Literal *literalptr;
	};

struct CreateOp {
	char tablename[MAXTNLEN];
	ExtList *extlistptr;
	};

struct ExtendOp {
	char tablename[MAXTNLEN];
	ExtList *extlistptr;
	};

struct ExtList {
	Aspec *aspecptr;
	struct ExtList *next;
	};

struct Aspec {	
  	char attrname[MAXATTLEN];
	int attrkey;
 	int attrtype;
	int attrsize;
	};

struct ShrinkOp {
  	char tablename[MAXTNLEN];
	ShrinkList *shrinklistptr;
	};

struct ShrinkList {
	char attrname[MAXATTLEN];
	struct ShrinkList *next;
	};

struct DeleteOp {
	char tablename[MAXTNLEN];
	Condition *conditionptr;
	};

struct Condition {
	int rule;
	int negate; /* for De Morgan */
	int choice; /* for DNF */
	Predicate *predicateptr;
	Condition *cond1ptr;
	Condition *cond2ptr;
	};


enum PredStat { UNMARKED, MARKED, LASTPRED };
struct Predicate {
	int rule;
	int marked;
	Expr *expr1ptr;
	Expr *expr2ptr;
	int comparison;
	ExprList *exprlistptr;
	QueryOp *queryopptr;
	AttrSpec *attrspecptr;
	Literal *literalptr;
	};

struct ExprList {
	Expr *exprptr;
	struct ExprList *next;
	};

struct Expr {
	int rule;
	Literal *literalptr;
	AttrSpec *attrspecptr;
	struct Expr *expr1ptr;
	struct Expr *expr2ptr;
	Function *functionptr;
	};

struct AttrSpecList {
        AttrSpec *attrspecptr;
	struct AttrSpecList *next;
	};

struct Function {
       int rule;
       Expr *exprptr;
       };

struct AttrSpec {
	char tablename[MAXTNLEN]; /* contains name or alias */
	char talias[MAXTNLEN]; /* contains alias after eval */
	char attrname[MAXATTLEN];
	/* set up during prepare phase */
	int access;
	int base; /* base offset if joined */
	void *slot;
	int atype; /* key type of attribute */
	int type;
	int cast;
	int bmidx; /* bmidx, bmbase and bm for NULL value handling */
	int bmbase; /* bmbase = 0 indicates primary */ 
	void *bm;
	};

struct ConstantList  {
	Literal *literalptr;
	struct ConstantList *next;
	};

struct Literal {
	int rule;
	int intval;
	double doubleval;
	float floatval;
	char strval[STRINGLEN+100];
	};

/* 
 * further types
 */ 

typedef struct {
  AttrSpec *attrspec;
  int phase;
  int depth;
  int used;
} ATable;


typedef struct GroupTable {
  char gbystr[STRINGLEN];
  long gbylong;
  float gbyfloat;
  double gbydouble;
} GroupTable;


enum ParsePhase {SELECTION, CONDITION, ASSIGNMENT, DELCOND, UPDATECOND};
enum SelectMode {NOSELMODE, STAR, PROJECTION, AGREGATION, GROUPING};

