%{
/*----------------------------------------------------------------------*
** File: pql.y
** 
** 
** Project:	PQL
** =====================================================================*
** Description:	PQL (Subset II) - parser
**
**  Author:	Bjoern Lemke
**  E-Mail:	lemke@lf.net
**
** Copyright (c) 1994 Bjoern Lemke.
**----------------------------------------------------------------------*/

/* include this first, FD_SETSIZE must be defined */
#include "eng.h"

#include <stdlib.h>
#include <stdio.h>

#include "pql_tree.h"

/***********************/
/* imported operations */
/***********************/
void setvar(char *var, char *value);
char *getvar(char *var);
void expvar(char *var);
void showvars();
extern int get_table(QueryOp *query, char *attr,
	      char *table, char *talias, int *depth);

/********************/
/* global variables */ 
/********************/
extern char histfile[];
extern int actkey;
extern int acttype;
extern char actcomp[];
extern char actname[];
extern int actintval;
extern float actfloatval;
extern double actdoubleval;
extern char actstrval[];
extern char actvar[];

static char tpath[NAMELEN];
static char *dbpath;
static char *varval;

QueryOp *queryjob;
InsertOp *insertjob;
UpdateOp *updatejob;
DeleteOp *deletejob;
CreateOp *createjob;
ExtendOp *extendjob;
ShrinkOp *shrinkjob;

struct Selection *actselection;
struct SelCond *actselcond[MAXLEVEL];
struct FromList *actfromlist;
struct TableSpec *acttablespec;
struct GroupCond *actgroupcond;
struct OrderCond *actordercond;
struct InsertOp *actinsertop;
struct InsertList *actinsertlist;
struct UpdateOp *actupdateop;
struct SetList *actsetlist;
struct Assignment *actassignment;
struct DeleteOp *actdeleteop;
struct ExtList *actextlist;
struct ShrinkList *actshrinklist;
struct Aspec *actaspec;

/* the following global variables are critical in case of subqueries */
/* so we declare for each query level one dedicated variable */
QueryOp *actqueryjob[MAXLEVEL];
struct Condition *actcondition[MAXLEVEL];
struct Condition *saved1condition[MAXLEVEL][MAXCOND], *saved2condition[MAXLEVEL];
struct Predicate *actpredicate[MAXLEVEL];

struct ExprList *actexprlist;
struct Expr *actexpr, *saved1expr[MAXEXPR], *saved2expr;
struct AttrSpecList *actattrspeclist, *tmpattrspeclist;
struct Function *actfunction;
struct FuncArg *actfuncarg;
struct AttrSpec *actattrspec;
struct ConstantList *actconstantlist, *tmpconstantlist;
struct Literal *actliteral;

int condcount=0;
int expcount=0;
int actrule; /* remember to the current rule */
int actdepth=0; /* query depth */
int actcast;
int attnum=0; /* number of scanned attributes */
int parsephase;
int i;
ATable attable[ATABLESIZE];

%}

%union {
   int intval;
   double floatval;
   char *strval;
   int subtok;
}

	/* literals */
%token	NAME
%token	STRING
%token	INTNUM 
%token  FLOATNUM
%token  DOUBLENUM

	/* operators */
%left	OR
%left	AND
%left	NOT
%left	COMPARISON
%left	'+' '-'
%left	'*' '/'

	/* literal keyword tokens */
%token ALL AND AFUNC ANY AS ASC AVG 
%token BTYPE BY 
%token CHAR COUNT CREATE
%token DELETE DESC DISTINCT 
%token ENV EXIT EXISTS EXTEND 
%token FROM FTYPE
%token GROUP GET 
%token HAVING 
%token IN INSERT INT INTO INVOKE IS 
%token KEY 
%token LIKE LENGTH LIST
%token MAX MIN 
%token NOT NULLVAL 
%token OR ORDER 
%token PRINT
%token REAL RESET
%token SELECT SET SHRINK SUM STATS
%token TABEGIN TACOMMIT TAABORT TO 
%token UPDATE VALUES WHERE 

%%
pql:      pql_stat pql | pql_stat

/***** PQL statement *****/
pql_stat:	 { queryjob=NULL; } pql_query ';'
{ 
  fprintf(stderr,"Executing PQL query ...\n");
  if (exec_query(queryjob) != -1) 
    fprintf(stderr, "PQL query job completed.\n");
  clean_query(queryjob);
  attnum=0; actdepth=0;						}
|	 { insertjob=NULL; } pql_insert ';'
{   
  fprintf(stderr,"Executing PQL insert ...\n");
  if (exec_insert(insertjob) != -1)  {
    fprintf(stderr, "PQL insert job completed.\n");
    clean_insert(insertjob); 		
  } else {
    clean_insert(insertjob);
    return(1);                                                   
  }                                                              }
|	 { updatejob=NULL; } pql_update ';'
{ 
  fprintf(stderr, "Executing PQL update ...\n");
  if (exec_update(updatejob) != -1) {
    fprintf(stderr, "PQL update job completed.\n");
    clean_update(updatejob);	
  } else {
    clean_update(updatejob);
    return(1);                                                   
  }                                                              }
|	 { deletejob=NULL; } pql_delete ';'
{ 
  fprintf(stderr, "Executing PQL delete ...\n");
  if (exec_delete(deletejob) != -1) {
    fprintf(stderr, "PQL delete job completed.\n");
    clean_delete(deletejob);		
  } else {
    clean_delete(deletejob);
    return(1);
  }                                                              }
|	 { createjob=NULL; } pql_create ';'
{ 
  fprintf(stderr, "Executing PQL create ...\n");
  if (exec_create(createjob) != -1)
    fprintf(stderr, "PQL create job completed.\n");
  clean_create(createjob);					}
|	 { extendjob=NULL; } pql_extend ';'
{ 
  fprintf(stderr, "Executing PQL extend ...\n");
  if (exec_extend(extendjob) != -1)
    fprintf(stderr, "PQL extend job completed.\n");
  clean_extend(extendjob);					}
  |	 { shrinkjob=NULL; } pql_shrink ';'
{ 
  fprintf(stderr, "Executing PQL shrink ...\n");
  if (exec_shrink(shrinkjob) != -1)
    fprintf(stderr, "PQL shrink job completed.\n");
  clean_shrink(shrinkjob);					}
  |	 INVOKE NAME ';'
{ if (exec_invoke(actname) != -1) 
    fprintf(stderr, "PQL invoke job completed.\n"); 		}
  |	 STATS NAME ';'
{ if (exec_stats(actname) != -1) 
    fprintf(stderr, "PQL stats job completed.\n"); 		}
  |      TABEGIN NAME ';'
{ if (exec_begin(actname) != -1)
    fprintf(stderr, "PQL transaction started on %s\n", actname);   }
  |      TACOMMIT NAME ';'
{ if (exec_commit(actname) != -1)
    fprintf(stderr, "PQL transaction commited on %s\n", actname);  }
  |      TAABORT NAME ';'
{ if (exec_abort(actname) != -1)
    fprintf(stderr, "PQL transaction aborted on %s\n", actname);  }
  |      RESET NAME ';'
{ if (exec_reset(actname) != -1)
    fprintf(stderr, "PQL reset completed on %s\n", actname);       }
  |	 EXIT ';'
{ if (write_history(histfile) != 0)
    perror("PQL-ERROR:");

  if (history_truncate_file(histfile, HISTLINES) != NULL)
    perror("PQL-ERROR:");

  fprintf(stderr, "PQL terminated.\n"); 
  exit(0); /* just in this case we force to leave */		}
  |     SET NAME
{ strcpy(actvar, actname) ; } 
  STRING  ';'
{ setvar(actvar, actstrval);    				}
  |     GET NAME ';'
{ if ((varval = getvar(actname)) != NULL)
    printf("%s is %s\n", actname, varval);			}
  |     ENV ';'
{ showvars();  							}
  | 	PRINT STRING ';'
{ expvar(actstrval);
  printf("%s", actstrval);                                      }
  |     LIST ';'
{ listtables();                                                 }
 ;


/***** PQL_QUERY *****/

pql_query:	SELECT 
{ if ((actqueryjob[actdepth]=(QueryOp*)malloc(sizeof(QueryOp))) == NULL) {
	perror("malloc");	
	exit(1);
  }
  actqueryjob[actdepth]->selectmode = NOSELMODE;
  actqueryjob[actdepth]->depth=actdepth;
  actqueryjob[actdepth]->sqbuf=NULL;

  /* set up root job */
  if (actdepth == 0) {
        queryjob=actqueryjob[actdepth];
	queryjob->prev=NULL;
  } else {
        actqueryjob[actdepth]->prev = actqueryjob[actdepth-1];
  }								
  if ((actqueryjob[actdepth]->selectionptr = 
  (Selection*)malloc(sizeof(Selection))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actselection = actqueryjob[actdepth]->selectionptr; 	
  parsephase = SELECTION;					} selframe
{ if ((actqueryjob[actdepth]->selcondptr = 
  (SelCond*)malloc(sizeof(SelCond))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actselcond[actdepth] = actqueryjob[actdepth]->selcondptr; 		
  parsephase = CONDITION;					} selcond
  ;

/***** SELFRAME ******/
 selframe: 	distinct_select
{ actqueryjob[actdepth]->countit=0;                             }
| 		COUNT '(' distinct_select ')'
{ actqueryjob[actdepth]->countit=1;                             }


/***** DISTINCT_SELECT *****/

 distinct_select: DISTINCT selection
{ actqueryjob[actdepth]->distinct = 1; 				}  
|		selection
{ actqueryjob[actdepth]->distinct = 0; 				}  
;

/***** SELECTION *****/
 selection:    '*' 
{ actselection->exprlistptr = NULL;
  actqueryjob[actdepth]->selectmode = STAR; 			}
  |		
{ if ((actselection->exprlistptr = 
  (ExprList*)malloc(sizeof(ExprList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexprlist = actselection->exprlistptr;		
  actqueryjob[actdepth]->selectmode = PROJECTION;		} exprlist 
  ;

/***** SELCOND *****/

selcond:	FROM 
{ if ((actselcond[actdepth]->fromlistptr = 
  (FromList*)malloc(sizeof(FromList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actfromlist = actselcond[actdepth]->fromlistptr;		} fromlist 
                                                                  wherecond 
{ actselcond[actdepth]->wherecondptr=actcondition[actdepth];	} groupcond
{ actselcond[actdepth]->groupcondptr=actgroupcond;		} ordercond
{ actselcond[actdepth]->ordercondptr=actordercond;		}
  ;

/**** FROMLIST *****/            

/* fromlist: ms1 tablespec | ms1 tablespec ',' fromlist */

fromlist:	ms1 tablespec
{ FromList *flcheck;

  /* check for ambigious tables */
  for (flcheck=actselcond[actdepth]->fromlistptr; 
       flcheck != actfromlist; 
       flcheck = flcheck->next) {
    if (!strcmp(actfromlist->tablespecptr->tablename, 
		flcheck->tablespecptr->tablename)
	&& !strcmp(actfromlist->tablespecptr->tablealias, 
		   flcheck->tablespecptr->tablealias)) {
      fprintf(stderr, "PQL-ERROR: ambigious table specification\n");
      return;
    }
  }                                                             }
|  ms1 tablespec ','
{ if ((actfromlist->next=
       (FromList*)malloc(sizeof(FromList))) == NULL) {
     perror("malloc");
     exit(1);
  }
  actfromlist = actfromlist->next;                              } fromlist
  ;

ms1: /* empty */ 
{ if ((actfromlist->tablespecptr=
  (TableSpec*)malloc(sizeof(TableSpec))) == NULL) {
	perror("malloc");
	exit(1);
  }
  acttablespec=actfromlist->tablespecptr;		
  actfromlist->next=NULL;					}
  ;

/***** TABLESPEC *****/

tablespec:	 tablename tablealias | tablename ;

tablename:	NAME 
{     
  dbpath = getvar(VN_DBPATH);
  strcpy(tpath, dbpath);
  strcat(tpath, actname);
  if (!eng_tst(tpath)) {
    strcpy(acttablespec->tablename, actname);
    /* the default alias value is the name of the table */
    strcpy(acttablespec->tablealias, actname);
  } else {
      fprintf(stderr, "PQL-ERROR: cannot access relation %s\n",actname);
      return;
    } 								}
  ;

tablealias:	NAME 
{ 
  strcpy(acttablespec->tablealias, actname); 			} 
  ;

/***** WHERECOND *****/

wherecond:	{ actcondition[actdepth] = NULL; }
  |		WHERE condition
  ;
 
/***** GROUPCOND *****/

groupcond:	{ actgroupcond = NULL; }
  |		GROUP BY	
{ actqueryjob[actdepth]->selectmode = GROUPING;
  if ((actgroupcond = 	
  (GroupCond*)malloc(sizeof(GroupCond))) == NULL) {
	perror("malloc");
	exit(1);
      } 							} attrspec
{ actgroupcond->attrspecptr=actattrspec;			} havingcond
{ actgroupcond->havingcondptr=actcondition[actdepth];		}
  ;

havingcond:	{ actcondition[actdepth] = NULL; }
  |		HAVING condition 
  ;

/***** ORDERING *****/

ordercond:	{ actordercond = NULL; }
  |		ORDER BY 
{ if ((actordercond = 
  (OrderCond*)malloc(sizeof(OrderCond))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actattrspeclist = NULL;					} attrspeclist
{ actordercond->attrspeclistptr = actattrspeclist;		} ordering
  ;

ordering: ASC
{ actordercond->order = ASC; }
  |
	  DESC
{ actordercond->order = DESC; }
  ;

/***** PQL_INSERT *****/

pql_insert:	INSERT INTO 
{ if ((insertjob=(InsertOp*)malloc(sizeof(InsertOp))) == NULL) {
	perror("malloc");	
	exit(1);

  }								} NAME 
{ strcpy(insertjob->tablename, actname);			} insertlist
{ insertjob->insertlistptr = actinsertlist;			} 
  ;

insertlist:	{ actdepth++; } pql_query
{ actdepth--;
  if ((actinsertlist=
  (InsertList*)malloc(sizeof(InsertList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actinsertlist->queryopptr = actqueryjob[actdepth+1];
  actinsertlist->constantlistptr = NULL;
  actinsertlist->rule = 1;					}
  |		VALUES 
{ if ((actinsertlist=
  (InsertList*)malloc(sizeof(InsertList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actinsertlist->queryopptr = NULL;
  actinsertlist->rule = 2;
  actconstantlist = NULL;					} constantlist
{ actinsertlist->constantlistptr = actconstantlist;		} 
  ;

/***** PQL_UPDATE *****/

pql_update:	UPDATE 
{ if ((updatejob=
  (UpdateOp*)malloc(sizeof(UpdateOp))) == NULL) {
	perror("mallloc");
	exit(1);
  }								} NAME SET 
{ strcpy(updatejob->tablename, actname);		
  if ((updatejob->setlistptr=
  (SetList*)malloc(sizeof(SetList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actsetlist = updatejob->setlistptr;				
  parsephase = ASSIGNMENT;					} setlist
{ parsephase = UPDATECOND;                                      } setcondition
  ; 

setcondition:	 /* empty */
{  updatejob->conditionptr = NULL;				}	
  |
		WHERE condition
{  updatejob->conditionptr = actcondition[actdepth];		}
  ;

setlist:	assignment ',' 
{ actsetlist->assignmentptr=actassignment;
  if ((actsetlist->next=
  (SetList*)malloc(sizeof(SetList))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actsetlist=actsetlist->next;					} setlist

  | 		assignment
{ actsetlist->assignmentptr = actassignment;
  actsetlist->next = NULL;					}
  ;

assignment:	attrspec TO literal
{ if ((actassignment=
  (Assignment*)malloc(sizeof(Assignment))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actassignment->attrspecptr=actattrspec;
  actassignment->literalptr=actliteral;				}
  ;
	
/***** PQL_DELETE *****/

pql_delete:	DELETE FROM 
{ if ((deletejob=
  (DeleteOp*)malloc(sizeof(DeleteOp))) == NULL) {
	perror("malloc");
	exit(1);
  } 								} NAME 
{ strcpy(deletejob->tablename, actname);			
  parsephase=DELCOND;						} deletecond 
  ;

deletecond:	/* empty */
{ deletejob->conditionptr = NULL;				}
	
  |		WHERE condition
{ deletejob->conditionptr = actcondition[actdepth];		}
  ;

/***** PQL_CREATE *****/
pql_create:	CREATE
{ if ((createjob=
  (CreateOp*)malloc(sizeof(CreateOp))) == NULL) {
	perror("malloc");
	exit(1);
  }								} NAME AS
{ strcpy(createjob->tablename, actname);		
  if ((createjob->extlistptr=
  (ExtList*)malloc(sizeof(ExtList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actextlist = createjob->extlistptr;		      		} extlist
  ;

/***** PQL_EXTEND *****/
pql_extend:	EXTEND
{ if ((extendjob=
  (ExtendOp*)malloc(sizeof(ExtendOp))) == NULL) {
	perror("malloc");
	exit(1);
  }								} NAME TO
{ strcpy(extendjob->tablename, actname);		
  if ((extendjob->extlistptr=
  (ExtList*)malloc(sizeof(ExtList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actextlist = extendjob->extlistptr;		      		} extlist
  ;

extlist:	aspec ',' 
{ actextlist->aspecptr=actaspec;
  if ((actextlist->next=
  (ExtList*)malloc(sizeof(ExtList))) == NULL) {
	perror("malloc");
	exit(1);
  }	
  actextlist=actextlist->next;	       				} extlist

  | 		aspec
{ actextlist->aspecptr = actaspec;
  actextlist->next = NULL;					}
  ;

aspec:	KEY NAME typespec
{ if ((actaspec=
  (Aspec*)malloc(sizeof(Aspec))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actaspec->attrkey=actkey;
  strcpy(actaspec->attrname, actname);
  actaspec->attrtype = acttype;
  actaspec->attrsize = actintval;				}
  ;

typespec: FTYPE INTNUM
   |      BTYPE { actintval=0; } /* for basic types */

/***** PQL_SHRINK *****/
pql_shrink:	SHRINK
{ if ((shrinkjob=
  (ShrinkOp*)malloc(sizeof(ShrinkOp))) == NULL) {
	perror("malloc");
	exit(1);
  }								} NAME BY
{ strcpy(shrinkjob->tablename, actname);		
  if ((shrinkjob->shrinklistptr=
  (ShrinkList*)malloc(sizeof(ShrinkList))) == NULL) {
	perror("malloc");
	exit(1);
  } 
  actshrinklist = shrinkjob->shrinklistptr;		      	} shrinklist
  ;

shrinklist:	NAME ','
{ strcpy(actshrinklist->attrname,actname);
  if ((actshrinklist->next=
  (ShrinkList*)malloc(sizeof(ShrinkList))) == NULL) {
	perror("malloc");
	exit(1);
  }	
  actshrinklist=actshrinklist->next;  				} shrinklist

  | 		NAME
{ strcpy(actshrinklist->attrname, actname);
  actshrinklist->next = NULL;					}
  ;

/***** CONDITION *****/

condition:		 
{ if ((actpredicate[actdepth]=
  (Predicate*)malloc(sizeof(Predicate))) == NULL) {
	perror("malloc");
	exit(1);
  } 								} predicate 
{ if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=NULL;
  actcondition[actdepth]->cond2ptr=NULL;	
  actcondition[actdepth]->predicateptr=actpredicate[actdepth];
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_PREDICATE;			}

  |			NOT condition 
{ /* save built condition */
  saved2condition[actdepth]=actcondition[actdepth];
  if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=saved2condition[actdepth];
  actcondition[actdepth]->cond2ptr=NULL;
  actcondition[actdepth]->predicateptr=NULL;
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_NOT;			}

 |		        condition AND
{ saved1condition[actdepth][condcount]=actcondition[actdepth]; 
  condcount++;		                                        } 
		 	condition 
{ condcount--;
  saved2condition[actdepth]=actcondition[actdepth]; 			
  if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=saved1condition[actdepth][condcount];
  actcondition[actdepth]->cond2ptr=saved2condition[actdepth];
  actcondition[actdepth]->predicateptr=NULL;
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_AND;			}

  |		        condition OR
{ saved1condition[actdepth][condcount]=actcondition[actdepth];	
  condcount++;                                                    } 
		 	condition
{ condcount--;
  saved2condition[actdepth]=actcondition[actdepth];		
  if ((actcondition[actdepth]=
  (Condition*)malloc(sizeof(Condition))) == NULL) {
	perror("malloc");
	exit(1);	
  }
  actcondition[actdepth]->cond1ptr=saved1condition[actdepth][condcount]; 
  actcondition[actdepth]->cond2ptr=saved2condition[actdepth];
  actcondition[actdepth]->predicateptr=NULL;
  actcondition[actdepth]->negate=0;
  actcondition[actdepth]->rule=COND_OR;				}
  |	'(' condition ')'  /* support embr. condition */
  ;


/***** PREDICATE *****/

predicate:	expr COMPARISON 
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);	} expr
{ actpredicate[actdepth]->expr2ptr=actexpr;			
  actpredicate[actdepth]->marked = UNMARKED;
  actpredicate[actdepth]->rule = PRED_EXPR;			}
  

  |		expr COMPARISON '('
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);
  actdepth++;							} pql_query 
{ actdepth--; 		
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_QUERY;			} ')'

  |		expr COMPARISON ALL '(' 
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);
  actdepth++;							} pql_query 
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];		
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_ALL_QUERY;		} ')'

  |		expr COMPARISON ANY '(' 
{ actpredicate[actdepth]->expr1ptr=actexpr;
  actpredicate[actdepth]->comparison=getcompid(actcomp);
  actdepth++;							} pql_query 
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];		
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_ANY_QUERY;		} ')'

  |		expr IN '(' 
{ actpredicate[actdepth]->expr1ptr=actexpr;				
  actdepth++;							} pql_query 
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];	
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_IN_QUERY;			} ')'

  |		expr IN 
{ actpredicate[actdepth]->expr1ptr=actexpr;				
  if ((actpredicate[actdepth]->exprlistptr=
  (ExprList*)malloc(sizeof(ExprList))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actexprlist=actpredicate[actdepth]->exprlistptr;		} exprlist
{ actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_IN_ELIST;   		}

  | 		EXISTS '(' { actdepth++; } pql_query ')'
{ actdepth--;
  actpredicate[actdepth]->queryopptr=actqueryjob[actdepth+1];
  actpredicate[actdepth]->marked = 0;
  actpredicate[actdepth]->rule = PRED_EXISTS;			}

  |		attrspec IS LIKE literal
{ actpredicate[actdepth]->attrspecptr=actattrspec;			
  actpredicate[actdepth]->literalptr=actliteral;
  actpredicate[actdepth]->marked = 0; 
  actpredicate[actdepth]->rule = PRED_LIKE;			}
  ;


/***** EXPRLIST *****/

exprlist:	expr ',' 
{ actexprlist->exprptr=actexpr;
 if ((actexprlist->next=
 (ExprList*)malloc(sizeof(ExprList))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actexprlist=actexprlist->next;				} exprlist

  |		expr 
{ actexprlist->exprptr = actexpr; 
  actexprlist->next = NULL;					}
  ;

/***** EXPR *****/

expr:		literal
{ if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->rule=EXPR_LIT;
  actexpr->literalptr=actliteral;				}
  
  |		attrspec
{ if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->rule=EXPR_ATTSPEC;
  actexpr->attrspecptr=actattrspec;				}
 

  |		expr '+' 
{ saved1expr[expcount]=actexpr; 				
  expcount++;                                                  }
		expr
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_PLUS;					}


  |		expr '-' 
{ saved1expr[expcount]=actexpr;
  expcount++; 		         				}
		expr
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_MINUS;					}

  |		expr '*' 
{ saved1expr[expcount]=actexpr;
  expcount++; 		           				}
		expr
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_MUL;					}

  |		expr '/' 
{ saved1expr[expcount]=actexpr; 			
  expcount++;                                                 	}
		expr
{ expcount--;
  saved2expr=actexpr;
  if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actexpr->expr1ptr=saved1expr[expcount];
  actexpr->expr2ptr=saved2expr;
  actexpr->rule = EXPR_DIV;					}

  | 		function  
{ if ((actexpr=
  (Expr*)malloc(sizeof(Expr))) == NULL) {
	perror("malloc");
	exit(1);
  }
  if (actqueryjob[actdepth]->selectmode == PROJECTION)
	actqueryjob[actdepth]->selectmode = AGREGATION;
  actexpr->functionptr=actfunction;
  actexpr->rule = EXPR_FUNC;					}
  ;

/***** ATTRSPECLIST *****/

attrspeclist:	attrspec ',' 
{ if (actattrspeclist == NULL) {
    if ((actattrspeclist=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
	 	perror("malloc");
		exit(1);
    }
    actattrspeclist->attrspecptr = actattrspec;
    tmpattrspeclist = actattrspeclist;
  } else {
    if ((tmpattrspeclist->next=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
 		perror("malloc");
		exit(1);
    }
    tmpattrspeclist->next->attrspecptr = actattrspec;	
    tmpattrspeclist = tmpattrspeclist->next;			
  }								} attrspeclist

  |		attrspec
{ if (actattrspeclist == NULL) {
    if ((actattrspeclist=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
	 	perror("malloc");
		exit(1);
    }
    actattrspeclist->attrspecptr = actattrspec;
    actattrspeclist->next = NULL;
  } else {
    if ((tmpattrspeclist->next=
    (AttrSpecList*)malloc(sizeof(AttrSpecList))) == NULL) {
 		perror("malloc");
		exit(1);
    }   
    tmpattrspeclist->next->attrspecptr = actattrspec;
    tmpattrspeclist->next->next = NULL;
  }							}
  ; 	

/***** FUNCTION *****/

function:	functype '(' 
{ 
  if ((actfunction=
  (Function*)malloc(sizeof(Function))) == NULL) {
	perror("malloc");
	exit(1);
  }
  actfunction->rule=actrule;					} expr 
{ actfunction->exprptr = actexpr;                               } ')'
  ;


functype:	AVG	
{ actrule=FUNC_AVG; 						}
  |		MIN	
{ actrule=FUNC_MIN; 						}
  |		MAX	
{ actrule=FUNC_MAX; 						}
  |		SUM	
{ actrule=FUNC_SUM; 						}
  ;		

/***** ATTRSPEC *****/

attrspec: typecast NAME
{ if ((actattrspec=
  (AttrSpec*)malloc(sizeof(AttrSpec))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actattrspec->cast = actcast;

  /* make entry in global attribute table */
  attable[attnum].attrspec=actattrspec;
  attable[attnum].attrspec->access=NONE; 
  attable[attnum].phase=parsephase;
  attable[attnum].used=actdepth;

  if (parsephase == CONDITION) {
    /* find out the query depth of the given attribute */
    actattrspec->tablename[0] = '\0';
    if (get_table(actqueryjob[actdepth], 
	actname, 
	actattrspec->tablename, 
	actattrspec->talias, 
	&attable[attnum].depth) 
	!= 0) {
      fprintf(stderr, "PQL-ERROR: cannot get query depth for attribute %s\n", actname);
      return;
    }
  } else {
    attable[attnum].depth=actdepth;
    actattrspec->talias[0]='\0';					
    actattrspec->tablename[0]='\0';		
  }
  attnum++;
  if (attnum >= ATABLESIZE) {
    fprintf(stderr, "PQL-ERROR: Too many attributes - attribute table exceeded\n");
    return;
  }
  strcpy(actattrspec->attrname, actname);			}
  |	typecast NAME '.' 
{ if ((actattrspec=
  (AttrSpec*)malloc(sizeof(AttrSpec))) == NULL) {
 	perror("malloc");
	exit(1);
  }
  actattrspec->cast = actcast;

  /* make entry in global attribute table */
  attable[attnum].attrspec=actattrspec;
  attable[attnum].attrspec->access=NONE; 
  attable[attnum].phase=parsephase;
  attable[attnum].used=actdepth;
 
  if (attnum >= ATABLESIZE) {
    fprintf(stderr, "PQL-ERROR: Too many atributes - attribute table exceeded\n");
    return;
  }
  actattrspec->talias[0]='\0';					
  strcpy(actattrspec->tablename, actname);			} NAME
{ strcpy(actattrspec->attrname, actname);			
  if (parsephase == CONDITION) {
    /* find out the query depth of the given attribute */
    if (get_table(actqueryjob[actdepth], 
		  actname,
		  actattrspec->tablename, 
		  actattrspec->talias, 
		  &attable[attnum].depth) 
	!= 0) {
      fprintf(stderr, "PQL-ERROR: cannot get query depth for attribute %s\n", actname);
      return;
    }
  } else {
    attable[attnum].depth=actdepth;
  }
  attnum++;							}
  ;

/***** TYPECAST *****/
typecast: /* empty */
{ actcast = T_NONE; }
| BTYPE 
{ actcast = acttype; } 


/***** CONSTANTLIST *****/

constantlist:	literal ',' 
{ if (actconstantlist == NULL) {
    if ((actconstantlist=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    actconstantlist->literalptr=actliteral;
    tmpconstantlist = actconstantlist;
  } else {
    if ((tmpconstantlist->next=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    tmpconstantlist->next->literalptr = actliteral;
    tmpconstantlist = tmpconstantlist->next;
  }								} constantlist

  |		literal
{ if (actconstantlist == NULL) {
    if ((actconstantlist=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    actconstantlist->literalptr = actliteral;
    actconstantlist->next = NULL;
  } else {
    if ((tmpconstantlist->next=
    (ConstantList*)malloc(sizeof(ConstantList))) == NULL) {
		perror("malloc");
		exit(1);
    }
    tmpconstantlist->next->literalptr = actliteral;
    tmpconstantlist->next->next = NULL;
  }								}
  ;

/***** LITERAL *****/

literal:	INTNUM
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_LONG;
   actliteral->intval=actintval;				}

  |		FLOATNUM
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_FLOAT;
   actliteral->floatval=actfloatval;				}
  |		DOUBLENUM
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_DOUBLE;
   actliteral->doubleval=actdoubleval;				}
  |		STRING
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=T_CHAR;
   strcpy(actliteral->strval, actstrval);			}
   ;
   |		NULLVAL
{ if ((actliteral= 
  (Literal*)malloc(sizeof(Literal))) == NULL) {
	perror("malloc");
	exit(1);
   }
   actliteral->rule=NVAL;					}
   ;	


%%

/* evaluate comparison */

int getcompid(char *compstr)
{ 
  if (compstr[0] == '=' && compstr[1] == '\0')
    return EQU;
  else if (compstr[0] == '<') {
    if (compstr[1] == '>')
      return NEQUAL;
    else if (compstr[1] == '=')
      return LEQUAL;
    else if (compstr[1] == '\0')
      return LESS;
    else return INVALID;
  }
  else if (compstr[0] == '>') {
    if (compstr[1] == '=')
      return MEQUAL;
    else if (compstr[1] == '\0')
      return MORE;
    else return INVALID;
  }
  else return INVALID;
}


void pql_cleanup() 
{
  /* cleanup after a pql operation */
  attnum=0;
  actdepth=0;
}
	
