/*-------------------------------------------------------------------------
 *
 * fe-pqstubs.c--
 *    These are frontend versions of various error handling and
 *    memory mgt routines used in libpq.  
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/libpq/fe-pqstubs.c,v 1.4 1995/03/16 23:35:44 andrew Exp
 *
 * NOTES
 *    These routines are NOT compiled into the postgres backend,
 *    rather they end up in libpq.a.
 *
 *-------------------------------------------------------------------------
 */
#include <stdio.h>
#include <sys/types.h>
#include <stdarg.h>

#include "c.h"
#undef palloc
#undef pfree
#include "utils/exc.h"
#include "utils/elog.h"

Exception FailedAssertion;

/* ----------------
 *	palloc (frontend version)
 *	pfree (frontend version)
 * ----------------
 */
Pointer
palloc(Size size)
{
    Pointer p;

    p = malloc(size);
    if (!p)
	return((Pointer) NULL);
    memset(p, 0, size);
    return(p);
}

void
pfree(Pointer pointer)
{
    free(pointer);
}

Pointer
palloc_debug(String file, int line, Size size)
{
    return malloc(size);
}

void
pfree_debug(String file, int line, Pointer pointer)
{
    free(pointer);
}

/* ----------------
 *	ExceptionalCondition (frontend version)
 * ----------------
 */
int
ExceptionalCondition( String conditionName,
		      Exception *exceptionP,
		      String detail,
		      String fileName,
		      int lineNumber)
{
    fprintf(stderr, "ExceptionalCondition called (%s,%s,file %s, line %d)!\n",conditionName,detail,fileName,lineNumber);
    exit(1);
}

/* ----------------
 *	ExcRaise (frontend version)
 * ----------------
 */
void
ExcRaise(Exception *arg1,
	 ExcDetail string,
	 ExcData ignore,
	 ExcMessage ignore2)
{
    fprintf(stderr, "Error: %s\n", (char *)string);
    exit(1);
}

/* ----------------
 *	elog (frontend version)
 * ----------------
 */
void elog(int lev, char* fmt, ...)
{
    va_list ap;

    va_start(ap,fmt);
    va_end(ap);
    fprintf(stderr, "FATAL: error level %d: %s\n", lev, fmt);
    if (lev == FATAL)
	exit(1);
}

/* ----------------
 *	AssertionFailed (frontend version)
 * ----------------
 */
void
AssertionFailed( String assertionName,
		 String fileName,
		 int lineNumber)
{
    if (!PointerIsValid(assertionName) || !PointerIsValid(fileName))
	fprintf(stderr, "AssertionFailed: bad arguments\n");
    else
	fprintf(stderr,
		"AssertionFailed(\"%s\", File: \"%s\", Line: %d)\n",
		assertionName, fileName, lineNumber);
#ifdef SABER
    stop();
#endif
    exit(1);
}
