/*-------------------------------------------------------------------------
 *
 * pgtclCmds.h--
 *    declarations for the C functions which implement pg_* tcl commands
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * pgtclCmds.h,v 1.3 1995/03/11 01:00:51 jolly Exp
 *
 *-------------------------------------------------------------------------
 */

#ifndef PGTCLCMDS_H
#define PGTCLCMDS_H

#include "tcl.h"

typedef enum {CONNECTION_OK,
	      CONNECTION_BAD}  ConnStatusType;

typedef enum {
  PGRES_EMPTY_QUERY = 0,
  PGRES_COMMAND_OK,  /* a query command that doesn't return */
                    /* anything was executed properly by the backend */
  PGRES_TUPLES_OK,  /* a query command that returns tuples */
                   /* was executed properly by the backend, PGresult */
                   /* contains the resulttuples */
  PGRES_BAD_RESPONSE, /* an unexpected response was recv'd from the backend */
  PGRES_NONFATAL_ERROR,
  PGRES_FATAL_ERROR

} ExecStatusType;

typedef struct PGresAttDesc {
  char* name; /* type name */
  int adtid;  /* type id */
  int adtsize; /* type size */
} PGresAttDesc;

typedef char* PGresAttValue;     /* use char* for Attribute values */

/* PGconn encapsulates a connection to the backend */
typedef struct pg_conn{
  FILE* Pfin;
  FILE* Pfout;
  void* port; /* really a Port* */
  char* errorMessage;
  char* dbName;
} PGconn;

/* unlike libpq, we assume that queries only return in one group */
typedef struct pg_result{
  int ntups;
  int numAttributes;
  PGresAttDesc *attDescs;
  PGresAttValue* *tuples; /* each PGresTuple is an array of PGresAttValue's */
  int tupArrSize;         /* size of tuples array allocated */
  ExecStatusType resultStatus;
  PGconn* conn;
} PGresult;


/* **************************/
/* registered Tcl functions */
/* **************************/
extern int Pg_connect(
    ClientData cData, Tcl_Interp *interp, int argc, char* argv[]);
extern int Pg_disconnect(
    ClientData cData, Tcl_Interp *interp, int argc, char* argv[]);
extern int Pg_exec(
    ClientData cData, Tcl_Interp *interp, int argc, char* argv[]);
extern int Pg_result(
    ClientData cData, Tcl_Interp *interp, int argc, char* argv[]);


/* in pgconnect.c */
extern ConnStatusType Pgtcl_connectDB(char* dbName, char* host, char* tty, 
				      char* options, int port, PGconn* conn);
extern void Pgtcl_disconnectDB(PGconn* conn);

/* in pgexec.c */
extern PGresult* Pgtcl_pgexec(PGconn* conn, char* query);
extern void freePGresult(PGresult* res);

/* in pgmisc.c */
/* pqGets and pqPuts send strings to the file stream, returns 0 if successful*/
extern int pqGets(char* s, int maxlen, FILE* stream);
extern int pqPuts(char* s, FILE* stream );

/* get a n-byte integer from the stream into result */
/* returns 0 if successful */
extern int pqGetInt(int* result, int n, FILE* stream );

/* backend-dependent constants */
/* same as ELOG_MAXLEN from elog.h */
#define MAX_ERRMSG_LEN 4096

/* max length of message to send to  */
#define MAX_MESSAGE_LEN 8193

/* maximum number of fields in a tuple */
#define BYTELEN 8
#define MAX_FIELDS 512

#endif /*PGTCLCMDS_H*/

