/*-------------------------------------------------------------------------
 *
 * oidcompos.h--
 *    prototype file for the oid {char16,int4} composite type functions.   
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * oidcompos.h,v 1.1.1.1 1994/11/07 05:19:47 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef	OIDCOMPOS_H
#define OIDCOMPOS_H

/* oidint4.c */
OidInt4 oidint4in(char *o);
char *oidint4out(OidInt4 o);
bool oidint4lt(OidInt4 o1, OidInt4 o2);
bool oidint4le(OidInt4 o1, OidInt4 o2);
bool oidint4eq(OidInt4 o1, OidInt4 o2);
bool oidint4ge(OidInt4 o1, OidInt4 o2);
bool oidint4gt(OidInt4 o1, OidInt4 o2);
bool oidint4ne(OidInt4 o1, OidInt4 o2);
int oidint4cmp(OidInt4 o1, OidInt4 o2);
OidInt4 mkoidint4(Oid v_oid, uint32 v_int4);

/* oidint2.c */
OidInt2 oidint2in(char *o);
char *oidint2out(OidInt2 o);
bool oidint2lt(OidInt2 o1, OidInt2 o2);
bool oidint2le(OidInt2 o1, OidInt2 o2);
bool oidint2eq(OidInt2 o1, OidInt2 o2);
bool oidint2ge(OidInt2 o1, OidInt2 o2);
bool oidint2gt(OidInt2 o1, OidInt2 o2);
bool oidint2ne(OidInt2 o1, OidInt2 o2);
int oidint2cmp(OidInt2 o1, OidInt2 o2);
OidInt2 mkoidint2(Oid v_oid, uint16 v_int2);

/* oidchar16.c */
OidChar16 oidchar16in(char *inStr);
char *oidchar16out(OidChar16 oidname);
bool oidchar16lt(OidChar16 o1, OidChar16 o2);
bool oidchar16le(OidChar16 o1, OidChar16 o2);
bool oidchar16eq(OidChar16 o1, OidChar16 o2);
bool oidchar16ne(OidChar16 o1, OidChar16 o2);
bool oidchar16ge(OidChar16 o1, OidChar16 o2);
bool oidchar16gt(OidChar16 o1, OidChar16 o2);
int oidchar16cmp(OidChar16 o1, OidChar16 o2);
OidChar16 mkoidchar16(Oid id, char *name);

#endif	/* OIDCOMPOS_H */
