/*
 * The following are the BSD labels for the timer types.
 */
#define	ITIMER_REAL		0	/* Real time */
#define	ITIMER_VIRTUAL		1	/* Per-process time */
#define	ITIMER_PROF		2	/* Per-process user time */

struct timeval {
	int	tv_sec;		/* seconds */
	int	tv_usec;	/* microseconds */
};

 /*
  * Make timer interval for BSD "ITIMER_REAL"
  * timers and sleep functions.
  */

#define TOD_MAX_SECONDS 100000000

/*
 * Operations on timevals.
 *
 * Note that timercmp only works for cmp values of !=, >, and <.
 */
#define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
#define	timerclear(tvp)		(tvp)->tv_sec = (tvp)->tv_usec = 0
#define	timercmp(tvp, fvp, cmp)						\
	((tvp)->tv_sec cmp (fvp)->tv_sec ||				\
	 (tvp)->tv_sec == (fvp)->tv_sec &&				\
	 (tvp)->tv_usec cmp (fvp)->tv_usec)

struct	itimerval {
	struct		timeval it_interval; /* timer interval */
	struct		timeval it_value; /* current value */
};
