/*-------------------------------------------------------------------------
 *
 * port-protos.h--
 *    port-specific prototypes for NetBSD 1.0
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * port-protos.h,v 1.1 1995/05/08 01:08:21 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef PORT_PROTOS_H
#define PORT_PROTOS_H

#include <sys/types.h>
#include <nlist.h>
#include <link.h>

#include "fmgr.h"			/* for func_ptr */
#include "utils/dynamic_loader.h"

/* dynloader.c */
/*
 * Dynamic Loader on NetBSD 1.0.
 *
 * this dynamic loader uses the system dynamic loading interface for shared 
 * libraries (ie. dlopen/dlsym/dlclose). The user must specify a shared
 * library as the file to be dynamically loaded.
 *
 */
#define	pg_dlopen(f)	netbsd_dlopen(f, 1)
#define	pg_dlsym	netbsd_dlsym
#define	pg_dlclose	netbsd_dlclose
#define	pg_dlerror	netbsd_dlerror

#endif /* PORT_PROTOS_H */
