/*-------------------------------------------------------------------------
 *
 * io.c--
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/parser/io.c,v 1.2 1995/05/08 01:08:14 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#include <stdio.h>
#include "utils/elog.h"
#include "io.h"

int StringInput;
char *TheString;
char *Ch;

void
init_io()
{
#if defined(PORTNAME_linux) || defined(PORTNAME_netbsd)
    extern void NewInput(void), DeleteBuffer(void);

    DeleteBuffer();
    NewInput();
#endif /* __linux__ || __NetBSD__ */

    Ch = NULL;
}

char
input()
{
#if defined(PORTNAME_linux) || defined(PORTNAME_netbsd)
    char DoInput(void);
    return DoInput();
#else
    char c;
    
    if (StringInput) {
	if (Ch == NULL) {
	    Ch = TheString;
	    return(*Ch++);
	} else if (*Ch == '\0') {
	    return(0);
	} else {
	    return(*Ch++);
	}
    } else {
	c = getchar();
	if (c == EOF) {
	    return(0);
	} else {
	    return(c);
	}
    }
#endif	/* linux || __NetBSD__ */
}

void
unput(char c)
{
#if defined(PORTNAME_linux) || defined(PORTNAME_netbsd)
    extern void DoUnput(char);
    return DoUnput(c);
#else
    
    if (StringInput) {
	if (Ch == NULL) {
	    elog(FATAL, "Unput() failed.\n");
	} else if (c != 0) {
	    *--Ch = c;
	}
    } else {
	ungetc(c, stdin);
    }
#endif /* __linux__ || __NetBSD__ */
}

