/*-------------------------------------------------------------------------
 *
 * archive.c--
 *    Support for planning scans on archived relations
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/optimizer/prep/archive.c,v 1.5 1995/03/17 20:26:28 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#include <stdio.h>		/* for sprintf() */
#include <sys/types.h>		/* for u_int in relcache.h */
#include "postgres.h"

#include "utils/rel.h"
#include "utils/elog.h"
#include "utils/palloc.h"
#include "utils/relcache.h"
#include "catalog/pg_class.h"
#include "nodes/pg_list.h"
#include "nodes/parsenodes.h"
#include "optimizer/prep.h"

void
plan_archive(List *rt)
{
    List *rtitem;
    RangeTblEntry *rte;
    TimeRange *trange;
    Oid reloid;
    Relation r;

    foreach(rtitem, rt) {
	rte = lfirst(rtitem);
	trange = rte->timeRange;
#if 0 /* fix me */
	if (lfirst(trange) != NIL) {
	    reloid = rte->relid;
	    r = RelationIdGetRelation(reloid);
	    if (r->rd_rel->relarch != 'n') {
		rte->archive = true;
	    }
	}
#endif
    }
}


/*
 *  find_archive_rels -- Given a particular relid, find the archive
 *			 relation's relid.
 */
List *
find_archive_rels(Oid relid)
{
    Relation arel;
    Name arelname;

    /*
     *  Archive relations are named a,XXXXX where XXXXX == the OID
     *  of the relation they archive.  Create a string containing
     *  this name and find the reldesc for the archive relation.
     */
    arelname = (Name) palloc(sizeof(NameData));
    sprintf(&arelname->data[0], "a,%ld", relid);
    arel = RelationNameGetRelation(arelname);
    pfree(arelname);

    return lconsi(arel->rd_id,
		   lconsi(relid, NIL));
}
