%{
/*-------------------------------------------------------------------------
 *
 * bootscanner.lex--
 *    a lexical scanner for the bootstrap parser
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/bootstrap/bootscanner.lex,v 1.4 1995/05/03 21:44:42 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#include "bootstrap/bootstrap.h"
#include "utils/portal.h" 
#include "access/xact.h"

#undef BOOTSTRAP
#include "bootstrap_tokens.h"

/* old versions of flex define this as a macro */
#if defined(yywrap)
#undef yywrap
#endif /* yywrap */

int	yylval;
int	yycolumn;
int	yyline;
#define NEWLINE() { yycolumn=0; yyline++; }

#ifdef PORTNAME_alpha
#define	YYTEXTCHAR	unsigned char
#else /* PORTNAME_alpha */
#define	YYTEXTCHAR	char
#endif /* PORTNAME_alpha */
%}

D	[0-9]
oct     \\{D}{D}{D}
Exp	[Ee][-+]?{D}+
id      ([A-Za-z0-9_]|{oct}|\-)+
sid     \"([^\"])*\"
arrayid	[A-Za-z0-9_]+\[{D}*\]

%%

open       	{ return(OPEN); }

close		{ return(XCLOSE); }

create		{ return(XCREATE); }

print		{ return(P_RELN); }

in		{ return(XIN); }
as		{ return(AS); }
to		{ return(XTO); }
OID             { return(OBJ_ID); }
bootstrap	{ return(BOOTSTRAP); }
_null_		{ return(NULLVAL); }

insert		{ return(INSERT_TUPLE); }

quit		{ return(QUIT); }

\%pstr          { printstrtable(); EMITPROMPT; }

\%phash     	{ printhashtable(); EMITPROMPT; }

".D" |
destroy		{ return(XDESTROY); }

".R" |
rename		{ return(XRENAME);}
attribute	{ return(ATTR); }
relation 	{ return(RELATION); }
","     	{ return(COMMA); }
":"		{ return(COLON); }
"="		{ return(EQUALS); }
"("		{ return(LPAREN); }
")"		{ return(RPAREN); }
add		{ return(ADD); }

[\n]      	{ NEWLINE(); }
[\t]		;
" "		; 

^\#[^\n]* ; /* drop everything after "#" for comments */


"declare"	{ return(XDECLARE); }
"build"		{ return(XBUILD); }
"indices"	{ return(INDICES); }
"macro"		{ return(MACRO); }
"index"		{ return(INDEX); }
"on"		{ return(ON); }
"using"		{ return(USING); }
"display"	{ return(DISPLAY); }
"show"		{ return(SHOW); }
"$"{id}		{ 
		    YYTEXTCHAR *in, *out;
		    for (in = out = yytext; *out = *in; ++out)
			if (*in++ == '\\')
			    *out = (unsigned char) MapEscape((char **) &in);
		    yylval = LookUpMacro((char*)&yytext[1]);
		    return(ID);
		}
{arrayid}	{
		    YYTEXTCHAR last, this, *p;

		    /*
		     * XXX arrays of "basetype" are always "_basetype".
		     *     this is an evil hack inherited from rel. 3.1.
		     * XXX array dimension is thrown away because we
		     *     don't support fixed-dimension arrays.  again,
		     *     sickness from 3.1.
		     */
		    for (p = yytext, last = '_'; *p && *p != '['; ++p) {
			this = *p;
			*p = last;
			last = this;
		    }
		    if (*p) {
			*p++ = last;
		    }
		    *p = '\0';
		    yylval = EnterString((char*)yytext);
		    return(ID);
		}
{id}	 	{ 
		    YYTEXTCHAR *in, *out;
		    for (in = out = yytext; *out = *in; ++out)
			if (*in++ == '\\')
			    *out = (unsigned char) MapEscape((char **) &in);
#if 0
		    *(out+1) = '\000';
#endif
		    yylval = EnterString((char*)yytext);
		    return(ID);
		}
{sid}		{
		    YYTEXTCHAR *in;
		    for (in = &yytext[1]; *in != '\"'; ++in)
			;
		    *in = 0;
		    yylval = EnterString((char*)&yytext[1]);
		    return(ID);
		}

(-)?{D}+"."{D}*({Exp})?	|
(-)?{D}*"."{D}+({Exp})?	|
(-)?{D}+{Exp}		{
			    yylval = EnterString((char*)yytext);
			    return(FLOAT);
			}


(-)?{D}+	{
		    yylval = EnterString((char*)yytext);
		    return(INT);
		}


.		{
		    printf("syntax error %d : -> %s\n", yyline, yytext);
		}



%%

yywrap()
{
    StartTransactionCommand();
    cleanup();
    CommitTransactionCommand();
    return;
}

yyerror(str)
    char *str;
{
    fprintf(stderr,"\tsyntax error %d : %s",yyline, str);
}
