/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * MODULE NAME: 	moveobject.c
 *
 * SCCSINFO:		@(#)moveobject.c	1.7 6/1/94
 *
 * ORIGINAL AUTHOR(S):  Johan Alm, ????
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *
 *   File containing the functions that copies a molecule from the
 *   source file (the one not compacted) the the destination file
 *   (the compacted one).Image,attributs and forward links are copied
 *   without any modifications.The backward lincks pointing at a
 *   not reached nod is removed.The molecule file entry is modified and
 *   copied to the new molecule file.
 *   All functions in this file contains the word "MOVE'.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "cutoff.h"
#include "dbserver.h"
#include "monitor.h"
#include "libshared.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_moveobject.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_cutoffmain.h"
#include "f_pointers.h"
#include "f_files.h"
#include "f_flag.h"
#include "f_packunpack.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static off_t move_datasection P_(( int ftblindex, off_t srcpos, int
                                    srcsize, MOLENTRYFIELD which ));

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/

/*  */
/**********************************************************************
 * Function: int MoveObject(LABEL label)
 *
 * Modifications:
 *      <list mods with name and date>
 */
int MoveObject(label)
  LABEL label;			/* label to molecule to be moved */
{
  FILEMOL molentry;		/* tmp entry in molecule file */
  static off_t srcmolpos;	/* old molecule file position */
  static off_t dstmolpos;	/* new molecule file position */
  off_t   dstdatpos;		/* new data section position */
  int filetableindex;
  int srcmolfd = -1;	/* molecule fd of file to be compacted */
  int dstmolfd = -1;	/* molecule fd of compacted file */

  if ((filetableindex = GetFilNo(label)) == FAIL)
    fatal_error(FATAL_GEN, "MoveObject", "couldn't get filetableindex");

  srcmolpos = GetFilPos(label);

  srcmolfd = molfileOfIndex(MOL, filetableindex, ARCHIVE);
  dstmolfd = molfileOfIndex(MOL, filetableindex, NEW);
  dstmolpos = LengthOfFile(dstmolfd);

  switch (srcmolpos) {
  case UNDEFINED_ENTRY:
    return UNDEFINED_ENTRY;
  case FAIL:
    fatal_error(FATAL_GEN, "MoveObject", "couldn't get srcmolpos");
  default:
    break;
  }

  if (GetEntry(srcmolfd, srcmolpos,(char *)&molentry,sizeof(FILEMOL)) == FAIL)
    fatal_error(FATAL_GEN, "MoveObject", "GetEntry failed");

  dstdatpos = move_datasection(filetableindex, (off_t)molentry.flink_filepos,
			       molentry.flink_size, FORWARD);
  molentry.flink_filepos = dstdatpos;
  dstdatpos = move_datasection(filetableindex, (off_t)molentry.blink_filepos,
			       molentry.blink_size, BACKWARD);
  molentry.blink_filepos = dstdatpos;
  dstdatpos = move_datasection(filetableindex, (off_t)molentry.attr_filepos,
			       molentry.attr_size, ATTRIBUTES);
  molentry.attr_filepos = dstdatpos;
  dstdatpos = move_datasection(filetableindex, (off_t)molentry.image_filepos,
			       molentry.image_size, IMAGE);
  molentry.image_filepos = dstdatpos;

  if ((write(dstmolfd, (char *)&molentry, sizeof(FILEMOL)))!= sizeof(FILEMOL))
    fatal_error(FATAL_IO, "MoveObject", (char *)NULL);

  if (ChangeFilPos(label, dstmolpos) == FAIL)
    fatal_error(FATAL_GEN, "MoveObject", "ChangeFilPos failed");
  return SUCCESS;
}


/*  */
/**********************************************************************
 * Function: static off_t move_datasection(FOUR PARAMETERS)
 * Parameters:
 *	int  ftblindex;
 *	off_t srcpos;
 *	int  srcsize;
 *	MOLENTRYFIELD which;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static off_t move_datasection(ftblindex, srcpos, srcsize, which)
  int ftblindex;
  off_t srcpos;
  int srcsize;
  MOLENTRYFIELD which;
{
  PACKEDBUFF pbuff;
  off_t dstpos = -1;
  int srcfd, dstfd;

  /* if size == 0 no need to move anything ... */
  if (srcsize == 0)
    return(0);

  srcfd = datfileOfIndex(DAT, ftblindex, ARCHIVE);
  dstfd = datfileOfIndex(DAT, ftblindex, NEW);

  if ((pbuff.buff = (char *)malloc((ALLOC_T)srcsize)) == NULL) 
    fatal_error(FATAL_MALLOC, "move_datasection", "pbuff.buff");

  pbuff.size = srcsize;
  pbuff.curp = 0;

  if (GetEntry(srcfd, srcpos, pbuff.buff, (unsigned)pbuff.size) == FAIL)
    fatal_error(FATAL_IO, "move_datasection", (char *)NULL);

  if (which == BACKWARD) {
    LINKGROUP *group, *gp;
    LINKS *fp;
    LINKITEM *prev, *cur, *next;

    if ((UnpackGroup(&group, &pbuff)) == FAIL)
      fatal_error(FATAL_GEN, "move_datasection", "UnpackGroup failed");

    prev = (LINKITEM *) NULL;
    for (gp = group; gp != (LINKGROUP *) NULL; gp = gp->nextgroup) {
      for (fp = gp->links; fp != (LINKS *) NULL; fp = fp->nextlinks) {
	prev = (LINKITEM *) NULL;
	for (cur = fp->linkitem; cur != (LINKITEM *) NULL; cur = next) {
	  next = cur->nextitem;
	  if ((cur->label != 0) && !is_flag_set(cur->label, CO_REACHED)) {
	    if (prev == (LINKITEM *) NULL)
	      fp->linkitem = next;
	    else
	      prev->nextitem = next;
	    free((FREEPTR *)cur);
	  } else {
	    prev = cur;
	  }
	}
      }
    }

    (void)PackGroup(group, &pbuff);	/* pack the group into buffer */
  }
  dstpos = LengthOfFile(dstfd);
  if (write(dstfd, pbuff.buff, (IOSIZE_T)pbuff.size) != pbuff.size)
    fatal_error(FATAL_IO, "move_datasection", (char *)NULL);

  free(pbuff.buff);
  return dstpos;
}
