/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	flag.c
 *
 * SCCSINFO:		@(#)flag.c	1.7 5/30/94
 *
 * ORIGINAL AUTHOR(S):  Jens M Hansen, ????
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *  File containing all functions of CUTOFF FLAGS module.
 *  FLAGS consists of a set of functions that operate on the flag file.
 *  All names of FLAGS functions contain the word "Flag".
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "cutoff.h"
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_flag.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
unsigned char *flags_mem;

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_cutoffmain.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* cutoffmain.c */
extern int   global_indexfd;	/* index file descriptor */
extern off_t global_idxlen;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static long resolve_label P_(( LABEL label ));

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: void set_flag(LABEL label, unsigned int flag)
 *
 * sets a flag at a particular label
 *
 * Modifications:
 *      <list mods with name and date>
 */
void set_flag(label, flag)
  LABEL label;
  unsigned int flag;
{
  long offset;

  if (~CO_FLAGMASK & flag)
    fatal_error(FATAL_ILLEGALPERM, "set_flag", "illegal flag parameter");

  offset = resolve_label(label);
  flags_mem[offset] |= (unsigned char) flag;
}


/*  */
/**********************************************************************
 * Function: int is_flag_set(LABEL label, unsigned int flag)
 *
 * checks to see if a particular flag is set.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int is_flag_set(label, flag)
  LABEL label;
  unsigned int flag;
{
  long offset;

  if (~CO_FLAGMASK & flag) {
    (void)fprintf(stderr, "illegal flag parameter in is_flag_set\n");
    return FALSE;
  }
  if ((offset = resolve_label(label)) == -1)
    return FALSE;
  if (flags_mem[offset] & (unsigned char) flag)
    return TRUE;

  return FALSE;
}


/*  */
/**********************************************************************
 * Function: static long resolve_label(LABEL label)
 *
 * Translate node label to flag table index. Returns -1 on fails,
 * otherwise an array index.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static long resolve_label(label)
  LABEL label;
{
  long index;

  if (label < 0 || label >= ConvToLabel(global_idxlen))
    return FALSE;
  index = (ConvToSeek(label)) / sizeof(INDEX);
  if (ConvToLabel((index * sizeof(INDEX))) != label)
    return FALSE;
  return index;
}
