/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:         cutoff.h
 *
 * SCCSINFO:            @(#)cutoff.h	1.3 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Jens M Hansen
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	File containing the constants of cutoff.
 *	The file is included in most cutoff files.
 */
#ifndef CUTOFF_H
#define CUTOFF_H

#include "lincks.h"

#define HEADER "Archive/"			/* files.c cutoff.c */

/*
 * why -2?  because it is the only integer whose
 * absolute value is the first prime number
 * and also the only even prime number
 */
#ifdef FAIL
#undef FAIL
#endif
/* lots of places */
#define FAIL (-2)

typedef enum {FORWARD, BACKWARD, ATTRIBUTES, IMAGE} MOLENTRYFIELD;

/* possible cutoff flag values */
#define CO_DELETED  0x1	/* ??? */
#define CO_CHECK    0x2	/* flag.c traverse.c */
#define CO_REACHED  0x4	/* stage3.c stage2.c moveobject.c traverse.c */
#define CO_MOVED    0x8	/* stage3.c flag.c */
#define CO_FLAGMASK (CO_DELETED | CO_CHECK | CO_REACHED | CO_MOVED)

/* stage2.c flag.c */
#define TRUE 1

/* flag.c traverse.c */
#define FALSE 0

#define ARCHIVE 1
#define NEW 0


#ifndef REPORTNUMBER
#define REPORTNUMBER 999
#endif

/* errors codes */
#define FATAL_OPEN 0
#define FATAL_GEN 1
#define FATAL_CREATE 2
#define FATAL_IO 3
#define FATAL_CLOSE 4
#define FATAL_MALLOC 5
#define FATAL_LSEEK 6
#define FATAL_STAT 7
#define FATAL_ILLEGALPERM 8
#define FATAL_CONFIG 9

#define DAT 0
#define MOL 1
#define CLOSE 2

#define START 0
#define FINISH 1

#endif /* CUTOFF_H */
