.\" 
.\" Linkoping Intelligent Communication of Knowledge System (LINCKS)
.\"      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
.\"       Department of Computer and Information Sciences
.\"		University of Linkoping, Sweden
.\"		    581 83 Linkoping, Sweden
.\"		       lincks@ida.liu.se
.\"
.\" These collective LINCKS programs are free software; you can 
.\" redistribute them and/or modify them under the terms of the GNU
.\" General Public License as published by the Free Software Foundation,
.\" version 2 of the License.
.\"
.\" These programs are distributed in the hope that they will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with the programs; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" dbroot man page
.\" author: David Partain
.\" version:  @(#)dbroot.l	1.6 5/27/94
.\"
.TH dbroot l "5/27/94" IISLAB "LINCKS System"
.SH NAME
dbroot - initialize a LINCKS database by creating an empty database
root node
.SH SYNOPSIS
.B dbroot \fIdatabase-directory\fR
.SH DESCRIPTION
The \fIdbroot\fR program is used to create the root node for an empty
database.

\fIdbroot\fR is \fIDESTRUCTIVE\fR!  It will destroy whatever root node
is already in the database if it exists.  Unless you want to destroy the
contents of a database, don't ever run this on anything except an empty
database.  

If you want to create a new, empty database, the steps are as follows:

.in +3
After choosing your database directory (DBDIR) and configuring the
database (by editing a file \fI.lincksrc\fR in the manner detailed in
installation documentation), create three empty files called
\fIindex\fR, \fI1.dat\fR, and \fI1.mol\fR:
.sp
.in +5
touch index 1.dat 1.mol
.in -5
.sp
Create a file \fIdata.names\fR with one line in it (ONLY one line):
.sp
.in +5
1.dat
.in -5
.sp
Create a file \fImolecule.names\fR with one line in it (ONLY one line):
.sp
.in +5
1.mol
.in -5
.sp
Create a file \fIpasswd\fR with one line in it (ONLY one line):
.sp
.in +5
lincks   0
.in -5
.sp
This is the entry for the user \fIlincks\fR who is user 0. Make
sure this file is only readble by the database owner.

Set the password for user lincks using the \fIdbpasswd\fR program by:
.sp
.in +5
dbpasswd -d . lincks
.in -5
.sp
and answer \fIhargle\fR twice (see also dbpasswd(l)).
Of course if you are running with clear text password, you can simply
add the password \fIhargle\fR when creating the file.

Create a file \fI groups\fR with one line in it (ONLY one line):
.sp
.in +5
0 0*
.in -5
.sp
This line means that user 0 is in group 0.  The asterix marks the end
of the line.

Start the database servers (see also lincks(l)):
.sp
.in +5
lincks -s .
.in -5
.sp

Run \fI dbroot\fR on the database, which will create the system
root and prepare the database to be loaded properly with \fIt2lincks\fR
files that you might have.
.sp
.in +5
dbroot .
.in -5
.sp

You will then have to log in as user \fIlincks\fR and password
\fIhargle\fR at which point the process will be carried out and the
program will exit.  The database is ready to load.
.in -3
.SH OPTIONS
.TP
.B \fIdatabase-directory\fR
the path to the directory holding the database files for the database to
be initialized.
.SH DIAGNOSTICS
Prints out the contents of the root node after initialization.
.SH BUGS
No known bugs.  Please report all bugs to lincks-bugs@ida.liu.se.
Please include a description of how you can reproduce the bug and the
output of either `dbx dbroot core' or `gdb dbroot core' if possible.
.SH COPYRIGHT
Copyright (C) 1993, 1994 Lin Padgham, Ralph Ronnquist
.LP
The collective LINCKS programs are free software; you can redistribute 
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation, version 2.
.LP
The collective LINCKS programs are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.
.LP
You should have received a copy of the GNU General Public License along
with the LINCKS system; see the file COPYING.  If not, write to the
Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.SH AVAILABILITY
The most recently released version of the LINCKS system is always 
available for anonymous ftp from ftp.ida.liu.se (130.236.30.131) in
the directory pub/lincks.
