/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	xconfig.c
 *
 * SCCSINFO:		@(#)xconfig.c	1.9 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R|nnquist, 1989-12-07
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 * This file contains the functions that handle loading of and access
 * to Lincks program run-time configuration table.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_xconfig.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
int errno;
extern char *sys_errlist[];
extern int sys_nerr;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#define DBCONFIGFILE		".lincksrc"

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static void initialize P_(( void ));
static int LL_LoadConfigFile P_(( char *cfname ));
static int LL_SetConfig P_(( char *tag, char *value ));

#ifdef NEED_STRTOL
long int strtol( /* string, endPtr, base */ );
unsigned long int strtoul( /* string, endPtr, base */ );
#endif	/* NEED_STRTOL */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
static struct {
  char *tag;
  char *value;
} dbconfig[] = {
    { "BINARIES", NULL },
    /* full path name for lincks programs directory */
    { "LOGDIR" , NULL },
    /* full path name for log file directory */
    { "MONITORPROGNO", "572662306" },
    /* RPC program number for monitor program */
    { "TCPIPNO" , NULL },
    /* RPC program version number for monitor program */
    { "HOST", NULL },
    /* Primary host to run lincks programs on */
    { "HOST2", NULL },
    /* Secondary host to run lincks programs on */
    { "DBDIR", NULL},
    /* Full path name for database directory */
    { "OWNER", NULL },
    /* Name of database owner */
    { "USER", NULL },
    /* Name of database user */
    { NULL , NULL }
  };

/*  */
/**********************************************************************
 * Function: char *LL_GetConfig(char *tag)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
char *LL_GetConfig(tag)
  char *tag;
{
  int i;

  for (i=0; dbconfig[i].tag != NULL; i++)
    if (strcmp(tag,dbconfig[i].tag) == 0)
      return(dbconfig[i].value);
  return((char *) NULL);
}

/*  */
/**********************************************************************
 * Function: long LL_GetConfigl(char *tag)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
long LL_GetConfigl(tag)
  char *tag;
{
  char *p;

  return(strtol(LL_GetConfig(tag), &p, 0));
}

/*  */
/**********************************************************************
 * Function: static int LL_SetConfig(char *tag, char *value)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static int LL_SetConfig(tag,value)
  char *tag;
  char *value;
{
  int i;

  for (i=0; dbconfig[i].tag != 0; i++) {
    if (strcmp(tag,dbconfig[i].tag) == 0) {
      if (dbconfig[i].value)
        free((FREEPTR *)dbconfig[i].value);
      dbconfig[i].value = NULL;
      dbconfig[i].value=(char *)malloc((ALLOC_T)strlen(value)+1);
      if (!dbconfig[i].value)
        return (0); 
      (void)strcpy(dbconfig[i].value,value);
      return(1);
    }
  }
  return(0);
}

/*  */
/**********************************************************************
 * Function: static int LL_LoadConfigFile(char *cfname)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static int LL_LoadConfigFile(cfname)
  char *cfname;
{ /* Process a configuration file and set up values. */
  char buffer[200], tag[100];
  FILE *cf;

  if ((cf = fopen(cfname,"r")) == 0) {
    return(0);
  }

  while (fscanf(cf,"%s = %s",tag,buffer) == 2) {
    if (!LL_SetConfig(tag,buffer)) {
      (void)fprintf(stderr, "%s = %s: unknown tag - ignoring\n", tag, buffer);
    }
  }

  (void)fclose(cf);

  /* Note: the configuration value types are not checked */

  return(1);
}

/*  */
/**********************************************************************
 * Function: int configuration(char *dbdir)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int configuration(dbdir)
  char *dbdir;
{ /* Process all configuration files */
  char buffer[MAXPATHLEN];
  static int configured = 0;

  if (!configured) {
    initialize();
    configured = 1;
  }

  (void)sprintf(buffer,"%s/%s",dbdir,DBCONFIGFILE);

  if (LL_LoadConfigFile(buffer) == 0)
    return(0);

  return(1);
}

/*  */
/**********************************************************************
 * Function: static void initialize()
 *
 * kind of a hack...  make sure that the strings in dbconfig are
 * malloc'ed, so that if in the configuration process we're about to 
 * replace a dbconfig value field with another, we can free it first.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void initialize()
{
  int i;
  char *string = NULL;

  for (i = 0; dbconfig[i].tag; i++){
    if (dbconfig[i].value) {
      string = (char *)malloc((ALLOC_T)strlen(dbconfig[i].value) + 1);
      (void)strcpy(string, dbconfig[i].value);
      dbconfig[i].value = string;
    }
  }
  return;
}

#ifdef NEED_STRTOL
/*  */
/* the following two functions here for compatibility.  i have taken them
 * directly from the tcl distribution and they is included in their original
 * form, with the exception of the fact that the functions have been made
 * static and a #include commented out, and rcsid is commented out.
 */
/* 
 * strtol.c --
 *
 *	Source code for the "strtol" library procedure.
 *
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef lint
/* static char rcsid[] = "$Header: /user6/ouster/tcl/compat/RCS/strtol.c,v 1.2 93/03/19 15:25:43 ouster Exp $ SPRITE (Berkeley)";*/
#endif /* not lint */


/*
 *----------------------------------------------------------------------
 *
 * strtol --
 *
 *	Convert an ASCII string into an integer.
 *
 * Results:
 *	The return value is the integer equivalent of string.  If endPtr
 *	is non-NULL, then *endPtr is filled in with the character
 *	after the last one that was part of the integer.  If string
 *	doesn't contain a valid integer value, then zero is returned
 *	and *endPtr is set to string.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

long int
strtol(string, endPtr, base)
    char *string;		/* String of ASCII digits, possibly
				 * preceded by white space.  For bases
				 * greater than 10, either lower- or
				 * upper-case digits may be used.
				 */
    char **endPtr;		/* Where to store address of terminating
				 * character, or NULL. */
    int base;			/* Base for conversion.  Must be less
				 * than 37.  If 0, then the base is chosen
				 * from the leading characters of string:
				 * "0x" means hex, "0" means octal, anything
				 * else means decimal.
				 */
{
    register char *p;
    int result;

    /*
     * Skip any leading blanks.
     */

    p = string;
    while (isspace(*p)) {
	p += 1;
    }

    /*
     * Check for a sign.
     */

    if (*p == '-') {
	p += 1;
	result = -(strtoul(p, endPtr, base));
    } else {
	if (*p == '+') {
	    p += 1;
	}
	result = strtoul(p, endPtr, base);
    }
    if ((result == 0) && (endPtr != 0) && (*endPtr == p)) {
	*endPtr = string;
    }
    return result;
}

/* 
 * strtoul.c --
 *
 *	Source code for the "strtoul" library procedure.
 *
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef lint
/* static char rcsid[] = "$Header: /user6/ouster/tcl/compat/RCS/strtoul.c,v 1.3 93/03/19 15:25:41 ouster Exp $ SPRITE (Berkeley)";*/
#endif /* not lint */

/*#include <ctype.h>*/

/*
 * The table below is used to convert from ASCII digits to a
 * numerical equivalent.  It maps from '0' through 'z' to integers
 * (100 for non-digit characters).
 */

static char cvtIn[] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,		/* '0' - '9' */
    100, 100, 100, 100, 100, 100, 100,		/* punctuation */
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,	/* 'A' - 'Z' */
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35,
    100, 100, 100, 100, 100, 100,		/* punctuation */
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,	/* 'a' - 'z' */
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35};

/*
 *----------------------------------------------------------------------
 *
 * strtoul --
 *
 *	Convert an ASCII string into an integer.
 *
 * Results:
 *	The return value is the integer equivalent of string.  If endPtr
 *	is non-NULL, then *endPtr is filled in with the character
 *	after the last one that was part of the integer.  If string
 *	doesn't contain a valid integer value, then zero is returned
 *	and *endPtr is set to string.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

unsigned long int
strtoul(string, endPtr, base)
    char *string;		/* String of ASCII digits, possibly
				 * preceded by white space.  For bases
				 * greater than 10, either lower- or
				 * upper-case digits may be used.
				 */
    char **endPtr;		/* Where to store address of terminating
				 * character, or NULL. */
    int base;			/* Base for conversion.  Must be less
				 * than 37.  If 0, then the base is chosen
				 * from the leading characters of string:
				 * "0x" means hex, "0" means octal, anything
				 * else means decimal.
				 */
{
    register char *p;
    register unsigned long int result = 0;
    register unsigned digit;
    int anyDigits = 0;

    /*
     * Skip any leading blanks.
     */

    p = string;
    while (isspace(*p)) {
	p += 1;
    }

    /*
     * If no base was provided, pick one from the leading characters
     * of the string.
     */
    
    if (base == 0)
    {
	if (*p == '0') {
	    p += 1;
	    if (*p == 'x') {
		p += 1;
		base = 16;
	    } else {

		/*
		 * Must set anyDigits here, otherwise "0" produces a
		 * "no digits" error.
		 */

		anyDigits = 1;
		base = 8;
	    }
	}
	else base = 10;
    } else if (base == 16) {

	/*
	 * Skip a leading "0x" from hex numbers.
	 */

	if ((p[0] == '0') && (p[1] == 'x')) {
	    p += 2;
	}
    }

    /*
     * Sorry this code is so messy, but speed seems important.  Do
     * different things for base 8, 10, 16, and other.
     */

    if (base == 8) {
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > 7) {
		break;
	    }
	    result = (result << 3) + digit;
	    anyDigits = 1;
	}
    } else if (base == 10) {
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > 9) {
		break;
	    }
	    result = (10*result) + digit;
	    anyDigits = 1;
	}
    } else if (base == 16) {
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > ('z' - '0')) {
		break;
	    }
	    digit = cvtIn[digit];
	    if (digit > 15) {
		break;
	    }
	    result = (result << 4) + digit;
	    anyDigits = 1;
	}
    } else {
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > ('z' - '0')) {
		break;
	    }
	    digit = cvtIn[digit];
	    if (digit >= base) {
		break;
	    }
	    result = result*base + digit;
	    anyDigits = 1;
	}
    }

    /*
     * See if there were any digits at all.
     */

    if (!anyDigits) {
	p = string;
    }

    if (endPtr != 0) {
	*endPtr = p;
    }

    return result;
}
#endif	/* NEED_STRTOL */
