/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	pen_notify.c
 *
 * SCCSINFO:		@(#)pen_notify.c	1.10 5/20/94
 *
 * ORIGINAL AUTHOR(S):  Anders Broman,pumgruppen PEN 1992-05-28
 *
 * MODIFICATIONS:
 *	1993-08-12 Martin Sjlin - changed liblincks interface
 *              as we retrieve all possible pens at once ....
 *      1993-11-02 Martin Sjlin - made the setup in PEN_oob do a
 *              callback to user interface level. Removed reference
 *              to toplevel and all X stuff. Moved into xstuff.c
 *      1994-01-07 Martin Sjlin - followup the changes to the call
 *              interface (unified with RCB).
 *      1994-01-13 Martin Sjlin - rewrote callback for PEN and thus
 *              removed all lowlevel things from this module.
 *	<list mods here with name and date>
 *      
 * DESCRIPTION:
 *
 * This module creates and displays a warningsmessage when
 * parallel editing occurs.
 * It uses X window routines to build the message window.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "aimtypes.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_pen_notify.h"

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_xstuff.h"
#include "f_chng_prop.h"		/* mark_reference */

/* libshared */
extern char *strdup( /* char *incoming */ );

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern reference_structure *refstructs; 	/* aimstart.c */
extern int suppress;				/* aimstart.c */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
typedef struct _penreceived { /* a pen message that's been received */
#define POLL  1
#define CHECK 2
  int type;
  int index;
  char *message;
  struct _penreceived *next;
} penreceived;

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static int add_new_pen P_(( int index, int type, char *msg ));
static int is_bt P_(( int object ));
static int is_new_pen P_(( int index, int type, char *msg ));

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
static char *object_kind[] = { "object", "binding table" };
static penreceived *penlist = NULL;

/*  */
/**********************************************************************
 * int PEN_resolve(void *extra, int index, char *msg);
 *
 * PEN handler for RESOLVE class messages.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int PEN_resolve(extra, index,  msg)
  void *extra;
  int   index;
  char *msg;
{
  (void)printf("The history node %d was merged from a parallel update.\n",
		 index);
  return(1);
}

/*  */
/**********************************************************************
 * int PEN_check(void *extra, int index, char *msg);
 *
 * PEN handler for CHECK class messages.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int PEN_check(extra, index, msg)
  void *extra;
  int   index;
  char *msg;
{
  if (!msg ) 
    short_error("message NULL in PEN_check.\n");
  else if (is_new_pen( index, CHECK, msg)) {
    int isbt = is_bt(index);

    /* if we fail to add this message, n.c. - we only see it once more */
    (void) add_new_pen( index, CHECK, msg);
    if (!suppress || isbt)
      popup_message(POPUP_MESS_PEN,
		    "The %s <%d:-1> is\nbeing edited by the user(s):\n %s",
		    object_kind[isbt], index, msg);
    if (!isbt)
      mark_reference(refstructs, uim_highlight);

  } /* is_new_pen */

  return(1);
}

/*  */
/**********************************************************************
 * int PEN_poll(void *extra, int index, char *msg);
 *
 * PEN handler for POLL class messages.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int PEN_poll(extra, index, msg)
  void *extra;
  int   index;
  char *msg;
{
  if (!msg ) 
    short_error("message NULL in PEN_poll.\n");
  else if (is_new_pen( index, POLL, msg)) {
    int isbt = is_bt(index);

    /* if we fail to add this message, n.c. - we only see it once more */
    (void) add_new_pen( index, POLL, msg);
    if (!suppress || isbt)
      popup_message(POPUP_MESS_PEN, 
		   "User %s just began editing %s <%d:-1>.", 
		   msg, object_kind[isbt], index);
    if (!isbt)
      mark_reference(refstructs, uim_highlight);

  } /* is_new_pen */

  return(1);
}
 
/*  */
/**********************************************************************
 * Function: static int is_new_pen(int index, int type, char *msg)
 * 
 * Return 0 if the given node is in the penlist, otherwise 1.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static int is_new_pen( index, type, msg )
 int index;
 int type;
 char *msg;
{
  penreceived *p = penlist;

  for (p = penlist; p != NULL; p = p->next) 
    if ( p->index == index &&
	 p->type == type    &&
         strcmp(p->message,msg) == 0) 
      return(0);

  return(1);
}

/*  */
/**********************************************************************
 * Function: static int add_new_pen(int index, int type, char *msg)
 * 
 * Add the new pen to the front of the list ... return 1 if no error
 * else 0
 *
 * Modifications:
 *      <list mods with name and date>
 */
static int add_new_pen( index, type, msg)
 int index;
 int type;
 char *msg;
{
  penreceived *p = penlist;

  p = (penreceived *)malloc(sizeof(penreceived));
  if ( !p )
    return(0);
  
  p->index   = index;
  p->type    = type;
  p->message = strdup(msg);
  p->next    = penlist;
  penlist    = p;
  return(1);
}

/*  */
/**********************************************************************
 * Function: int is_penned(int node)
 * 
 * Return 1 if the given node is in the penlist, otherwise 0.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int is_penned(node)
  int node;
{
  penreceived *tmp;

  for (tmp = penlist; tmp != NULL; tmp = tmp->next) {
    if (tmp->index == node)
      return 1;
  }
  return 0;
}

/*  */
/**********************************************************************
 * Function: int clear_penned(int node)
 * 
 * Removes node from the penlist. Return 1 if it was in the list,
 * otherwise 0.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int clear_penned(node)
  int node;
{
  penreceived *tmp, *p = NULL;

  for (tmp = penlist; tmp != NULL; tmp = tmp->next) {
    if (tmp->index == node) {
      if (p) {
	p->next = tmp->next;
      } else {
	penlist = tmp->next;
      }
      if (tmp->message)
	free(tmp->message);
      free((FREEPTR *)tmp);
      return 1;
    }
  }
  return 0;
}

/*  */
/**********************************************************************
 * Function: static int is_bt(int object)
 * 
 * return whether an object is used as a binding table or not.  note 
 * that this function isn't close to infallible.  it will not find a
 * binding table on a closed but unsaved reference structure.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static int is_bt(object)
  int object;
{
  reference_structure *ref;

  for (ref = refstructs; ref != NULL; ref = ref -> next) {
    if (ref->bt.vs == object)
      return 1;
  }
  return 0;
}


