/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	view.c
 *
 * SCCSINFO:		@(#)view.c	1.6 6/9/94
 *
 * ORIGINAL AUTHOR(S):  ????????
 *
 * DESCRIPTION:
 * Lincks XlView Widget which inherits from Athena Viewport widget
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/ViewportP.h>

#include "viewP.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_view.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
int avoid_scrolling = 0;

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_layout.h"
extern void XawScrollbarSetThumb P_(( Widget gw, float top, float shown ));

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#define superclass	(&viewportClassRec)

#define ViewGeometry (*viewportClassRec.composite_class.geometry_manager)
#define ViewResize (*viewportClassRec.core_class.resize)

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static XtGeometryResult GeometryManager P_(( Widget w, XtWidgetGeometry
                                              *req, XtWidgetGeometry *rtn ));
static void MoveChild P_(( Widget w, XtPosition x, XtPosition y ));
static void RedrawThumbs P_(( Widget w ));
static void Resize P_(( Widget w ));

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
static XtResource resources[] = {
#define offset(field) XtOffset(XlViewWidget, xlview.field)
    /* {name, class, type, size, offset, default_type, default_addr}, */
    { XtNmaxWindowHeight, XtCmaxWindowHeight, XtRDimension, sizeof(Dimension),
        offset(max_window_height), XtRImmediate, (XtPointer)500 },
    { XtNminWindowHeight, XtCminWindowHeight, XtRDimension, sizeof(Dimension),
        offset(min_window_height), XtRImmediate, (XtPointer)200 },
#undef offset
};

XlViewClassRec XlviewClassRec = {
  { /* core_class fields */
    /* superclass	  */	(WidgetClass) superclass,
    /* class_name	  */	"XlView",
    /* widget_size	  */	sizeof(XlViewRec),
    /* class_initialize	  */	NULL,
    /* class_part_init    */    NULL,
    /* class_inited	  */	FALSE,
    /* initialize	  */	NULL,
    /* initialize_hook    */    NULL,
    /* realize		  */	XtInheritRealize,
    /* actions		  */	NULL,
    /* num_actions	  */	0,
    /* resources	  */	resources,
    /* num_resources	  */	XtNumber(resources),
    /* xrm_class	  */	NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest	  */	FALSE,
    /* destroy		  */	NULL,
    /* resize		  */	Resize,
    /* expose		  */	XtInheritExpose,
    /* set_values	  */	NULL,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus	  */	NULL,
    /* version            */    XtVersion,
    /* callback_private	  */	NULL,
    /* tm_table    	  */	NULL,
    /* query_geometry     */    XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },
  { /* composite_class fields */
    /* geometry_manager	  */	GeometryManager,
    /* change_managed	  */	XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  },
  { /* constraint_class fields */
    /* subresourses	  */	NULL,
    /* subresource_count  */	0,
    /* constraint_size	  */	sizeof(XlViewConstraintsRec),
    /* initialize	  */	NULL,
    /* destroy		  */	NULL,
    /* set_values	  */	NULL,
    /* extension          */	NULL
  },
  { /* form_class fields */
    /* empty		  */	XtInheritLayout
  },
  { /* viewport_class fields */
    /* empty              */    0
  },
  { /* xlview_class fields */
    /* empty 		  */	0
  }
};

WidgetClass XlviewWidgetClass = (WidgetClass)&XlviewClassRec;

/*  */
/* Private Procedures */
/**********************************************************************
 * Function: static XtGeometryResult GeometryManager(THREE PARAMETERS)
 * Parameters:
 *	Widget w
 *	XtWidgetGeometry *req
 *	XtWidgetGeometry *rtn
 * 
 * Called when a child is asking the viewport if it can grow.
 *
 * What we're trying to do here:
 * 1. check request height relative to max window height.
 * 2. split into two requests if height larger
 *    a. grow to max window height
 *    b. add scrollbar for rest
 * 3. if height request is smaller than max but larger than min, grow
 * 4. otherwise, accept and let them grow
 *
 * Modifications:
 *      <list mods with name and date>
 */
static XtGeometryResult GeometryManager(w, req, rtn)
  Widget w;			/* child */
  XtWidgetGeometry *req;
  XtWidgetGeometry *rtn;
{
  XlViewWidget pw = (XlViewWidget) XtParent(w);
  Dimension height = 0;
  XtWidgetGeometry req2, ret2;
  Boolean allow_vert = False;

  /* !height or bw or width, so return */
  if (!(req->request_mode & (CWHeight|CWBorderWidth|CWWidth)))
    return ViewGeometry(w,req,rtn);

  /* get the height included in the request */
  if (req->request_mode & CWHeight)
    height = req->height;
  if (req->request_mode & CWBorderWidth)
    height += 2 * req->border_width;

  req2.request_mode = (CWWidth|CWHeight);
  req2.width = req->width;

  /* 15... well, that is the width of a scrollbar plus 1*borderwidth (!)
   * of the scrollbar.  unlike all other widgets, the 
   * viewport uses 1*borderwidth when figuring width and height.  all
   * others use 2*borderwidth
   */
  if (height > (Dimension)(pw->xlview.max_window_height)) {
    req2.width += 15;
    req2.height = pw -> xlview.max_window_height;
    allow_vert = True;
  } else {
    /* height < maxWindowHeight, but > minWindowHeight, should grow */
    if (height >= (Dimension)(pw->xlview.min_window_height)) {
      req2.height = height;
    } else {
      req2.height = pw -> xlview.min_window_height;
    }
  }

  XtVaSetValues((Widget)pw, XtNresizable, True, NULL);
  if (XtMakeGeometryRequest((Widget)pw, &req2, &ret2) == XtGeometryAlmost)
    (void)XtMakeGeometryRequest((Widget)pw, &ret2, &ret2);
  XtVaSetValues((Widget)pw,XtNresizable, False, XtNallowVert, allow_vert,NULL);
  return ViewGeometry(w,req,rtn);
}

/*  */
/**********************************************************************
 * Function: static void Resize(Widget w)
 * 
 * amongst other things, this function resets max and minWindowHeight
 * if the core height is not the same as the layout height.  this is
 * done so that if the user changes the window size (i.e. using the window
 * manager), it'll stay that way instead of getting set back to
 * maxWindowHeight.
 *
 * Note: the line " Widget lw = (Widget)vw->composite.children[1];"
 * doesn't please us, but sometimes vw->viewport.child is null when
 * this is called.  assuming vw->composite.children[1] is always the
 * layout widget.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void Resize(w)
  Widget w;
{
  XlViewWidget vw = (XlViewWidget)w;
  Widget lw = (Widget)vw->composite.children[1];
  Dimension height = XlLayoutHeight(lw);

#if (XT_REVISION >= 5) 	/* >= X11R5 - doesn't work under R4*/
  if (height > vw->core.height) {
    XtVaSetValues((Widget)vw, XtNallowVert, True, NULL);
  } else {
    XtVaSetValues((Widget)vw, XtNallowVert, False, NULL);
  }
#endif	/* >= X11R5 */

  if (height != vw->core.height) {
    vw->xlview.min_window_height = vw->core.height;
    vw->xlview.max_window_height = vw->core.height;
  }
  ViewResize(w);
}

/*  */
/**********************************************************************
 * Function: static void RedrawThumbs(Widget w)
 * 
 * Copied from Viewport.c  could not inherit from the superclass 
 * This is ugly but no other way unless we go to C++
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void RedrawThumbs(w)
  Widget w;
{
    ViewportWidget v = (ViewportWidget) w;
    register Widget child = v->viewport.child;
    register Widget clip = v->viewport.clip;

    if (v->viewport.horiz_bar != (Widget)NULL)
      XawScrollbarSetThumb(v->viewport.horiz_bar, 
			   (float)((-child->core.x)/(short)child->core.width),
			   (float)((short)clip->core.width/(short)child->core.width));

    if (v->viewport.vert_bar != (Widget)NULL)
      XawScrollbarSetThumb(v->viewport.vert_bar, 
			   (float)(-child->core.y)/(short)child->core.height, 
			   (float)(short)clip->core.height/(short)child->core.height);
}


/*  */
/**********************************************************************
 * Function: static void MoveChild(Widget w, XtPosition x, XtPosition y)
 * 
 * Copied from Viewport.c  could not inherit from the superclass
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveChild(w, x, y)
  Widget w;
  XtPosition x, y;
{
  ViewportWidget v = (ViewportWidget) w;
  register Widget child = v->viewport.child;
  register Widget clip = v->viewport.clip;

  /* make sure we never move past right/bottom borders */
  if (-x + (Position)clip->core.width > (Position)child->core.width)
    x = -(child->core.width - clip->core.width);
  
  if (-y + (Position)clip->core.height > (Position)child->core.height)
    y = -(child->core.height - clip->core.height);

  /* make sure we never move past left/top borders */
  if (x >= 0) x = 0;
  if (y >= 0) y = 0;

  XtMoveWidget(child, x, y);
  RedrawThumbs(w);
}

/*  */
/* Public Functions */
/**********************************************************************
 * Function: void XlViewAutoScroll(Widget w, XtPosition x, XtPosition y,int frame)
 * 
 * Automatically scroll to center <x,y> when y is not within
 * the frame-to-height region.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void XlViewAutoScroll(w, x, y,frame)
  Widget w;
  XtPosition x, y;
  int frame;
{

  XlViewWidget v = (XlViewWidget) w;
  Position newy;

  if (avoid_scrolling)
    return;
  if ((y >= frame) && (y < (Position)v->core.height))
    return;
  newy = v->viewport.child->core.y - y + (v->core.height/2);
  MoveChild((Widget)v, x, (XtPosition)newy);
}

/*  */
/**********************************************************************
 * Function: int XlViewPageScroll(Widget w, XtBoolean forward, XtPosition y)
 *
 * Scrolls the layout up/down one screenful. Returns 1 if given y ends
 * up outside the screen.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int XlViewPageScroll(w, forward,y)
  Widget w;		/* a widget */
  XtBoolean forward;
  XtPosition y;
{
  XlViewWidget view = (XlViewWidget) XtParent(w);
  Dimension clip_height = view->viewport.clip->core.height;
  Position home = (Position)(w->core.y);

  if (forward)
    home -= clip_height;
  else
    home += clip_height;

  MoveChild((Widget)view, (XtPosition)0, (XtPosition)home);
  home = -(w->core.y);
  if ((y < home) || (y > home + (Position)clip_height))
    return 1;
  return 0;
}

/*  */
/**********************************************************************
 * Function: void XlViewCenterRow(Widget w, XtPosition y)
 * 
 * Move child so the row y is centered.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void XlViewCenterRow(w, y)
  Widget w;
  XtPosition y;
{
  XlViewWidget view = (XlViewWidget) XtParent(w);
  Dimension clip_height = view->viewport.clip->core.height;
  Position home = -(y - (clip_height / 2));

  MoveChild((Widget)view, (XtPosition)0, (XtPosition)home);
}
