/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:		ltextsinkP.h
 *
 * SCCSINFO:		@(#)ltextsinkP.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):	???
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	Private definitions for TextSink object
 */
#ifndef _XlTextSinkP_h
#define _XlTextSinkP_h

/***********************************************************************
 * XlTextSink Object Private Data
 ***********************************************************************/
#include <X11/Xaw/TextSinkP.h> 
#include "ltextsink.h"

#define XtRJustifyMode 	"XlJustifyMode"
#define XtRIndentMode  	"XlIndentMode"
#define XtRFontMarks	"XlFontMarks"


/************************************************************
 * New fields for the XlTextSink object class record.
 ************************************************************/

typedef struct _XlTextSinkClassPart {
  int empty;
} XlTextSinkClassPart;


/* Full class record declaration */
typedef struct _XlTextSinkClassRec {
    ObjectClassPart     object_class;
    TextSinkClassPart	text_sink_class;
    XlTextSinkClassPart	xltext_sink_class;
} XlTextSinkClassRec;

extern XlTextSinkClassRec XltextSinkClassRec;

/* New fields for the TextSink object record */
typedef struct {
    /* public resources */
    Boolean echo;
    Boolean display_nonprinting;
    XlJustifyType justify;      /* text justification   */
    int indent;                 /* pixels to indent in a paragraph */
    XlFontMap	fontinfo;	/* markings for different fonts in text */

    /* private state */
    GC normgc, invgc, xorgc;
    Pixmap insertCursorOn;
    XawTextInsertState laststate;
    short cursor_x, cursor_y;	/* Cursor Location. */
} XlTextSinkPart;

/****************************************************************
 * Full instance record declaration
 ****************************************************************/

typedef struct _XlTextSinkRec {
  ObjectPart      object;
  TextSinkPart	  text_sink;
  XlTextSinkPart  xltext_sink;
} XlTextSinkRec;


#endif /* _XlTextSinkP_h */
