/*
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	ltextaction.c: ltextselection.c
 *
 * SCCSINFO:		@(#)ltextselection.c	1.7 6/9/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with (mouse based)
 *	text selections.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * Function: static void pop_in_place();
 * Function: static void pop_in_new();
 * Function: static void expand_in_new();
 * Function: static void expand_in_place();
 * Function: static void SelectStart();
 * Function: static void ExtendAdjust();
 * Function: static void InsertSelection();
 * Function: static void ExtendEnd();
 * Function: static void ExtendStart();
 * Function: static void ModifySelection();
 * Function: static void GetSelection();
 * Function: static void _SelectionReceived();
 **********************************************************************/

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void pop_in_place(FOUR PARAMETERS)
 * Parameters:
 *      Widget w
 *      XEvent *event
 *      String *params          - unused
 *      Cardinal *num_params    - unused
 *
 * expand an infonode in a new window.  the last argument to expandfn (0)
 * specifies that this is expansion in a new window.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void pop_in_place(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  XlTextWidget ctx = (XlTextWidget) w;

  popfn((Widget) ctx, (widget_info *) ReferenceP, 1);
  XlLayoutLostFocus(XtParent(w), 0);
  XlSkipGoalSet(w, 0);
  XlSetGoalColumn(w, 0);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void pop_in_new(FOUR PARAMETERS)
 * Parameters:
 *      Widget w
 *      XEvent *event
 *      String *params          - unused
 *      Cardinal *num_params    - unused
 *
 * expand an infonode in a new window.  the last argument to expandfn (0)
 * specifies that this is expansion in a new window.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void pop_in_new(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  XlTextWidget ctx = (XlTextWidget) w;

  popfn((Widget) ctx, (widget_info *) ReferenceP, 0);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void expand_in_new(FOUR PARAMETERS)
 * Parameters:
 *      Widget w
 *      XEvent *event
 *      String *params          - unused
 *      Cardinal *num_params    - unused
 *
 * expand an infonode in a new window.  the last argument to expandfn (0)
 * specifies that this is expansion in a new window.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void expand_in_new(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  XlTextWidget ctx = (XlTextWidget) w;

  ModifySelection((TextWidget) ctx, event,
		  XawsmTextSelect, XawactionStart, params, num_params);

  expandfn((Widget) ctx, (widget_info *) ReferenceP, 0);

  if (event && (event->type != KeyPress) && (event->type != KeyRelease)) {
    XlSkipGoalSet(w, 0);
    XlSetGoalColumn((Widget)ctx, ctx->text.ev_x);
  }
  XltextSetFocus(w, (XtPosition) XltextYForCurrentPosition((TextWidget)ctx));
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void expand_in_place(FOUR PARAMETERS)
 * Parameters:
 *      Widget w
 *      XEvent *event
 *      String *params          - unused
 *      Cardinal *num_params    - unused
 *
 * expand an infonode in a new window.  the last argument to expandfn (1)
 * specifies that this is expansion in a new window.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void expand_in_place(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  XlTextWidget ctx = (XlTextWidget) w;

  expandfn((Widget) ctx, (widget_info *) ReferenceP, 1);
  XlLayoutLostFocus(XtParent(w), 0);
  XlSkipGoalSet(w, 0);
  XlSetGoalColumn(w, 0);
  XawTextDisplayCaret((Widget) ctx, FALSE);
}

/* 	Selection routines for selecting and pasting with the mouse 	*/
/*  */
/**********************************************************************
 * Function: static void SelectStart(FOUR PARAMETERS)
 * Parameters:
 *	Widget w;
 *	XEvent *event;
 *	String *params;
 *	Cardinal *num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void SelectStart(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;		/* unused */
  Cardinal *num_params;		/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;

  ClearAllSelections(w);

  ModifySelection((TextWidget) w, event,
		  XawsmTextSelect, XawactionStart, params, num_params);

  selectfn((Widget) ctx, (widget_info *) ReferenceP, (caddr_t) NULL);

  if (event) {
    XlSkipGoalSet(w, 0);
    XlSetGoalColumn((Widget)ctx, ctx->text.ev_x);
  }
  XltextSetFocus(w, (XtPosition) XltextYForCurrentPosition((TextWidget)ctx));
}

/*  */
/**********************************************************************
 * Function: static void ExtendAdjust(FOUR PARAMETERS)
 * Parameters:
 *	Widget w;
 *	XEvent *event;
 *	String *params;
 *	Cardinal *num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ExtendAdjust(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;		/* unused */
  Cardinal *num_params;		/* unused */
{
  ModifySelection((TextWidget) w, event,
		  XawsmTextExtend, XawactionAdjust, params, num_params);
}

/*  */
/**********************************************************************
 * Function: static void InsertSelection(FOUR PARAMETERS)
 * Parameters:
 *	Widget w;
 *	XEvent *event;
 *	String *params;
 *	Cardinal *num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsertSelection(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;		/* precedence list of selections to try */
  Cardinal *num_params;
{
  XlTextWidget ctx = (XlTextWidget) w;
  
  XlSetGoalColumn((Widget)ctx, ctx->text.ev_x);
  XltextSetFocus(w, (XtPosition) XltextYForCurrentPosition((TextWidget)ctx));

  StartAction((TextWidget) w, event);
  GetSelection(w, ((TextWidget) w)->text.time, params, *num_params);

#if (XT_REVISION >= 5) && !defined(NO_TEXT_COPY_AREA) /* not in R4 */
/* 
 * there's a bug in the R5 text widget which tries to scroll 
 * even though we have disallowed scrollbars.  this prevents it.
 * i don't like it, but i don't know what else to do...
 */
{
  struct text_move *offset = ctx->text.copy_area_offsets;
  struct text_move *free_this = NULL;

  while (offset) {
    free_this = offset;
    offset = offset->next;
    free((FREEPTR *)free_this);
  }
  ctx->text.copy_area_offsets = NULL;
}
#endif

  EndAction((TextWidget) w);

}

/*  */
/**********************************************************************
 * Function: static void ExtendEnd(FOUR PARAMETERS)
 * Parameters:
 *	Widget w;
 *	XEvent *event;
 *	String *params;
 *	Cardinal *num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ExtendEnd(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  ModifySelection((TextWidget) w, event,
		  XawsmTextExtend, XawactionEnd, params, num_params);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void ExtendStart(FOUR PARAMETERS)
 * Parameters:
 *	Widget w;
 *	XEvent *event;
 *	String *params;
 *	Cardinal *num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ExtendStart(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;		/* unused */
  Cardinal *num_params;		/* unused */
{
  ModifySelection((TextWidget) w, event,
		  XawsmTextExtend, XawactionStart, params, num_params);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void ModifySelection(FIVE PARAMETERS)
 * Parameters:
 *	TextWidget ctx;
 *	XEvent *event;
 *	XawTextSelectionMode mode;
 *	XawTextSelectionAction action;
 *	String *params;	
 *	Cardinal *num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ModifySelection(ctx, event, mode, action, params, num_params)
  TextWidget ctx;
  XEvent *event;
  XawTextSelectionMode mode;
  XawTextSelectionAction action;
  String *params;		/* unused */
  Cardinal *num_params;		/* unused */
{
  StartAction(ctx, event);
  _XawTextAlterSelection(ctx, mode, action, params, num_params);
  EndAction(ctx);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void GetSelection(FOUR PARAMETERS)
 * Parameters:
 *	Widget w;
 *	Time time;
 *	String *params;
 *	Cardinal num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void GetSelection(w, time, params, num_params)
  Widget w;
  Time time;
  String *params;		/* selections in precedence order */
  Cardinal num_params;
{
  Atom selection;
  int buffer;

  selection = XInternAtom(XtDisplay(w), *params, False);
  switch (selection) {
  case XA_CUT_BUFFER0:
    buffer = 0;
    break;
  case XA_CUT_BUFFER1:
    buffer = 1;
    break;
  case XA_CUT_BUFFER2:
    buffer = 2;
    break;
  case XA_CUT_BUFFER3:
    buffer = 3;
    break;
  case XA_CUT_BUFFER4:
    buffer = 4;
    break;
  case XA_CUT_BUFFER5:
    buffer = 5;
    break;
  case XA_CUT_BUFFER6:
    buffer = 6;
    break;
  case XA_CUT_BUFFER7:
    buffer = 7;
    break;
  default:
    buffer = -1;
  }
  if (buffer >= 0) {
    int nbytes;
    unsigned long length;
    int fmt8 = 8;
    Atom type = XA_STRING;
    char *line = XFetchBuffer(XtDisplay(w), &nbytes, buffer);
    if ((length = nbytes))
      _SelectionReceived(w, NULL, &selection, &type, (caddr_t) line,
			 &length, &fmt8);
    else if (num_params > 1)
      GetSelection(w, time, params + 1, num_params - 1);
  } else {
    struct _SelectionList *list;
    if (--num_params) {
      list = XtNew(struct _SelectionList);
      list->params = params + 1;
      list->count = num_params;
      list->time = time;
    } else
      list = NULL;
    XtGetSelectionValue(w, selection, XA_STRING, _SelectionReceived,
			(XtPointer) list, time);
  }
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void _SelectionReceived(SEVEN PARAMETERS)
 * Parameters:
 *	Widget w;
 *	XtPointer client_data;
 *	Atom *selection;
 *	Atom *type;
 *	XtPointer value;
 *	unsigned long *length;
 *	int *format;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void _SelectionReceived(w,client_data,selection,type,value,length,format)
  Widget w;
  XtPointer client_data;
  Atom *selection, *type;
  XtPointer value;
  unsigned long *length;
  int *format;
{
  TextWidget ctx = (TextWidget) w;
  XawTextBlock text;

  if (*type == 0 /*XT_CONVERT_FAIL*/  || *length == 0) {
    struct _SelectionList *list = (struct _SelectionList *)client_data;
    if (list != NULL) {
      GetSelection(w, list->time, list->params, list->count);
      XtFree(client_data);
    }
    return;
  }
  StartAction(ctx, NULL);
  text.ptr = (char *)value;
  text.firstPos = 0;
  text.length = *length;
  text.format = FMT8BIT;
  if (_XawTextReplace(ctx, ctx->text.insertPos, ctx->text.insertPos, &text)) {
    XBell(XtDisplay(ctx), 0);
    return;
  }
  ctx->text.insertPos = SrcScan(ctx->text.source, ctx->text.insertPos,
				XawstPositions, XawsdRight, text.length, TRUE);
  ((XlTextWidget)ctx)->xltext.change_cnt += text.length;

  EndAction(ctx);
  XtFree(client_data);
  XFree(value);		/* the selection value should be freed with XFree */
}

/* ^L */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void KillCurrentSelection(TRANSLATION PARAMTERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void KillCurrentSelection(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  XlTextWidget ctx = (XlTextWidget) w;
  Position pos = XltextYForCurrentPosition((TextWidget)ctx);

  XlSetGoalColumn((Widget)ctx, ctx->text.ev_x);
  _XawTextZapSelection((TextWidget) w, event, TRUE);
  XltextSetFocus(w, (XtPosition) pos);
}

/* ^L */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void _XawTextZapSelection(TextWidget ctx, XEvent *event,
 *					      XtBoolean kill)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void _XawTextZapSelection(ctx, event, kill)
  TextWidget ctx;
  XEvent *event;
  XtBoolean kill;
{
   StartAction(ctx, event);
   _DeleteOrKill(ctx, ctx->text.s.left, ctx->text.s.right, kill);
   EndAction(ctx);
}
