/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c: ltextsaving.c
 *
 * SCCSINFO:		@(#)ltextsaving.c	1.5 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with terminating an
 *	editing session, i.e. saving the information and closing the
 *	window.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * void XlSavetoDB(Widget w)
 * static void DoCommands(Widget w)
 **********************************************************************/

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* aimeditops.c */
extern int change(/* infonode *where, attrval *v */);

/*  */
/**********************************************************************
 * Function: void XlSavetoDB(Widget w)
 * 
 * Save widget contents to the database
 *
 * Modifications:
 *      <list mods with name and date>
 */
void XlSavetoDB(ctx)
  XlTextWidget ctx;
{
  attrval val;

  if (!ChangeFlag)
    return;

  if (!ctx->xltext.reference) {
    (void)fprintf(stderr, W_NOREFNOSAVE);
    return;
  }

  XtVaGetValues(Source, XtNstring, &val.attvalue, NULL);
  val.attsize = strlen(val.attvalue) + 1;

#ifdef DEBUG
  (void)fprintf(stderr, "Widgets: save text %s\n", val.attvalue);
#endif	/* DEBUG */

  if (ctx->xltext.reference->inode->iflg & NONEXIST_MSK) {
    make_cut_of_string(val.attvalue);
    if (paste(ctx->xltext.reference->inode,3)) {
      ChangeFlag = 0;
      return;
    }
    (void)fprintf(stderr, "Couldn't paste\n");
  }

  if (change(ctx->xltext.reference->inode, &val)) {
    (void)fprintf(stderr, W_NOSAVE);
    return;
  }

  ChangeFlag = 0;
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void DoCommands(Widget w)
 * 
 * Save widget contents to the database
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void DoCommands(ctx)
  XlTextWidget ctx;
{
  extern void do_commands();

  do_commands();
}
