/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	ltextaction.c: ltextinsertion.c
 *
 * SCCSINFO:		@(#)ltextinsertion.c	1.6 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with insertions.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * static void InsPlural(XlTextWidget w, XEvent *event)
 * static int InsertNewLineAndBackupInternal(XlTextWidget ctx)
 * static void InsertNewLineAndBackup(Widget w, XEvent *event)
 * static int LocalInsertNewLine(TextWidget ctx, XEvent *event)
 * static void InsertNewLine(Widget w, XEvent *event)
 * static void InsertNewLineAndIndent(Widget w, XEvent *event)
 * static void InsertChar(Widget w, XEvent *event)
 * static void InsertString(FOUR PARAMETERS)
 * static void TransposeCharacters(FOUR PARAMETERS)
 **********************************************************************/

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* aimeditops.c */
extern int create( /* identry *idp, attrval *v, int pos */ );

/* xstuff.c */
extern void FocusOnDisplay( /* reference_structure *r */ );

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void InsPlural(FOUR PARAMETERS)
 * Parameters:
 *      Widget w
 *      XEvent *event
 *      String *params
 *      Cardinal *num_params
 *
 * Create another one of the nearest enclosing plural kind.
 * The translation accepts the modifier strings "before" or "after" where
 * "before" is the default.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsPlural(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  XlTextWidget ctx = (XlTextWidget)w;
  int mode;
  attrval editstr;
  identry *idp;
  infonode *inp, *xnp;
  int new = 0;

  /* Ensure an un-bound view. */
  if (ReferenceP->ref->flags.bound) {
    XBell(XtDisplay((Widget)ctx), 50);
    return;
  }

  /* got to save if they've changed but not saved before m-l-i */
  if (ctx->xltext.change_cnt) {
    XlSavetoDB((XlTextWidget)w);
    new = 1;
  }

  /* Determine the nearest enclosing plural kind infonode. */
  for (inp = ctx->xltext.reference->inode; inp; inp = inp->parent) {
    if (!issingular(inp))
      break;
  }

  if (inp == (infonode *)NULL) {
    (void)fprintf(stderr, W_TOOMANY);
    return;
  }

  /* Determine mode */
  mode = 0;
  if ((*num_params) == 1) {
    static char *mode_table[] = {"before" ,"after"};
    int i;

    for (i = 0; i < XtNumber(mode_table); i++)
      if (!strcmp(params[0],mode_table[i])) {
	mode = i;
	break;
      }
  }

  /* Let mode be the insertion point index */
  if (inp->iflg & NONEXIST_MSK) {
    /* here we have to hack.  if they've just edited a placeholder then
     * immediately did a M-L-i (after), then they want the m-l-i to
     * create a second item.  the XlSavetoDB did a create of the first
     * item, so we force it to be at position 2.  really ugly 
     */
    if (new && (mode == 1)) /* if it's supposed to be after! 0 == before */
      mode = 2;
    else
      mode = 1;
  } else {
    for (xnp = inp->head->value, mode++; xnp; xnp = xnp->next, mode++)
      if (xnp == inp)
	break;
  }

  /* Setup creation arguments and call `create' */
  idp = inp->head;
  editstr.attvalue = idp->idname;
  editstr.attsize = strlen(idp->idname) + 1;
  if (create(idp, &editstr, mode) == FAIL) {
    (void)fprintf(stderr,W_NOCREATE);
    return;
  }
}


/*  */
/**********************************************************************
 * Function: static int InsertNewLineAndBackupInternal(XlTextWidget ctx)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static int InsertNewLineAndBackupInternal(ctx)
  XlTextWidget ctx;
{
  int count, error = XawEditDone;
  XawTextBlock text;
  char *buf, *ptr;

  if ((ptr = buf = XtMalloc((unsigned)sizeof(char) * Mult)) == NULL) {
    (void)fprintf(stderr, "InsertNewLineAndBackupInternal: XtMalloc failed.\n");
    (void)fprintf(stderr, "Consider this a fatal error....\n");
    return XawEditError;
  }

  for (count = 0; count < Mult; count++, ptr++)
    ptr[0] = '\n';

  text.length = Mult;
  text.ptr = buf;
  text.firstPos = 0;
  text.format = FMT8BIT;

  if (_XawTextReplace((TextWidget) ctx, Point, Point, &text)) {
    XBell(XtDisplay(ctx), 50);
    error = XawEditError;
  } else {
    ctx->text.showposition = TRUE;
    ChangeFlag += text.length;
  }

  XtFree((char *)buf);
  return (error);
}


/*  */
/**********************************************************************
 * Function: static void InsertNewLineAndBackup(Widget w, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsertNewLineAndBackup(w, event)
  Widget w;
  XEvent *event;
{
  StartAction((TextWidget) w, event);

  (void)InsertNewLineAndBackupInternal((XlTextWidget) w);

  EndAction((TextWidget) w);
}


/*  */
/**********************************************************************
 * Function: static int LocalInsertNewLine(TextWidget ctx, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static int LocalInsertNewLine(ctx, event)
  TextWidget ctx;
  XEvent *event;
{
  StartAction(ctx, event);

  if (InsertNewLineAndBackupInternal((XlTextWidget) ctx) == XawEditError)
    return (XawEditError);

  Point = SrcScan(Source, Point, XawstPositions, XawsdRight, Mult, TRUE);

  EndAction(ctx);

  return (XawEditDone);
}


/*  */
/**********************************************************************
 * Function: static void InsertNewLine(Widget w, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsertNewLine(w, event)
  Widget w;
  XEvent *event;
{
  (void)LocalInsertNewLine((TextWidget) w, event);
}


/*  */
/**********************************************************************
 * Function: static void InsertNewLineAndIndent(Widget w, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsertNewLineAndIndent(w, event)
  Widget w;
  XEvent *event;
{
  XawTextBlock text;
  XawTextPosition pos1, pos2;
  TextWidget ctx = (TextWidget) w;

  StartAction(ctx, event);

  pos1 = SrcScan(Source, Point, XawstEOL, XawsdLeft, 1, FALSE);
  pos2 = SrcScan(Source, pos1, XawstEOL, XawsdLeft, 1, TRUE);
  pos2 = SrcScan(Source, pos2, XawstWhiteSpace, XawsdRight, 1, TRUE);

  text.ptr = _XawTextGetText((TextWidget) ctx, pos1, pos2);
  text.length = strlen(text.ptr);
  if (LocalInsertNewLine(ctx, event))
    return;

  text.firstPos = 0;
  if (_XawTextReplace((TextWidget) ctx, Point, Point, &text)) {
    XBell(XtDisplay(ctx), 50);
  } else {
    Point =
      SrcScan(Source, Point, XawstPositions, XawsdRight, text.length, TRUE);
  }

  XtFree((char *)text.ptr);
  EndAction(ctx);
}


/*  */
/**********************************************************************
 * Function: static void InsertChar(Widget w, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsertChar(w, event)
  Widget w;
  XEvent *event;
{
  static XComposeStatus compose_status =
  {NULL, 0};
  XlTextWidget ctx = (XlTextWidget) w;
  char *ptr, strbuf[BUFSIZ];
  int count, error;
  KeySym keysym;
  XawTextBlock text;

  if ((text.length = XLookupString(&event->xkey, strbuf, BUFSIZ,
				   &keysym, &compose_status)) == 0) {
    return;
  }

  /* rather than calling SetAppend for every key press, which also gets
   * it for Meta and so on, i'll just set the previous state.
   */
  append_prev_state = 0;

  if (XlSearching(w)) {
    XlAddSearchChar(w, *strbuf);
    XlEndSearch(w, 1);
    return;
  }

  if (!(text.ptr = ptr = XtMalloc((unsigned)sizeof(char) * text.length*Mult))){
    (void)fprintf(stderr, "InsertChar: XtMalloc failed.\n");
    (void)fprintf(stderr, "Consider this a fatal error....\n");
    return;
  }

  for (count = 0; count < Mult; count++) {
    (void)strncpy(ptr, strbuf, text.length);
    ptr += text.length;
  }

  text.length = text.length * Mult;
  text.firstPos = 0;
  text.format = FMT8BIT;

  StartAction((TextWidget) ctx, event);

  error = _XawTextReplace((TextWidget) ctx, Point, Point, &text);

  if (error == XawEditDone) {
    Point =
      SrcScan(Source, Point, XawstPositions, XawsdRight, text.length, TRUE);
    AutoFill((TextWidget) ctx);
    ChangeFlag += text.length;
  } else
    XBell(XtDisplay(ctx), 50);

  XtFree((char *)text.ptr);
  EndAction((TextWidget) ctx);
}


/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void InsertString(FOUR PARAMETERS)
 * Parameters:
 *	Widget w;
 *	XEvent *event;
 *	String *params;
 *	Cardinal *num_params;
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void InsertString(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  TextWidget ctx = (TextWidget) w;
  XawTextBlock text;
  int i;

  text.firstPos = 0;
  StartAction(ctx, event);

  for (i = *num_params; i; i--, params++) {
    unsigned char hexval;
    if ((*params)[0] == '0' &&
	(*params)[1] == 'x' &&
	(*params)[2] != '\0') {
      char c, *p;
      hexval = 0;
      for (p = *params + 2; (c = *p); p++) {
	hexval *= 16;
	if (c >= '0' && c <= '9')
	  hexval += c - '0';
	else if (c >= 'a' && c <= 'f')
	  hexval += c - 'a' + 10;
	else if (c >= 'A' && c <= 'F')
	  hexval += c - 'A' + 10;
	else
	  break;
      }
      if (c == '\0') {
	text.ptr = (char *)&hexval;
	text.length = 1;
      } else {
	text.length = strlen(text.ptr = *params);
      }
    } else {
      text.length = strlen(text.ptr = *params);
    }
    if (text.length == 0)
      continue;
    if (_XawTextReplace((TextWidget) ctx, Point, Point, &text)) {
      XBell(XtDisplay(ctx), 50);
      break;
    }
    Point =
      SrcScan(Source, Point, XawstPositions, XawsdRight, text.length, TRUE);
  }

  EndAction(ctx);
}


/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void TransposeCharacters(FOUR PARAMETERS)
 * Parameters:
 *	Widget w		- text widget
 *	XEvent *event		- X event
 *	String * params		- not used
 * 	Cardinal * num_params	- not used
 *
 * Swaps the character to the left of the mark with the character
 * to the right of the mark.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void TransposeCharacters(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  XlTextWidget ctx = (XlTextWidget) w;
  XawTextPosition start, end;
  XawTextBlock text;
  unsigned char *buf, c;
  int i;

  StartAction((TextWidget) ctx, event);

  /*
 * Get bounds.
 */

  start = SrcScan(Source, Point, XawstPositions, XawsdLeft, 1, TRUE);
  end = SrcScan(Source, Point, XawstPositions, XawsdRight, Mult, TRUE);

  if ((start == Point) || (end == Point))
    XBell(XtDisplay(w), 0);	/* complain. */
  else {
    Point = end;

    /*
     * Retrieve text and swap the characters.
     */

    buf = (unsigned char *)_XawTextGetText((TextWidget) ctx, start, end);
    text.length = strlen((char *)buf);
    text.firstPos = 0;
    text.format = FMT8BIT;

    c = buf[0];
    for (i = 1; i < text.length; i++)
      buf[i - 1] = buf[i];
    buf[i - 1] = c;

    ChangeFlag += 2;

    /*
     * Store new text in source.
     */

    text.ptr = (char *)buf;
    (void)_XawTextReplace((TextWidget) ctx, start, end, &text);

    XtFree((char *)buf);
  }
  EndAction((TextWidget) ctx);
}
