/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c: ltextfocussing.c
 *
 * SCCSINFO:		@(#)ltextfocussing.c	1.5 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with keyboard focussing.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * Function: static void TextFocusIn (Widget w, XEvent *event)
 * Function: static void TextFocusOut(Widget w, XEvent *event)
 **********************************************************************/

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void IconifyWin (Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void IconifyWin (w, event)
  Widget w;
  XEvent *event;
{
  while (!XtIsSubclass(w, shellWidgetClass)) {
    if ((w = XtParent(w)) == (Widget) NULL)
      return;
  }
  XIconifyWindow(XtDisplay(w), XtWindow(w),
		 XScreenNumberOfScreen(XtScreen(w)));
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void RaiseWin (Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void RaiseWin (w, event)
  Widget w;
  XEvent *event;
{
  while (!XtIsSubclass(w, shellWidgetClass)) {
    if ((w = XtParent(w)) == (Widget) NULL)
      return;
  }
  XRaiseWindow(XtDisplay(w), XtWindow(w));
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void LowerWin (Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void LowerWin (w, event)
  Widget w;
  XEvent *event;
{
  while (!XtIsSubclass(w, shellWidgetClass)) {
    if ((w = XtParent(w)) == (Widget) NULL)
      return;
  }
  XLowerWindow(XtDisplay(w), XtWindow(w));
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void TextFocusIn (Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void TextFocusIn (w, event)
  Widget w;
  XEvent *event;
{
  if (event && event->xfocus.send_event)
    XawTextDisplayCaret (w, TRUE);

#ifdef DEBUG
  (void)fprintf(stderr, "leaving TextFocusIn\n");
  sync(XtDisplay(w));
#endif /* debug */
}


/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void TextFocusOut(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void TextFocusOut(w, event)
  Widget w;
  XEvent *event;
{
  XlTextWidget ctx = (XlTextWidget) w;

  if (ctx->text.display_caret) {
    XlLayoutLostFocus(XtParent(w), XltextYForCurrentPosition((TextWidget)ctx));
  }
  XawTextDisplayCaret((Widget)ctx, FALSE);

#ifdef DEBUG
  (void)fprintf(stderr, "leaving TextFocusOut\n");
  sync(XtDisplay(w));
#endif /* debug */
}


/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: void TextLeave(Widget w, XEvent *event)
 *
 * Handles window exit events, i.e. what to do when the mouse is moved
 * out of a text widget. 
 *
 * Modifications:
 *      <list mods with name and date>
 */
void TextLeave(w, event)
  Widget w;
  XEvent *event;
{
  XlTextWidget ctx = (XlTextWidget) w;

  if (event && (event->xcrossing.detail == NotifyInferior))
    return; /* This is an "unclutter" hack. */

  if (ctx->text.display_caret) {
    XlLayoutLostFocus(XtParent(w), XltextYForCurrentPosition((TextWidget)ctx));
  }
  if (ctx->xltext.change_cnt)
    XlSavetoDB(ctx);

#ifdef DEBUG
  (void)fprintf(stderr, "leaving TextLeave\n");
  sync(XtDisplay(w));
#endif /* debug */
}
