/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c: ltextbuttons.c
 *
 * SCCSINFO:		@(#)ltextbuttons.c	1.4 5/20/94
 *
 * ORIGINAL AUTHOR(S):  David Partain, 1992-04-03
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions that correspond to a window
 *	button.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * static void CompareVersions(FOUR PARAMETERS)
 * static void ExportWindow(FOUR PARAMETERS)
 * static void ShowGpd(FOUR PARAMETERS)
 * static void ShowHistory(FOUR PARAMETERS)
 * static void ShowNodeHistory(FOUR PARAMETERS)
 * static void ShowRefStruct(FOUR PARAMETERS)
 * static void StoreWindow(FOUR PARAMETERS)
 * static void CloseWindow(FOUR PARAMETERS)
 * static void PromoteVersion(FOUR PARAMETERS)
 * static void RefetchLatest(FOUR PARAMETERS)
 * static void CloseWidls(FOUR PARAMETERS)
 **********************************************************************/

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void PromoteVersion(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void PromoteVersion(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;
  promotecmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void RefetchLatest(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void RefetchLatest(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;
  refetchcmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void ExportWindow(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ExportWindow(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;
  exportcmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void ShowGpd(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ShowGpd(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;
  showgpdcmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void ShowHistory(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ShowHistory(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;
  histcmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void CloseWidls(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void CloseWidls(w, event, params, num_params)
  Widget w;		/* unused */
  XEvent *event;	/* unused */
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  closewidlcmd((Widget)NULL, (caddr_t)NULL, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void ShowNodeHistory(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ShowNodeHistory(w, event, params, num_params)
  Widget w;		/* unused */
  XEvent *event;	/* unused */
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  nodehistcmd((Widget)NULL, (caddr_t)NULL, (caddr_t)NULL);
}
/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void ShowRefStruct(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void ShowRefStruct(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;
  dumpcmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void StoreWindow(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void StoreWindow(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;

  storecmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}


/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void CloseWindow(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void CloseWindow(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;

  closecmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void CloseAllWindows(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void CloseAllWindows(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;

  closeallcmd((Widget)ctx, (caddr_t)NULL, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void StoreAllWindows(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void StoreAllWindows(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;

  store_all_cmd((Widget)ctx, (caddr_t)NULL, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void Logout(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void Logout(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;

  quitcmd((Widget)ctx, (caddr_t)NULL, (caddr_t)NULL);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void CompareVersions(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	String *params		- unused
 *	Cardinal *num_params	- unused
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void CompareVersions(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;	/* unused */
  Cardinal *num_params;	/* unused */
{
  XlTextWidget ctx = (XlTextWidget) w;
  objdiffcmd((Widget)ctx, (caddr_t)ReferenceP->ref, (caddr_t)NULL);
}
