/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c
 *
 * SCCSINFO:		@(#)ltextaction.c	1.8 6/6/94
 *
 * ORIGINAL AUTHOR(S):  
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains the key command action entries for the
 *	XlText widget.
 *
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/TextP.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>

#include "werror.h"
#include "ltextP.h"
#include "ltextsrcP.h"
#include "layout.h"
#include "view.h"	/* for XlScrollFocus to get widget class */

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_ltextaction.h"

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_view.h"
#include "f_layout.h"
#include "f_ltextsink.h"
#include "f_generic.h"
#include "f_ltext.h"

/* these need to go in a file */
/* aimcommand.c */
extern void closeallcmd();
extern void closecmd();
extern void closewidlcmd();
extern void dumpcmd();
extern void exportcmd();
extern void histcmd();
extern void nodehistcmd();
extern void promotecmd();
extern void quitcmd();
extern void refetchcmd();
extern void showgpdcmd();
extern void storecmd();
extern void store_all_cmd();

/* aimcutbuf.c */
extern void copy_region( /* infonode *fst,infonode *lst, int cut */ );
extern void make_cut_of_string( /* char *s */ );
extern int paste( /* infonode *inp, int after */ );

/* chng_prop.c */
extern void objdiffcmd();

/* xstuff.c */
extern void expandfn();
extern void popfn();
extern void selectfn();
extern void uim_highlight P_((infonode *inp));

/* Xaw stuff */
extern void _XawTextInsertFileAction P_(( Widget w, XEvent *event, String *
                                   params, Cardinal * num_params ));
extern void _XawTextInsertFile P_(( Widget w, XEvent *event, String * params,
                             Cardinal * num_params ));
extern void _XawTextDoSearchAction P_(( Widget w, XEvent *event, String *
                                 params, Cardinal * num_params ));
extern void _XawTextDoReplaceAction P_(( Widget w, XEvent *event, String *
                                  params, Cardinal * num_params ));
extern void _XawTextSetField P_(( Widget w, XEvent *event, String * params,
                            Cardinal * num_params ));
extern void _XawTextPopdownSearchAction P_(( Widget w, XEvent *event, String *
                                      params, Cardinal * num_params ));

extern char * _XawTextGetText P_(( TextWidget ctx, XawTextPosition left,
                             XawTextPosition right ));
extern void _XawTextBuildLineTable P_(( TextWidget ctx, XawTextPosition
                                  position, XtBoolean force_rebuild ));
extern void _XawTextAlterSelection P_(( TextWidget ctx, XawTextSelectionMode
                                  mode, XawTextSelectionAction action,
                                  String *params, Cardinal *num_params ));
extern void _XawTextVScroll P_(( TextWidget ctx, int n ));
extern void _XawTextSetSelection P_(( TextWidget ctx, XawTextPosition l,
                                XawTextPosition r, String *list, Cardinal
                                nelems ));
extern void _XawTextCheckResize P_(( TextWidget ctx ));
extern void _XawTextCheckResize P_(( TextWidget ctx ));
extern void _XawTextExecuteUpdate P_(( TextWidget ctx ));
extern void _XawTextClearAndCenterDisplay P_(( TextWidget ctx ));
extern Atom* _XawTextSelectionList P_(( TextWidget ctx, String *list, Cardinal
                                  nelems ));
extern int _XawTextPrepareToUpdate P_(( TextWidget ctx ));

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* aimcommand.c */
extern infonode *previousinfonode;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
typedef struct _SelectionList {
    String *params;
    Cardinal count;
    Time time;
} *SelectionList;

#ifdef DEBUG
/* since SyncHandle() requires that dpy be in local context */
#define sync(dpy) \
	if (dpy->synchandler) (*dpy->synchandler)(dpy); \
	sleep(1)
#endif /* DEBUG */

#define SrcScan                XawTextSourceScan
#define FindDist               XawTextSinkFindDistance
#define FindPos                XawTextSinkFindPosition

#define Point		ctx->text.insertPos
#define LastPos		ctx->text.lastPos
#define Source		ctx->text.source
#define Sink		ctx->text.sink
#define Mult		ctx->text.mult
#define LeftMargin	ctx->text.margin.left
#define RightMargin	ctx->text.margin.right
#define Info		ctx->text.lt.info
#define Lines		ctx->text.lt.lines

#define ReferenceP	ctx->xltext.reference
#define Inode		ReferenceP->inode
#define ChangeFlag	ctx->xltext.change_cnt

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static void AutoFill P_(( TextWidget ctx ));
static void CloseAllWindows P_(( Widget w, XEvent *event, String
                                  *params, Cardinal *num_params ));
static void CloseWidls P_(( Widget w, XEvent *event, String *params,
                             Cardinal *num_params ));
static void CloseWindow P_(( Widget w, XEvent *event, String *params,
                              Cardinal *num_params ));
static void CompareVersions P_(( Widget w, XEvent *event, String *params,
                                 Cardinal *num_params ));
static void DeleteBackwardChar P_(( Widget w, XEvent *event, String *p,
                                     Cardinal *n ));
static void DeleteBackwardWord P_(( Widget w, XEvent *event, String *p,
                                     Cardinal *n ));
static void DeleteForwardChar P_(( Widget w, XEvent *event, String *p,
                                    Cardinal *n ));
static void DeleteForwardWord P_(( Widget w, XEvent *event, String *p,
                                    Cardinal *n ));
static void DeleteOrKill P_(( TextWidget ctx, XEvent *event,
                               XawTextScanDirection dir, XawTextScanType
                               type, XtBoolean include, XtBoolean kill ));
static void DelPlural P_(( XlTextWidget ctx, XEvent *event ));
static void DoCommands P_(( XlTextWidget ctx ));
static void EndAction P_(( TextWidget ctx ));
static void expand_in_new P_(( Widget w, XEvent *event, String *params,
                                Cardinal *num_params ));
static void expand_in_place P_(( Widget w, XEvent *event, String
                                  *params, Cardinal *num_params ));
static void ExportWindow P_(( Widget w, XEvent *event, String *params,
                               Cardinal *num_params ));
static void ExtendAdjust P_(( Widget w, XEvent *event, String *params,
                               Cardinal *num_params ));
static void ExtendEnd P_(( Widget w, XEvent *event, String *params,
                            Cardinal *num_params ));
static void ExtendStart P_(( Widget w, XEvent *event, String *params,
                              Cardinal *num_params ));
static void FormParagraph P_(( Widget w, XEvent *event, String * params,
                                Cardinal * num_params ));
static void FormRegion P_(( TextWidget ctx, XawTextPosition from,
                             XawTextPosition to ));
static void GetSelection P_(( Widget w, Time time, String *params,
                               Cardinal num_params ));
static void IconifyWin P_(( Widget w, XEvent *event ));
static void InsertChar P_(( Widget w, XEvent *event ));
static void InsertNewCRs P_(( TextWidget ctx, XawTextPosition from,
                               XawTextPosition to ));
static void InsertNewLine P_(( Widget w, XEvent *event ));
static void InsertNewLineAndBackup P_(( Widget w, XEvent *event ));
static int InsertNewLineAndBackupInternal P_(( XlTextWidget ctx ));
static void InsertNewLineAndIndent P_(( Widget w, XEvent *event ));
static void InsertSelection P_(( Widget w, XEvent *event, String
                                  *params, Cardinal *num_params ));
static void InsertString P_(( Widget w, XEvent *event, String *params,
                               Cardinal *num_params ));
static void InsPlural P_(( Widget w, XEvent *event, String *params,
                            Cardinal *num_params ));
static void JoinText P_(( Widget w, XEvent *event ));
static void JoinTextInternal P_(( TextWidget ctx ));
static void KillBackwardWord P_(( Widget w, XEvent *event, String *p,
                                   Cardinal *n ));
static void KillCurrentSelection P_(( Widget w, XEvent *event, String
                                       *p, Cardinal *n ));
static void KillForwardWord P_(( Widget w, XEvent *event, String *p,
                                  Cardinal *n ));
static void KillToEndOfLine P_(( Widget w, XEvent *event, String *p,
                                  Cardinal *n ));
static void KillToEndOfParagraph P_(( Widget w, XEvent *event, String
                                       *p, Cardinal *n ));
static int LocalInsertNewLine P_(( TextWidget ctx, XEvent *event ));
static void Logout P_(( Widget w, XEvent *event, String *params,
                         Cardinal *num_params ));
static void LowerWin P_(( Widget w, XEvent *event ));
static void ModifySelection P_(( TextWidget ctx, XEvent *event,
                                  XawTextSelectionMode mode,
                                  XawTextSelectionAction action, String
                                  *params, Cardinal *num_params ));
static void Move P_(( TextWidget ctx, XEvent *event,
                       XawTextScanDirection dir, XawTextScanType type,
                       XtBoolean include ));
static void MoveBackwardChar P_(( Widget w, XEvent *event ));
static void MoveBackwardParagraph P_(( Widget w, XEvent *event ));
static void MoveBackwardWord P_(( Widget w, XEvent *event ));
static void MoveBeginningOfFile P_(( Widget w, XEvent *event ));
static void MoveEndOfFile P_(( Widget w, XEvent *event ));
static void MoveForwardChar P_(( Widget w, XEvent *event ));
static void MoveForwardParagraph P_(( Widget w, XEvent *event ));
static void MoveForwardWord P_(( Widget w, XEvent *event ));
static void MoveLine P_(( TextWidget ctx, XEvent *event,
                           XawTextScanDirection dir ));
static void MoveNextLine P_(( Widget w, XEvent *event ));
static void MoveNextPage P_(( Widget w, XEvent *event ));
static void MovePage P_(( TextWidget ctx, XEvent *event,
                           XawTextScanDirection dir ));
static void MovePreviousLine P_(( Widget w, XEvent *event ));
static void MovePreviousPage P_(( Widget w, XEvent *event ));
static void MoveToLineEnd P_(( Widget w, XEvent *event ));
static void MoveToLineStart P_(( Widget w, XEvent *event ));
static void NoOp P_(( Widget w, XEvent *event, String *params, Cardinal
                       *num_params ));
static void PlaceCursor P_(( TextWidget ctx, int line ));
static void pop_in_new P_(( Widget w, XEvent *event, String *params,
                             Cardinal *num_params ));
static void pop_in_place P_(( Widget w, XEvent *event, String *params,
                               Cardinal *num_params ));
static void PromoteVersion P_(( Widget w, XEvent *event, String *params,
                                 Cardinal *num_params ));
static void RaiseWin P_(( Widget w, XEvent *event ));
static void RedrawDisplay P_(( Widget w, XEvent *event ));
static void RefetchLatest P_(( Widget w, XEvent *event, String *params,
                                Cardinal *num_params ));
static void SelectStart P_(( Widget w, XEvent *event, String *params,
                              Cardinal *num_params ));
static void SetAppend P_(( Widget w, XEvent *event, String *params,
                            Cardinal *num_params ));
static void ShowGpd P_(( Widget w, XEvent *event, String *params,
                          Cardinal *num_params ));
static void ShowHistory P_(( Widget w, XEvent *event, String *params,
                              Cardinal *num_params ));
static void ShowNodeHistory P_(( Widget w, XEvent *event, String
                                  *params, Cardinal *num_params ));
static void ShowRefStruct P_(( Widget w, XEvent *event, String *params,
                                Cardinal *num_params ));
static void SplitText P_(( Widget w, XEvent *event ));
static void StartAction P_(( TextWidget ctx, XEvent *event ));
static void StoreAllWindows P_(( Widget w, XEvent *event, String
                                  *params, Cardinal *num_params ));
static void StoreWindow P_(( Widget w, XEvent *event, String *params,
                              Cardinal *num_params ));
static XawTextPosition StripOutOldCRs P_(( TextWidget ctx,
                                            XawTextPosition from,
                                            XawTextPosition to ));
static void TextFocusIn P_(( Widget w, XEvent *event ));
static void TextFocusOut P_(( Widget w, XEvent *event ));
static void TextSearch P_(( Widget w, XEvent *event, String *strtbl,
                             Cardinal *n ));
static void TransposeCharacters P_(( Widget w, XEvent *event, String
                                      *params, Cardinal *num_params ));
static void XlScrollFocus P_(( TextWidget ctx ));
static void _DeleteOrKill P_(( TextWidget ctx, XawTextPosition from,
                                XawTextPosition to, XtBoolean kill ));
static void _SelectionReceived P_(( Widget w, XtPointer client_data,
                                     Atom *selection, Atom *type,
                                     XtPointer value, unsigned long
                                     *length, int *format ));
static void _XawTextZapSelection P_(( TextWidget ctx, XEvent *event,
                                       XtBoolean kill ));
static int _XlLineForPosition P_(( TextWidget ctx, XawTextPosition
                                    position ));

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
static int global_appendflag = 0;
static int append_prev_state = 0;

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
int horrible_global_flag = 0;

/*
 * Handled only in ltextaction.c:EndAction and inspected in
 * ltextsink.c:ClearToBackground. Have a fit.
 */

/* Action Table */
XtActionsRec xltextActionsTable[] = {
/* motion bindings */
  {"forward-character", 	(XtActionProc)MoveForwardChar},
  {"backward-character", 	(XtActionProc)MoveBackwardChar},
  {"forward-word", 		(XtActionProc)MoveForwardWord},
  {"backward-word", 		(XtActionProc)MoveBackwardWord},
  {"forward-paragraph", 	(XtActionProc)MoveForwardParagraph},
  {"backward-paragraph", 	(XtActionProc)MoveBackwardParagraph},
  {"beginning-of-line", 	(XtActionProc)MoveToLineStart},
  {"end-of-line", 		(XtActionProc)MoveToLineEnd},
  {"next-line", 		(XtActionProc)MoveNextLine},
  {"previous-line", 		(XtActionProc)MovePreviousLine},
  {"next-page", 		(XtActionProc)MoveNextPage},
  {"previous-page", 		(XtActionProc)MovePreviousPage},
  {"beginning-of-file", 	(XtActionProc)MoveBeginningOfFile},
  {"end-of-file", 		(XtActionProc)MoveEndOfFile},
/* delete bindings */
  {"delete-next-character", 	(XtActionProc)DeleteForwardChar},
  {"delete-previous-character", (XtActionProc)DeleteBackwardChar},
  {"delete-next-word", 		(XtActionProc)DeleteForwardWord},
  {"delete-previous-word", 	(XtActionProc)DeleteBackwardWord},
/* kill bindings */
  {"kill-word", 		(XtActionProc)KillForwardWord},
  {"backward-kill-word", 	(XtActionProc)KillBackwardWord},
  {"join-text",			(XtActionProc)JoinText},
  {"split-text",		(XtActionProc)SplitText},
  {"kill-to-end-of-line", 	(XtActionProc)KillToEndOfLine},
  {"kill-to-end-of-paragraph", 	(XtActionProc)KillToEndOfParagraph},
/* new line stuff */
  {"newline-and-indent", 	(XtActionProc)InsertNewLineAndIndent},
  {"newline-and-backup", 	(XtActionProc)InsertNewLineAndBackup},
  {"newline", 			(XtActionProc)InsertNewLine},
/* expansion and popping stuff*/
  {"pop-in-new", 		(XtActionProc)pop_in_new},
  {"pop-in-place", 		(XtActionProc)pop_in_place},
  {"exp-in-new", 		(XtActionProc)expand_in_new},
  {"exp-in-place", 		(XtActionProc)expand_in_place},
/* Stuff to select parts of an item and put it in the X buffers */
  {"select-start",  		(XtActionProc)SelectStart},
  {"extend-adjust", 		(XtActionProc)ExtendAdjust},
  {"extend-end", 		(XtActionProc)ExtendEnd},
  {"insert-selection", 		(XtActionProc)InsertSelection},
  {"extend-start", 		(XtActionProc)ExtendStart},
  {"kill-selection",            (XtActionProc)KillCurrentSelection},
/* Save and Write bindings */
  {"save-text", 		(XtActionProc)XlSavetoDB},
  {"save-all-text", 		(XtActionProc)XlSaveChildren},
  {"do-commands", 		(XtActionProc)DoCommands}, 
  {"close-window",		(XtActionProc)CloseWindow},
  {"close-all-windows",		(XtActionProc)CloseAllWindows},
  {"store-window",		(XtActionProc)StoreWindow},
  {"store-all-windows",		(XtActionProc)StoreAllWindows},
  {"logout",			(XtActionProc)Logout},
  {"show-ref-struct",		(XtActionProc)ShowRefStruct},
  {"show-history",		(XtActionProc)ShowHistory},
  {"show-node-history",		(XtActionProc)ShowNodeHistory},
  {"show-gpd",			(XtActionProc)ShowGpd},
  {"export-window",		(XtActionProc)ExportWindow},
  {"close-widls",		(XtActionProc)CloseWidls},
/* Special Lincks commands which use meta-L */
  {"insert-plural",             (XtActionProc)InsPlural},
  {"delete-plural",             (XtActionProc)DelPlural},
  {"promote-version",		(XtActionProc)PromoteVersion},
  {"refetch-latest",		(XtActionProc)RefetchLatest},
  {"compare-versions",		(XtActionProc)CompareVersions},
/* Miscellaneous */
  {"redraw-display", 		(XtActionProc)RedrawDisplay},
  {"search",		        (XtActionProc)TextSearch},
  {"insert-char", 		(XtActionProc)InsertChar},
  {"insert-string",		(XtActionProc)InsertString},
  {"raise-win",			(XtActionProc)RaiseWin},
  {"lower-win",			(XtActionProc)LowerWin},
  {"iconify-win",		(XtActionProc)IconifyWin},
  {"focus-in", 	 	        (XtActionProc)TextFocusIn},
  {"focus-out", 		(XtActionProc)TextFocusOut},
  {"leave-window",		(XtActionProc)TextLeave},
  {"form-paragraph",            (XtActionProc)FormParagraph},
  {"transpose-characters",      (XtActionProc)TransposeCharacters},
  {"set-append",      		(XtActionProc)SetAppend},
  {"no-op",                     (XtActionProc)NoOp},
/* Action to bind special translations for text Dialogs. */
  {"InsertFileAction",          (XtActionProc)_XawTextInsertFileAction},
  {"DoSearchAction",            (XtActionProc)_XawTextDoSearchAction},
  {"DoReplaceAction",           (XtActionProc)_XawTextDoReplaceAction},
  {"SetField",                  (XtActionProc)_XawTextSetField},
  {"PopdownSearchAction",       (XtActionProc)_XawTextPopdownSearchAction},
};

Cardinal xltextActionsTableCount = XtNumber(xltextActionsTable);

/*  */
/**********************************************************************
  EDITING ACTIONS ARE DEFINED IN THE FOLLOWING CODE INCLUDES:
 **********************************************************************/
#include "ltextdeletion.c"
#include "ltextfocussing.c"
#include "ltextinsertion.c"
#include "ltextjustify.c"
#include "ltextmovement.c"
#include "ltextpublic.c"
#include "ltextsaving.c"
#include "ltextscrolling.c"
#include "ltextselection.c"
#include "ltextbuttons.c"


/*  */
/**********************************************************************
 * Function: static void StartAction(TextWidget ctx, XEvent *event)
 * 
 * Pick up event time and mouse position at event time.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void StartAction(ctx, event)
  TextWidget ctx;
  XEvent *event;
{
  _XawTextPrepareToUpdate(ctx);

  if (event != NULL) {
    switch (event->type) {
    case ButtonPress:
    case ButtonRelease:
      ctx->text.time = event->xbutton.time;
      ctx->text.ev_x = event->xbutton.x;
      ctx->text.ev_y = event->xbutton.y;
      break;
    case KeyPress:
    case KeyRelease:
      ctx->text.time = event->xkey.time;
      ctx->text.ev_x = event->xkey.x;
      ctx->text.ev_y = event->xkey.y;
      break;
    case MotionNotify:
      ctx->text.time = event->xmotion.time;
      ctx->text.ev_x = event->xmotion.x;
      ctx->text.ev_y = event->xmotion.y;
      break;
    case EnterNotify:
    case LeaveNotify:
      ctx->text.time = event->xcrossing.time;
      ctx->text.ev_x = event->xcrossing.x;
      ctx->text.ev_y = event->xcrossing.y;
    }
  }
}


/*  */
/**********************************************************************
 * Function: static void EndAction(TextWidget ctx)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void EndAction(ctx)
  TextWidget ctx;
{
  horrible_global_flag = 1;	/* Used in ltextsink.c:ClearToBackground */
  _XlTextCheckResize(ctx);
  _XawTextExecuteUpdate(ctx);
  Mult = 1;

  XlScrollFocus(ctx);

  XlSkipGoalSet((Widget)ctx,0);	/* Let goal column be set at next command. */
  XlEndSearch((Widget)ctx,0);		/* End searching as the normal case */
  horrible_global_flag = 0;	/* Used in ltextsink.c:ClearToBackground */
}


/*  */
/**********************************************************************
 * Function: static int _XlLineForPosition(TWO PARAMETERS)
 * Parameters:
 *	TextWidget ctx
 *	XawTextPosition position
 * 
 * This routine maps a source position in to the corresponding line number
 * of the text that is displayed in the window.
 *
 * This function depends on the existence of a valid line table!
 *
 * Modifications:
 *      <list mods with name and date>
 */
static int _XlLineForPosition (ctx, position)
  TextWidget ctx;
  XawTextPosition position;
{
  int line;
  
  for (line = 0; line < Lines; line++)
    if (position < Info[line + 1].position)
      break;
  return(line);
}


/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void NoOp(FOUR PARAMETERS)
 * Parameters:
 *	Widget w		- text widget
 *	XEvent *event		- not used
 *	String *params		- action parameters
 *	Cardinal *num_params	- action parameters
 * 
 * This action performs no action, and allows the user or application
 * programmer to unbind a translation.
 *
 * Note: If the parameter list contains the string "RingBell" then
 *       this action will ring the bell.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void NoOp(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
    if (*num_params != 1)
	return;

    switch(params[0][0]) {
    case 'R':
    case 'r':
	XBell(XtDisplay(w), 0);
    default:			/* Fall Through */
	break;
    }
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void SetAppend(TRANSLATION PARAMETERS)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void SetAppend(w, event, params, num_params)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal *num_params;
{
  if (*num_params != 1)
    return;
  if ((append_prev_state == 1) && (params[0][0] == '1'))
    global_appendflag = 1;
  else
    global_appendflag = 0;
  append_prev_state = (params[0][0] == '0') ? 0 : 1;
}
