/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	generic.c
 *
 * SCCSINFO:		@(#)generic.c	1.6 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Nilgun & Michael Jansson, 1990-09-11
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds two functions that handle key commanded point
 *	movements across items in a layout.
 *
 *********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************
 * void Xlgenvmove(Widget w, XEvent *event, XawTextScanDirection dir,int mult)
 * void Xlgenhmove(Widget w, XEvent *ev, XawTextScanDirection dir, XawTextScanType type, XtBoolean include);
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/TextP.h>
#include "layout.h"
#include "ltext.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_generic.h"

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_layout.h"
#include "f_ltextpublic.h"
#include "f_ltextfocussing.h"
#include "f_ltextaction.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
static TextWidget NextAbove P_(( Widget w, Widget nw ));
static TextWidget NextBelow P_(( Widget w, Widget nw ));

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: void Xlgenhmove(FIVE PARAMETERS)
 * Parameters:
 *      Widget w
 *      XEvent *ev
 *      XawTextScanDirection dir
 *      XawTextScanType type
 *      XtBoolean include
 * 
 * Execute move action that has spilled over item boundary. This
 * function handles contents dependent movements (forward/backward
 * over character/word/paragraph) and horisontal line movements
 * (beginning/end of line).
 *
 * Modifications:
 *      <list mods with name and date>
 */
void Xlgenhmove(w, event, dir, type, include)
Widget w;
XEvent *event;
XawTextScanDirection dir;  /* These should be generic types too. */
XawTextScanType type;	   /* they serve their purpose. */
XtBoolean include;
{
  TextWidget blah = (TextWidget)w;
  int offset = (dir == XawsdRight) ? 1 : -1;
  XawTextScanDirection opposite_dir = 
	(dir == XawsdRight) ? XawsdLeft : XawsdRight;
  int mult;
  short y;
  Widget nw;
  
  mult = XltextMult(blah,-1);
  y = XltextYForCurrentPosition(blah);
  
  while ((nw = XlChildIndex(w,offset)) != (Widget)NULL) {
    if (XtIsSubclass((Widget)nw, textWidgetClass)) {
      if (type != XawstEOL) break;
      /* Beginning/end of line moves. */
      if ((nw->core.y) > y || ((short)(nw->core.y + nw->core.height) < y)) {
	nw = (Widget)NULL;
	break;
      }
      w = nw;
    }
  }

  if (nw == (Widget)NULL) {
    /* There is no next text widget. */
    XltextMove((TextWidget)w, (XEvent *)NULL, dir, type, include);
    return;
  }

  /* Move its point to start/end of text. The movement direction here
     is opposite to the commanded movement. This move consumes one
     character movement, so the repetition counter `mult' must be
     adjusted appropriately.
     */

  (void)XltextMult((TextWidget)nw, 1);
  XltextMove((TextWidget)nw, (XEvent *)NULL, opposite_dir, XawstAll, TRUE);

  /* Process remaining moves. */
  if (type == XawstPositions)
    mult--;

  if (mult > 0) {
    (void)XltextMult((TextWidget)nw, mult);
    XltextMove((TextWidget)nw, (XEvent *)NULL, dir, type, include);
  }

  /* Setup goal column using current insert position. */
  XlSetGoalColumn(nw, ((dir==XawsdRight)?0:(int)nw->core.width));

  /* Lose focus at the current line. */
  TextLeave(w, (XEvent *)NULL);
  XlLayoutLostFocus((Widget)XtParent(w), 
		    XltextYForCurrentPosition((TextWidget)nw));
  LayoutFocusIn(XtParent(w));
}

/*  */
/**********************************************************************
 * Function: static TextWidget NextBelow(Widget w,Widget nw)
 *
 * Find next widget to process "next line" command.
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static TextWidget NextBelow(w,nw)
     Widget w, nw;
{
  TextWidget xnw = (TextWidget)NULL;

  while ((nw = XlChildIndex(nw,1))) {
    if ((XtIsSubclass((Widget)nw,textWidgetClass)) &&
	(((short)(w->core.y + w->core.height) < nw->core.y) &&
	 ((xnw == (TextWidget)NULL) ||
	  (nw->core.y < xnw->core.y) ||
	  ((nw->core.y == xnw->core.y) && (XlGetGoalColumn(nw) >= 0)))))
      xnw = (TextWidget) nw;
    if (xnw && (nw->core.y > (short)(xnw->core.y + xnw->core.height)))
      break;
  }
  return xnw;
}

/*  */
/**********************************************************************
 * Function: static TextWidget NextAbove(Widget w,Widget nw)
 *
 * Find next widget to process "previous line" command.
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static TextWidget NextAbove(w,nw)
     Widget w, nw;
{
  TextWidget xnw = (TextWidget)NULL;

  while ((nw = XlChildIndex(nw,-1))) {
    if ((XtIsSubclass((Widget)nw,textWidgetClass)) &&
	(((short)(nw->core.y + nw->core.height) < w->core.y) &&
	 ((xnw == (TextWidget)NULL) ||
	  ((short)(nw->core.y+nw->core.height) > (short)(xnw->core.y+xnw->core.height)) ||
	  ((nw->core.y == xnw->core.y) && (XlGetGoalColumn(nw) >= 0)))))
      xnw = (TextWidget) nw;
    if (xnw && ((short)(nw->core.y + nw->core.height) < xnw->core.y))
      break;
  }
  return xnw;
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: void Xlgenvmove(FOUR PARAMETERS)
 *
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	XawTextScanDirection dir
 *	int mult
 *
 * Execute up/down line movement that spills over item boundary. The
 * target item is found as the lowest above/highest below item whose left
 * side is as close to and preferrably left of the current goal column.
 * 
 * Modifications:
 *      <list mods with name and date>
 */
void Xlgenvmove(w, event, dir, mult)
     Widget w;
     XEvent *event;
     XawTextScanDirection dir;
     int mult;
{
  TextWidget nw = (TextWidget) w;
  TextWidget xnw = (TextWidget) w;
  int pos = 0;
  
  while (mult > 0) {
    xnw = nw;
    nw = ((dir == XawsdRight) ? NextBelow(w,(Widget)nw) 
			      : NextAbove(w,(Widget)nw));
    if (nw == (TextWidget)NULL) {
      /* There is no neighbor item to move to. */
      pos = (dir == XawsdRight) ? XltextLastLineIndex((TextWidget)xnw) : 0;
      break;
    }

    if (mult <= (XltextLastLineIndex((TextWidget)nw) + 1)) {
      /* Movement is within nw */
      xnw = nw;
      mult -= 1;
      pos = (dir == XawsdLeft) ?
	(XltextLastLineIndex((TextWidget)xnw)-mult) : mult ;
      break;
    }

    /* Movement goes (probably) beyond this item too. */
    mult -= XltextLastLineIndex((TextWidget)nw) + 1;
  }
  XltextPlaceCursor(xnw,pos);

  /* Lose focus at the current line. */
  TextLeave(w,(XEvent *)NULL);
  XlLayoutLostFocus(XtParent(w), XltextYForCurrentPosition(xnw));
  LayoutFocusIn(XtParent(w));
}
