/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME:         aimstredit.h
 *
 * SCCSINFO:            @(#)aimstredit.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"nnquist, 1990-08-31
 *
 * DESCRIPTION:
 *	Contains the additional declarations used by the structure
 *	editing operations.
 *
 * MODIFICATIONS:
 *	<list mod's with name and date>
 *
 */
#ifndef AIMSTREDIT_H
#define AIMSTREDIT_H

/* Ensure that 'identry' is known, otherwise include aimtypes.h */
#ifndef identry
#include "aimtypes.h"
#endif

/*
 * The (Cursorstep) type enumerates the implemented relative movements
 * for cursors:
 *	GODOWN	  = to first of subnodes of present
 *	GONEXT	  = to sibling of present
 *	GOFORWARD = to subsequent identry at level of present
 *	GOUP	  = to parent of present.
 */

typedef enum {GODOWN,GONEXT,GOFORWARD,GOUP} Cursorstep;


/* The (cursor) Type.
 *
 * The type (cursor) is a sequence of records, each holding an identry
 * pointer 'ptr' and a position count 'pos'. A cursor points out the
 * chain of identries to follow to a cursored point in a reference
 * structure, using the position counts for infonode indexing. The
 * cursor sequence is in reverse, so the root cursor record is at the
 * end.
 */
typedef struct aim_cursor {
  struct aim_cursor *next;
  struct x_identry *ptr;
  int pos;
} *cursor;


/* The (cursor_list) Type.
 *
 * The type (cursor_list) is a singly-linked list of cursors.
 */
typedef struct aim_cursor_list {
  struct aim_cursor_list *next;
  int priority;
  cursor c;
} *cursor_list;


/*
 * Mode flags for cut_region(...)
 *   'high'   means to reset beginning point to parent while present
 *	      beginning point is its parent's first child (repetetively).
 *   'after'  means to begin the cut region sub-sequent to the given
 *	      beginning point.
 *   'remove' means to remove the cut region after having copied it to
 *	      the cut buffer.
 */
#define CUT_HIGH_MASK	(0x1)
#define CUT_AFTER_MASK	(0x2)
#define CUT_REMOVE_MASK	(0x4)

/* The (cut_item) Type.
 *
 * The type (cut_item) is a record representing one unit of
 * information as saved by a cut operation.
 */
 
typedef struct aim_cut_item {
  struct aim_cut_item *next, *prev;
  struct aim_cut_item *ancestor;
  int index;
  label obj;
  char *group;
  char *field;
  int pos;
  attrval val;
  label lbl;
  int visible;
  int removed;
} *cut_item;

typedef struct aim_cut_buffer {
  struct aim_cut_buffer *next;
  cut_item head;
  cut_item tail;
  int removed;
} *cut_buffer;

#endif /* AIMSTREDIT_H */
