/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	aimstredit.c
 *
 * SCCSINFO:		@(#)aimstredit.c	1.10 6/6/94
 *
 * ORIGINAL AUTHOR(S):  1992-08-29, Ralph R\"onnquist
 *
 * DESCRIPTION:
 *	Structure editing code.
 *
 * MODIFICATIONS:
 *      1993-11-02 Martin Sjlin - whichref is moved to aimsubr.c and 
 *                 changed external section accordingly.
 *	<list mods with name and date>
 *
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#ifdef NEED_X11_XAW_TEXT_H
#include <X11/Xaw/Text.h>
#endif /* NEED_X11_XAW_TEXT_H */
#include <X11/Xaw/List.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include "aimtypes.h"
#include "aimstredit.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_aimstredit.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_aimsubr.h"
#include "f_aimcursor.h"
#include "f_aimcutbuf.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern infonode *currentinfonode;		/* aimstart.c */
extern infonode *previousinfonode;		/* aimstruct.c */
extern Widget toplevel;				/* xstuff.c */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#if (XtSpecificationRelease < 5) && !defined(X11_XAW_NO_DEFINE)
/* This causes a recursive macro under IRIX (x11r4) */
#  define XawChainLeft XtChainLeft
#  define XawChainRight XtChainRight
#  define XawChainTop XtChainBottom
#  define XawChainBottom XtChainTop
#endif

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
static struct {
  Widget shell;
  Widget form;
  Widget closew;
  Widget list;
  Widget copyw;
  Widget cutw;
  Widget afterw;
  Widget beforew;
  Widget popw;
} menu = { (Widget)NULL, (Widget)NULL, (Widget)NULL, (Widget)NULL,
	   (Widget)NULL, (Widget)NULL, (Widget)NULL, (Widget)NULL,
	   (Widget)NULL};

static struct {
  char *text;
  int mode;
  } paste_modes[] = {
  {"Paste: share none, copy detailed", 2},
  {"Paste: share none, copy whole objects", 6},
  {"Paste: share leafs, copy detailed", 0},
  {"Paste: share leafs, copy whole objects", 4},
  {"Paste: share all, copy detailed", 8},
  {"Paste: share all, copy whole objects", 12}
};
static int paste_variant = 2;

static char *points[] =
{
  "[current  = ?]",
  "[previous = ?]",
  "Paste: share leafs, copy detailed",
  NULL
};

/*********************************************************************
 * INTERNAL (STATIC) FUNCTIONS:
 *********************************************************************/
static void close_button P_(( Widget w, caddr_t client_data, caddr_t
                               call_data ));
static void copy_button P_(( Widget w, caddr_t client_data, caddr_t
                              call_data ));
static void list_action P_(( Widget w, caddr_t client_data, caddr_t
                              call_data ));
static void paste_button P_(( Widget w, caddr_t client_data, caddr_t
                               call_data ));

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void list_action(CALLBACK PROTOCOL)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void list_action(w, client_data, call_data)
  Widget w;
  caddr_t client_data;
  caddr_t call_data;
{
  XawListReturnStruct *p = (XawListReturnStruct *)call_data;

  if (p->list_index == 2) {
    if (paste_variant++ >= 5)
      paste_variant = 0;
    points[2] = paste_modes[paste_variant].text;
    XawListChange(menu.list, points, 0, 0, True);
    return;
  }
  XawListUnhighlight(menu.list);
}

/* ^L */
/* ARGSUSED */
/**********************************************************************
 * Function: static void copy_button(CALLBACK PROTOCOL)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void copy_button(w, client_data, call_data)
  Widget w;
  caddr_t client_data;
  caddr_t call_data;
{
  reference_structure *ref = (reference_structure *) NULL;
  long cut = (long)client_data;

  if (!(ref = whichref(currentinfonode, (identry *)NULL, 0)) ||
      (ref != whichref(previousinfonode, (identry *)NULL, 0))) {
    (void)printf("Please mark two items within same view first.\n");
    return;
  }

  (void)printf("%sing region.\n",((cut)? "Cutt": "Copy"));
  copy_region(previousinfonode,currentinfonode,(int)cut);
}

/* ^L */
/* ARGSUSED */
/**********************************************************************
 * Function: static void paste_button(CALLBACK PROTOCOL)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void paste_button(w, client_data, call_data)
  Widget w;
  caddr_t client_data;
  caddr_t call_data;
{
  long after = (long)client_data;

  if (!currentinfonode) {
    (void)printf("Please mark an insertion point first.\n");
    return;
  }
  if (!(paste(currentinfonode,(paste_modes[paste_variant].mode|(int)after))))
    XBell(XtDisplay(w), 50);
}

/* ^L */
/* ARGSUSED */
/**********************************************************************
 * Function: static void close_button(CALLBACK PROTOCOL)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void close_button(w, client_data, call_data)
  Widget w;
  caddr_t client_data;
  caddr_t call_data;
{
  XtPopdown(menu.shell);
}

/*  */
/**********************************************************************
 * Function: void SHOWPOINTS()
 *
 * Modifications:
 *      <list mods with name and date>
 */
void SHOWPOINTS()
{
  static char curbuf[500];
  static char prebuf[500];
  cursor c;

  if ((currentinfonode == (infonode *) NULL) ||
      ((c = targetcursor(currentinfonode)) == (cursor) NULL)) {
    (void)strcpy(curbuf, "[current  = ?]");
  } else {
    (void)strcpy(curbuf, "[current  = ");
    (void)sprintfcursor(curbuf + 12, c, 500);
    (void)strcat(curbuf, " ]");
    (void)freecursor(c);
  }
  if ((previousinfonode == (infonode *) NULL) ||
      ((c = targetcursor(previousinfonode)) == (cursor) NULL)) {
    (void)strcpy(prebuf, "[previous  = ?]");
  } else {
    (void)strcpy(prebuf, "[previous = ");
    (void)sprintfcursor(prebuf + 12, c, 500);
    (void)strcat(prebuf, " ]");
    (void)freecursor(c);
  }

  points[0] = curbuf;
  points[1] = prebuf;
  if (menu.list == (Widget) NULL)
    return;
  XawListChange(menu.list, points, 0, 0, True);
}

/*  */
/* ARGSUSED */
/*********************************************************************
 * Function: void streditcmd(CALLBACK PROTOCOL)
 *
 * Modification:
 *	<list mod's with name and date>
 */
void streditcmd(w, client_data, call_data)
  Widget w;
  caddr_t client_data;
  caddr_t call_data;
{
  SHOWPOINTS();

  if (menu.shell == (Widget) NULL) {
    menu.shell = XtVaCreatePopupShell
      ("structedit", applicationShellWidgetClass, toplevel,
       XtNtitle, "Structure Editing",
       XtNallowShellResize, True,
       NULL);
    menu.form = XtVaCreateManagedWidget
      ("streditform", formWidgetClass, menu.shell,
       NULL);
    menu.closew = XtVaCreateManagedWidget
      ("close", commandWidgetClass, menu.form,
       XtNlabel, "Close This Window",
       XtNtop, XawChainTop,
       XtNbottom, XawChainTop,
       NULL);
    menu.list = XtVaCreateManagedWidget
      ("list", listWidgetClass, menu.form,
       XtNlist, points,
       XtNdefaultColumns, 1,
       XtNforceColumns, TRUE,
       XtNresizable, True,
       XtNfromVert, menu.closew,
       XtNleft, XawChainLeft,
       XtNright, XawChainRight,
       XtNtop, XawChainTop,
       XtNbottom, XawChainTop,
       NULL);
    menu.copyw = XtVaCreateManagedWidget
      ("copy", commandWidgetClass, menu.form,
       XtNlabel, "Copy Region",
       XtNfromVert, menu.list,
       XtNleft, XawChainLeft,
       XtNright, XawChainLeft,
       XtNtop, XawChainTop,
       XtNbottom, XawChainTop,
       NULL);
    menu.cutw = XtVaCreateManagedWidget
      ("cut", commandWidgetClass, menu.form,
       XtNlabel, "Cut Region",
       XtNfromVert, menu.list,
       XtNfromHoriz, menu.copyw,
       XtNleft, XawChainLeft,
       XtNright, XawChainLeft,
       XtNtop, XawChainTop,
       XtNbottom, XawChainTop,
       NULL);
    menu.afterw = XtVaCreateManagedWidget
      ("pastebefore", commandWidgetClass, menu.form,
       XtNlabel, "Paste Before",
       XtNfromVert, menu.copyw,
       XtNleft, XawChainLeft,
       XtNright, XawChainLeft,
       XtNtop, XawChainTop,
       XtNbottom, XawChainTop,
       NULL);
    menu.beforew = XtVaCreateManagedWidget
      ("pasteafter", commandWidgetClass, menu.form,
       XtNlabel, "Paste After",
       XtNfromVert, menu.copyw,
       XtNfromHoriz, menu.afterw,
       XtNleft, XawChainLeft,
       XtNright, XawChainLeft,
       XtNtop, XawChainTop,
       XtNbottom, XawChainTop,
       NULL);

    XtAddCallback(menu.closew, XtNcallback, (XtCallbackProc)close_button,
		  (caddr_t)0L);
    XtAddCallback(menu.copyw, XtNcallback, (XtCallbackProc)copy_button, 
		  (caddr_t)0L);
    XtAddCallback(menu.cutw, XtNcallback, (XtCallbackProc)copy_button, 
		  (caddr_t)1L);
    XtAddCallback(menu.afterw, XtNcallback, (XtCallbackProc)paste_button, 
		  (caddr_t)0L);
    XtAddCallback(menu.beforew, XtNcallback, (XtCallbackProc)paste_button, 
		  (caddr_t)1L);
    XtAddCallback(menu.list, XtNcallback, (XtCallbackProc)list_action, 
		  (caddr_t)0L);
  }
  XtPopup(menu.shell, XtGrabNone);
}
