/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:         sunlincks.h
 *
 * SCCSINFO:		@(#)sunlincks.h	1.5 6/1/94
 *
 * ORIGINAL AUTHOR(S):  Lin Padgham, Ralph R|nnquist, Peter ]berg, 1987-09-18
 *
 * MODIFICATIONS:
 *	< add modifications with name and date >
 *
 * DESCRIPTION:
 * This file contains include definitions primarily for internal liblincks use
 */


#ifndef SUNLINCKS_H
#define SUNLINCKS_H

#include "machine.h"

#include "liblincks.h"

/* Generic LISP structure definition */

typedef struct cell_struct {
        char *tag;
        struct cell_struct *next;
        void *value;
} cell;


/* Attribute data structure definitions */

typedef struct attribute_struct {       /* cell */
	char *tag;
	struct attribute_struct *next;
        char *value;
	int size;
} attribute;

typedef struct attrgroup_struct {       /* cell */
	char *tag;
	struct attrgroup_struct *next;
        attribute *value;
} attrgroup ;


/* Link data structure definitions */

typedef struct linkitem_struct {
	struct linkitem_struct *next_item;
        label link;
} linkitem;

typedef struct linktag_struct {         /* cell */
	char *tag;
	struct linktag_struct *next;
        linkitem *value;
} linktag;

typedef struct linkgroup_struct {       /* cell */
	char *tag;
	struct linkgroup_struct *next;
        linktag *value;
} linkgroup;


/* Image data structure definitions */

typedef struct {
	int size;
	char *value;
} image_desc;


/* Molecule data structure definitions */

typedef struct {
	attrgroup *attributes;	/* Attribute section		*/
	linkgroup *links;	/* Link section			*/
	image_desc *image;	/* Image section.		*/
	int ITix;		/* Interface Table index.	*/
	unsigned inWS:1;	/* In Work Space flag.		*/
	unsigned edited:1;	/* Set for new molecules.	*/
				/* TRUE => it is OK to edit this molecule */
				/* without creating a new version. */
				/* (???? Perhaps a better name for the */
				/* field would be "editable" or "edit_OK").*/
	unsigned mark:1;        /* For VS resolve               */
} molecule;


/* Mapping clauses for mapping through structures */

/* WARNING! Lower-case macros! */
#define mapitems(it,tp)	    for (it=tp->value; it; it=it->next_item)
#define mapfields(it,gp)    for (it=gp->value; it; it=it->next)
#define mapgroups(it,start) for (it=start; it; it=it->next)


#define MAXTAGLENGTH	65535
#define NODBRETRIES	2

/* Thomas Hall:  used by the command history */
#define DB_OPERATION	0
#define WS_OPERATION	1
#define AN_OPERATION	2

/* Function headers */
#include "f_dbcomm.h"
#include "f_rdwrmol.h"
#include "f_structsupport.h"

#endif /* SUNLINCKS_H */
