/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	machine.h
 *
 * SCCSINFO:		@(#)machine.h	1.4 6/8/94
 *
 * ORIGINAL AUTHOR(S):  Martin Sjlin, 94-03-05
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *      Contains machine depend types shared by ALL LINCKS
 *      software 
 * 
 */
#ifndef MACHINE_H
#define MACHINE_H

#ifndef CONFIG_H		/* protect against multiple inclusion */
#include <sys/types.h>		/* for off_t, pid_t */
#endif /* n CONFIG_H */

typedef int UID;
typedef unsigned char byte;
typedef unsigned char FLAGS;

#ifdef LONG_64_BITS 
#ifdef SEEK_64_BITS
typedef off_t  SEEK;
#else
typedef int    SEEK;
#endif
#else
typedef off_t  SEEK;
#endif

typedef time_t TIME;
typedef off_t  SIZE;

/* network stuff */
#ifdef LONG_64_BITS
typedef          short t_16bits;		/* first the signed types */
typedef          int   t_32bits;
typedef          long  t_64bits;
typedef unsigned short t_u16bits;
typedef unsigned int   t_u32bits;
typedef unsigned long  t_u64bits;
#else
typedef          short t_16bits;
typedef          long  t_32bits;
typedef unsigned short t_u16bits;
typedef unsigned long  t_u32bits;
/*
#ifdef HAVE_LONG_LONG
typedef          long long t_64bits;
typedef unsigned long long t_u64bits;
#endif HAVE_LONG_LONG */
#endif /* n LONG_64_BITS */

/* is the server running with "big" labels ...  */
#if defined(LABEL_64_BITS) && (defined(HAVE_LONG_LONG) || defined(LONG_64_BITS))
typedef t_64bits  LABEL;
#else
typedef t_32bits  LABEL;
#endif /* n LABEL_64_BITS */

/* and define size of label between dbs-ws. Notice that it */
/* MUST be that sizeof(WS_LABEL) == LABELSIZE (in dbserver.h) */
typedef t_32bits WS_LABEL ;

#endif /* MACHINE_H */



