/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	libshared.h
 *
 * SCCSINFO:		@(#)libshared.h	1.4 6/1/94
 *
 * ORIGINAL AUTHOR(S):  David Partain, 1993-06-16
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 * External declarations of stuff exported by libshared.  should be
 * included in anything using libshared.
 */

#ifndef LIBSHARED_H
#define LIBSHARED_H

#include "machine.h"

/* Link data structure definitions */
#ifndef LINKGROUP_DEFINED	/* defined in dbserver.h. duplicated here.*/

/* Linkitem */
typedef struct linkitem_struct {
  LABEL label;
  LABEL vs;
  struct linkitem_struct *nextitem;
} LINKITEM;

/* Links */
typedef struct links_struct {
  char *tag;
  LINKITEM *linkitem;
  struct links_struct *nextlinks;
} LINKS;

/* Linkgroup */
typedef struct linkgroup_struct {
  char *name;
  LINKS *links;
  struct linkgroup_struct *nextgroup;
} LINKGROUP;

#define LINKGROUP_DEFINED
#endif /* LINKGROUP_DEFINED */

/* function prototypes */
#include "f_links.h"
#include "f_logging.h"
#include "f_misc.h"
#include "f_xconfig.h"

#endif /* LIBSHARED_H */
