/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:         liblincks.h
 *
 * SCCSINFO:            @(#)liblincks.h	1.8 6/1/94
 *
 * ORIGINAL AUTHOR(S):  Paul Svensson, 1988-11-23
 *
 * MODIFICATIONS:
 *	< add modifications with name and date >
 *
 * DESCRIPTION:
 * Declarations for use by applications that use the liblincks library.
 */

#ifndef LIBLINCKS_H
#define LIBLINCKS_H

typedef int errcode;
#define ERR_RCERROR	(-6)	/* DB: Error info sent              */
#define ERR_RCUUP	(-5)	/* DB: Unable to unpack molecule    */
#define ERR_RCBAD	(-4)	/* DB: Bad operation                */
#define ERR_ALREADY	(-3)	/* DB: Already received             */
#define ERR_STATUS	(-2)	/* DB: Unknown status returned      */
#define ERR_NODB	(-1)	/* Data base not connected	    */
#define NO_ERROR	  0	/* Normal return 		    */
#define ERR_LABEL	  1	/* Invalid label		    */
#define ERR_GROUP	  2	/* No such group		    */
#define ERR_TAG		  3	/* Too long tag			    */
#define ERR_FIELD	  4	/* No such field		    */
#define ERR_POS		  5	/* No such link item		    */
#define ERR_LOGIN	  6     /* Incorrect password or user       */
#define ERR_LASTLATEST	  7     /* Last item in latest              */
#define ERR_TH_LINK	  8	/* No TH_TRANSIENT last place link to node */
#define ERR_DOUBLE_EDITING 9	/* two transient versions created */
#define ERR_AMBIGUOUS 	  10	/* binding of unbound label ambiguous */
#define ERR_VERSION      (11)
                                /* Resolve error code number */
#define ERR_RESOLVE       12    /* see dbserver.h ER_RESOLVE  */
#define ERR_PARAMS	  13	/* invalid parameters, likely null */

/* also in sunlincks.h, change both if you change here */
/* reserved group and field tags */
#define BTBL_GPD        "COMPOSITION","Gpd"
#define BTBL_LINK       "SYSTEM","Binding_Tables"
#define BTBL_PARTS      "COMPOSITION","Components"
#define BTBL_ROOT       "COMPOSITION","Root"
#define BUFFERNODE      "BUFFERNODE"
#define SYSTEM_CHAIN    "SYSTEM","Chain"
#define SYSTEM_COMMAND  "SYSTEM","Command"
#define SYSTEM_CREATED  "SYSTEM","Created"
#define SYSTEM_FORMER   "SYSTEM","Former_Latest"
#define SYSTEM_LATEST   "SYSTEM","Latest"
#define SYSTEM_OWNER    "SYSTEM","Owner"
#define SYSTEM_PARENT   "SYSTEM","Parent"
#define TH_TRANSIENT    "TH_TRANSIENT"
#define VSNET           "VSNET"
#define VSNET_COUNT     "VSNET","Count"

/* GVS Protocol constants */
#define GVS_MORE	-1
#define GVS_INIT	0
#define GVS_VERSION	1
#define GVS_COMMAND	2
#define GVS_PREDECESSOR	3
#define GVS_CONTINUE	0
#define GVS_STOP	-1
#define GVS_NEXT	1

/* RCB constants (usfuns.c/dbcomm.c:LL_registercallback) */
#define RCB_PEN         0
#define RCB_PEN_RESOLVE 1
#define RCB_PEN_CHECK   2
#define RCB_PEN_POLL    3
#define RCB_PEN_NOPOLL 256	
#define RCB_EDIT       128
#define RCB_STORE      129
#define RCB_RETRIEVE   130
#define RCB_RELEASE    140

typedef int boolean;
#ifndef FALSE				/* protect these */
#define FALSE	0
#endif
#ifndef TRUE
#define TRUE	1
#endif

#ifndef SUCCESS
#define SUCCESS   0
#endif
#ifndef FAIL
#define FAIL    (-1)
#endif

typedef struct {
    int vs;		/* Version structure molecule index	*/
    			/* Identifier for a set of versions of a node. */
#define VS_SYS_ROOT	0	/* System root node. */

    int inst;		/* Instance molecule index		*/
			/* Identifier for a particular version of a node,
			 * or indicator for unbound reference. */
#define INST_UNBOUND	(-1)	/* Unbound link (old term: "free reference").*/
} label;

/*
 *	This record is for communicating attribute or image values
 *	with an application program.
 */
/*
 * NOTE: The following is also in sunlincks.h.
 * If you change this, also change sunlincks.h.
 */
typedef struct {
    int attsize;
    char *attvalue;
} attrval;

/* Pen message data structure definitions */
typedef struct penmsg {
  int index;			/* Index to object  */
  int type;			/* Message type     */
  char *msg;			/* Message          */
} PEN_MESSAGE;

#include "f_logws.h"
#include "f_usfuns.h"

#endif /* LIBLINCKS_H */
