/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	dbserver.h
 *
 * SCCSINFO:		@(#)dbserver.h	1.4 6/1/94
 *
 * ORIGINAL AUTHOR(S):  ???, 18 Feb, 1987
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains all include definitions common to the different
 *	files of the database server program
 */

#ifndef DBSERVER_H
#define DBSERVER_H

#include "machine.h"

/* Link data structure definitions */
#ifndef LINKGROUP_DEFINED	/* also in libshared.h */

/* Linkitem */
typedef struct linkitem_struct {
  LABEL label;
  LABEL vs;
  struct linkitem_struct *nextitem;
} LINKITEM;

/* Links */
typedef struct links_struct {
  char *tag;
  LINKITEM *linkitem;
  struct links_struct *nextlinks;
} LINKS;

/* Linkgroup */
typedef struct linkgroup_struct {
  char *name;
  LINKS *links;
  struct linkgroup_struct *nextgroup;
} LINKGROUP;
#define LINKGROUP_DEFINED
#endif /* LINKGROUP_DEFINED */

/* Molecule data structure definition */

/* Buffer field */
typedef struct {
  char *buff;
  int size;
  int curp;
} PACKEDBUFF;

/* Molecule */
typedef struct {
  LINKGROUP *flinks, *blinks;
  PACKEDBUFF *attributes;
  PACKEDBUFF *image;
} MOLECULE;

/* File Table data structure definition */

/* File block */
typedef struct {
  char *fname;
  int fd;
} FILEBLOCK;

/* Table entry */
typedef struct {
  FILEBLOCK molfile, datfile;
  FLAGS useflags;
} TABENTRY;

/* File table flags (only used in molfile.c) */
#define USED 1
#define ALIVE 2

/* Interface table data structure definition */

/* Interface table entry */
typedef struct {
  LABEL label;
  int checknumber;
} IT_ENTRY;

/* Interface table constant definitions (all prefixed with IT_ ) */
#define IT_DELETED        -1
#define IT_NOT_SENT        0
#define IT_NOT_FOUND      -2
#define IT_NO_SPACE       -2
#define IT_NO_LABEL       -2
#define NULLABEL          -1

/* Interface table system molecule definitions */
#define IT_SYSTEM_MOLECULE_POSITION    0
#define IT_SYSTEM_MOLECULE_LABEL     256

/* message queue */
typedef struct msgqueue {
  void *elementp;
  struct msgqueue *nextp;
  short int counter;
} Queue;

/* Error code definitions */

/* Codes */
#ifndef MONITOR_ERRORS_DEFINED
#define MONITOR_ERRORS_DEFINED
#define ER_ILLEGAL_INDEX 1
#define ER_MALLOC 2
#define ER_REALLOC 3
#define ER_FLOCK 4
#define ER_LSEEK 5
#define ER_WRITE 6
#define ER_READ 7
#define ER_OPEN 8
#define ER_DATFILE_FMT 9
#define ER_MOLFILE_FMT 10
#define ER_IT_NO_SPACE 11
#define ER_RESOLVE 12
#define ER_INIT 13
#define ER_UNPACKERR 14
#define ER_NOENTRY NOENTRY+ER_OFFSET
#define ER_LOCKED LOCKED+ER_OFFSET
#define ER_DELETED DELETED+ER_OFFSET
#define ER_NOREADPERM NOREADPERM+ER_OFFSET
#define ER_NOWRITEPERM NOWRITEPERM+ER_OFFSET
#define ER_CREATEFAIL CREATEFAIL+ER_OFFSET
#define ER_LOCKFAIL LOCKFAIL+ER_OFFSET
#define ER_SYSERR SYSERR+ER_OFFSET
#endif

/* Error code offset for rpc errors */
#define ER_OFFSET 16

/* Texts */
#define ER_ILLEGAL_INDEX_TEXT \
"SERIOUS: Interface table reference out of bounds"

#define ER_MALLOC_TEXT \
"FATAL: No more memory available for database server"

#define ER_REALLOC_TEXT ER_MALLOC_TEXT

#define ER_FLOCK_TEXT \
"WARNING: Attempt to lock file failed"

#define ER_LSEEK_TEXT \
"WARNING: Attempt to seek file failed"

#define ER_WRITE_TEXT \
"SERIOUS: Write attempt failed"

#define ER_READ_TEXT \
"WARNING: Read attempt failed"

#define ER_OPEN_TEXT \
"SERIOUS: Attempt to open file failed"

#define ER_DATFILE_FMT_TEXT \
"WARNING: Database file format problem"

#define ER_MOLFILE_FMT_TEXT \
"SERIOUS: Molecule file format problem"

#define ER_IT_NO_SPACE_TEXT \
"SERIOUS: Interface table full"

#define ER_RESOLVE_TEXT \
"Checknumber inconsistency, zoot allures!"

#define ER_INIT_TEXT \
"FATAL: Could not complete server initialization"

#define ER_UNPACKERR_TEXT \
"SERIOUS: Could not unpack links/attribute buffer"

#define ER_NOENTRY_TEXT \
"Requested entry does not exist"

#define ER_LOCKED_TEXT \
"Entry is locked by other user"

#define ER_DELETED_TEXT \
"Entry is marked as deleted"

#define ER_NOREADPERM_TEXT \
"Read permission denied"

#define ER_NOWRITEPERM_TEXT \
"Write permission denied"

#define ER_CREATEFAIL_TEXT \
"WARNING: New entry could not be created"

#define ER_LOCKFAIL_TEXT \
"WARNING: Could not set lock on entry"

#define ER_SYSERR_TEXT \
"SERIOUS: LINCKS system error has occured"

#define ER_UNKNOWN_TEXT \
"???: Unknown error"

/* Monitor call status result,  see also monitor.h */
#ifndef MONITOR_STATUS_DEFINED
#define MONITOR_STATUS_DEFINED
#define DELETED      1
#define LOCKED       2
#define NOENTRY      4
#define NOWRITEPERM  8
#define NOREADPERM  16
#define LOCKFAIL    32
#define NOTLOCKED   32
#define CREATEFAIL  64
#define SYSERR     128
#endif

/* Dbs-ws communication protocol definitions */
#define TAGSIZESIZE	(2)
#define LABELSIZE	(4)
#define BLOCKSIZESIZE	(4)

/* dbs termination codes */
#define COMBROKEN  -1
#define COMTIMEOUT -2
#define COMSTREAM  -3
#define INITFAIL   -4

/* Special function return data structure definitions */

/* WriteLinks */
typedef struct {
  int wrsize;
  SEEK wrpos;
} WRITEINFO;

/* used in dbrdmol.c dbwrmol.c packunpack.c */
#define NAMESTRING 0
#define ITEMLABEL 1
#define TERMINATE 2
#define COUNT 3

#endif /* DBSERVER_H */
