/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	config.h
 *
 * SCCSINFO:		@(#)config.h	1.20 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Martin Sjlin, 93-08-05
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 * External declarations of stuff exported by libshared.  should be
 * included in anything using libshared for operating system stuff
 * compability.
 */

#ifndef CONFIG_H
#define CONFIG_H

/* from autoconf manual */
/* AIX requires this to be the first thing in the files ... */
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not __GNUC__ */
#if HAVE_ALLOCA_H
#include <alloca.h>
#else /* not HAVE_ALLOCA_H */
#ifdef _AIX
 #pragma alloca
#else /* not _AIX */
 char *alloca ();
#endif /* not _AIX */
#endif /* not HAVE_ALLOCA_H */
#endif /* not __GNUC__ */

#include <sys/types.h>
#include <sys/param.h>			/* NOFILE etc */
#include <stdio.h>
#ifndef NO_STDLIB_H
#include <stdlib.h>
#endif	/* NO_STDLIB_H */
#include <unistd.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>			/* to get PATH_MAX */
#endif

/* for use in function prototypes */
#ifdef __STDC__
#define P_(x) x
#else	/* __STDC__ */
#define P_(x) ( )
#endif	/* __STDC__ */

/* we need to use Wide prototype when compiling under ANSI */
#if (__STDC__ == 0) || (__STDC__ == 1)
#ifndef NeedWidePrototypes
#define NeedWidePrototypes 1
#endif /* n NeedWidePrototypes */
#endif /* (__STDC__ == 0) || (__STDC__ == 1) */

#if NeedWidePrototypes
#define XtBoolean	int
#define XtDimension	unsigned int
#define XtKeyCode	unsigned int
#define XtPosition	int
#define XtXtEnum	unsigned int
#else
#define XtBoolean	Boolean
#define XtDimension	Dimension
#define XtKeyCode	KeyCode
#define XtPosition	Position
#define XtXtEnum	XtEnum
#endif /* NeedWidePrototypes */

/* aimdbdump.c, dbdump.c */
#define PARSERINBUFLIMIT 5000   /* <= parser.c: INBUFLIMIT */

/* dbcomm.c, mkpasswd.c */
#define PASSWD_LENGTH 64	/* how long the password might be */
#define PASSWD_FORMAT    "%s%d%s"
#define PASSWD_FORMAT_PR "%s %d %s\n"

#define INDEXLOCK ".indexfile.lock"

#ifndef inline
#define inline
#endif	/* inline */

#ifdef __STDC__
#define FREEPTR void
#else
#define FREEPTR char
#endif	/* __STDC__ */

#define IOSIZE_T  size_t  /* type of size parameter to write,read,lseek */

#ifndef size_t
#define ALLOC_T size_t	  /* type of size parameter to malloc and friends */
#else
#define ALLOC_T unsigned
#endif /* size_t */

/* on BSD system these are found in sys/param */
#ifndef MAXPATHLEN
#ifdef PATH_MAX
#define MAXPATHLEN PATH_MAX
#else
#define MAXPATHLEN 512
#endif /* PATH_MAX */
#endif /* MAXPATHLEN */

#if !defined(HAVE_CONST) && !defined(__STDC__) && !defined(const)
#define const
#endif

#ifdef STRDUP_NOCONST
#define STRDUP_CONST 
#else
#define STRDUP_CONST const
#endif

#ifdef CALLRPC_NOCONST
#define CALLRPC_CONST 
#else
#define CALLRPC_CONST const
#endif

#ifdef HAVE_BSD_WAIT
#define WAIT_T union wait
#else
#define WAIT_T int
#endif

#ifdef READ_UNSIGNED
#define READ_SIZE_T unsigned int
#else
#define READ_SIZE_T size_t
#endif 

#ifdef WRITE_UNSIGNED
#define WRITE_SIZE_T unsigned int
#else
#define WRITE_SIZE_T size_t
#endif 

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif /* RETSIGTYPE */

#include <signal.h>

#if !defined(SIG_ERR) && defined(SIG_DFL) /* 4.3BSD Reno */
#if defined(BADSIG)		/* just in case we run into a funny system  */
#define SIG_ERR BADSIG		/* this should work in all cases */
#else
#define SIG_ERR ((RETSIGTYPE (*)())-1)  /* was ((RETSIGTYPE *) -1) */
#endif /* !BADSIG */
#endif /* !SIG_ERR && SIG_DFL */
#if !defined(BADSIG) && defined(SIG_ERR) 
#define BADSIG SIG_ERR
#endif /* n BADSIG && SIG_ERR */

#ifndef L_SET
#define L_SET           SEEK_SET
#endif /* L_SET */

#ifndef L_INCR
#define L_INCR          SEEK_CUR
#endif /* L_INCR */

#ifndef L_XTND
#define L_XTND          SEEK_END
#endif /* L_XTND */

#if defined(HAVE_F_SETOWN) || !defined(HAVE_FLOCK) || defined(NO_FIONREAD_PIPE)
#include <fcntl.h>
#endif

#ifndef HAVE_FLOCK
extern int LockReg( /* int fd, int cmd, int type, off_t offset, 
                       int where, off_t len */ );
#define read_lock( fd, off, where, len) \
  LockReg( fd, F_SETLK, F_RDLCK, off, where, len)
#define readw_lock( fd, off, where, len) \
  LockReg( fd, F_SETLKW, F_RDLCK, off, where, len)
#define write_lock( fd, off, where, len) \
  LockReg( fd, F_SETLK, F_WRLCK, off, where, len)  
#define writew_lock( fd, off, where, len) \
  LockReg( fd, F_SETLKW, F_WRLCK, off, where, len)  
#define un_lock( fd, off, where, len) \
  LockReg( fd, F_SETLK, F_UNLCK, off, where, len)
#endif /* n HAVE_FLOCK */

#ifndef HAVE_USLEEP
#include <sys/time.h>
#include <stddef.h>
#endif	/* n HAVE_USLEEP */

/* include files for getting allocation/free'ing prototypes */
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#else
#ifdef NO_STDLIB_H
extern char *malloc();
extern void free();
#endif /* n NO_STDLIB_H */
#endif /* n HAVE_MALLOC_H */

/* string and memory functions */
#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
#include <string.h>
/* An ANSI string.h and a pre-ansi memory might conflict. */
#if !defined(STDC_HEADERS) && defined(HAVE_MEMORY_H)
#include <memory.h>
#endif /* n STDC_HEADERS && HAVE_MEMORY_H */
#else
#include <strings.h>
#endif /* n STDC_HEADERS && n HAVE_STRING_H */

#ifdef HAVE_MACHINE_ENDIAN_H
#include <machine/endian.h>
#endif	/* HAVE_MACHINE_ENDIAN_H */

#ifdef HAVE_SYS_BYTEORDER_H
#include <sys/byteorder.h>
#endif /* HAVE_SYS_BYTEORDER_H */

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif	/* HAVE_SYS_SELECT_H */

#ifdef HAVE_TERMIOS
#include <termios.h>
#else
#ifdef HAVE_BSD_SGTTY_H
#include <bsd/sgtty.h>
#else
#include <sgtty.h>
#endif /* n HAVE_BSD_SGTTY_H */
#endif	/* n HAVE_TERMIOS */

#ifndef HAVE_GETDTABLESIZE
#include <sys/resource.h>	/*  for getrlimit() */
#endif	/* n HAVE_GETDTABLESIZE */

#ifdef HAVE_RPC_REG
#define registerrpc(a,b,c,d,e,f) (rpc_reg(a,b,c,d,e,f,("datagram_v")))
#endif /* HAVE_RPC_REG */

#ifdef HAVE_RPC_CALL
#define callrpc(a,b,c,d,e,f,g,h) (rpc_call(a,b,c,d,e,f,g,h,("datagram_v")))
#endif /* HAVE_RPC_CALL */

#include "systypes.h"	/* get some more prototypes... */

#endif /* CONFIG_H */
