/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME:         aimtypes.h
 *
 * SCCSINFO:            @(#)aimtypes.h	1.6 5/19/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R|nnquist, 1990-01-30
 *
 * MODIFICATIONS:
 *	1993-12-15, Martin Sjlin:  added #defines for Widget names
 *      1994-05-17, Martin Sjlin:  added _textdump for aimexport.c
 *	< add modifications with name and date >
 *
 * DESCRIPTION:
 *
 * Contains declarations used by the Application Interface Manager
 * layer and those that communicate with it.
 *
 */

#ifndef AIMTYPES_H
#define AIMTYPES_H

/* get the definition of label */
#ifndef label
#undef TRUE
#undef FALSE
#include "liblincks.h"
#endif

#include <X11/Intrinsic.h>

/*  */
/**********************************************************************
 * Structure: identry
 * 
 */
typedef struct x_identry {
  struct x_identry *next;	/* Refers to other tags of same infonode */
  struct x_identry *tmpl;	/* Refers to template identry */
  struct x_infonode *value;	/* The value list for the tag */
  struct x_infonode *owner;	/* Refers to tag owner infonode */
  struct {
    unsigned is_recursive:1;	/* Tells that tag is defined "above" */
  } flags;
  char *idname;			/* The tag index (print name) */
} identry;


/*  */
/**********************************************************************
 * Structure: formentry
 *
 * This structure contains the text name/value pair for a formatting
 * attribute stored in the database and used by the UIM in a UIM
 * specific way.
 */
typedef struct x_formentry {
  struct x_formentry *next;	/* Refers to other formats for same infonode */
  char *formid;			/* Format identifier tag */
  char *formval;		/* Format value string */
} formentry;


/*  */
/**********************************************************************
 * Structure: infonode
 * 
 */
typedef struct x_infonode {
  struct x_infonode *next;	/* Refers to siblings of same tag */
  struct x_infonode *parent;	/* Refers to owner of tag */
  identry *head;		/* Refers to tag record */
  identry *subnodes;		/* Refers to children */
  formentry *formats;		/* Refers to overriding formats */

  Widget widp;			/* Refers to widget assoc. w/the infonode */

  label selobj;			/* DB object holding producing sel. phrase */
  int iflg;			/* State flags for the infonode */
/* These define values for 'iflg' masks and values */
#define LEVEL_MSK	(0x0001L)	/* Infonode level mask */
#define ITEMLEVEL	(0x0000L)
#define SUBLEVEL	(0x0001L)
#define NONEXIST_MSK	(0x0002L)	/* Value does not exist in Db. */

  label obj;			/* DB object holding the info */
  int index;			/* Type of DB info piece */
/* possible values for index */
#define INTERNAL	(0)
#define ATTRGROUPTAG	(1)
#define ATTRFIELDTAG	(2)
#define ATTRVALUE	(3)
#define LINKGROUPTAG	(4)
#define LINKFIELDTAG	(5)
#define LINKITEM	(6)
#define IMAGE		(7)
#define SAMEASPARENT	(8)
  char *group;			/* Group tag for info piece */
  char *field;			/* Field tag for info piece */
  int pos;			/* position for LINKITEM infonode */

  label lbl;			/* value field for LINKITEM infonode. */
  attrval val;			/* value field for "textual" values */

  unsigned printed : 1;		/* if infonode's been printed in export */
  unsigned changed : 1;		/* if infonode's contents have changed */

} infonode;

/*  */
/**********************************************************************
 * Structure: propagation_q_element
 * 
 * structure element added to the propagation queue attached to a
 * particular reference structure.  The elements are processed when dealing
 * with widget level propagation.
 *
 */
typedef struct x_propagation_q_element {
  struct x_propagation_q_element *pqe_next;  /* next on the queue */
  struct x_propagation_q_element *pqe_prev;  /* doubly-linked list */
  infonode *pqe_infonode;	/* infonode operation will use */
  Widget pqe_widget;		/* widget operation will use */
#define PQE_OP_MAKEWIDGET 0	/* for the pqe_operation */
#define PQE_OP_CHANGEWIDGET 1
#define PQE_OP_REMOVEWIDGET 2
#define PQE_OP_COMPLETED 3	/* this won't be used at present.  it is */
				/* extensibility if we at some point decide */
				/* that we want to process without removing */
				/* elements on the queue */
  int pqe_operation;		/* which operation this element is for */
				/* must take one of the above #defines */
  formentry *pqe_format;	/* contains a name/value pair associated */
				/* with this particular infonode.  loaded */
				/* at add time */
} propagation_q_element;

/*  */
/**********************************************************************
 * Structure: popd_list
 *
 * list of previous reference structures in a window.
 */
typedef struct _popd_list {
  struct _popd_list *next;
  char *tag;
  int bound;
  label bt;
} popd_list;

/*  */
/**********************************************************************
 * Structure: destroy_list
 *
 * widgets associated with a reference structure which must be destroyed
 * when the window is closed (when the reference structure is lost).
 */
typedef struct _destroy_list {
  struct _destroy_list *next;
  Widget widget;
} destroy_list;

/*  */
/**********************************************************************
 * Structure: reference_structure
 */
typedef struct x_reference_structure {
  struct x_reference_structure *next;/* The next reference struct in list */
  identry *template;		/* The Template Reference Structure */
  identry *target;		/* The Target Reference Structure */
  label root;			/* The Target Object Label */
  label gpd;			/* The General Pres. Desc. Object Label */
  label spd;			/* The Specific Pres. Desc. Obj. Label */
  label bt;			/* The Binding Table object label */

  Widget contw;		/* Container widget for this ref struct. */
  destroy_list *widl;
  popd_list *pdl;

  struct {
    unsigned bound : 1;
    unsigned bound_changed : 1;
  } flags;			/* Status flags */
  struct {
    propagation_q_element *head; /* pointer to head of list */
    propagation_q_element *tail;  /* pointer to tail of list */
  } pqueue;
} reference_structure;

/*  */
/**********************************************************************
 * Structure: textdump
 * 
 */
typedef struct __textdump {
  enum DocStyle {
    article = 0, letter = 1
  } docstyle;
  enum Structure {
    deep, flat
  } structure;
  enum FontSize {
    small = 10, medium = 11, large = 12
  } fontsize;
  char *outfile;
  enum Placeholders {
    yes, no
  } placeholders;
  char *leftmargin;			/* string to match leftmargin */
} _textdump;

typedef enum {  doit, dont  } EscType;
typedef enum {  straight, LaTeX } DumpType;

/*  */
/**********************************************************************
 * Structure: widget_info
 * 
 */
typedef struct {
  infonode *inode;
  reference_structure *ref;
} widget_info;

/*  */
#define BT_NOT_TRANSIENT 20
#define BT_SOME_TRANSIENT 21
#define BT_TRANSIENT 22

/* 
 * These are the defined "kinds" (classes)
 * of which the 'index' values are members.
 */
#define TAGKIND        (0)
#define LINKITEMKIND   (1)
#define LITEMIMAGEKIND (2)

/* 
 * These are the defined values for
 * the edit operation types passed to
 * the propagate routine.
 */
#define CREATEOP        (0)
#define CHANGEOP        (1)
#define REMOVEOP        (2)
#define LINKOP		(3)
#define COPYOP		(4)

/* types for popup_message() */
#define POPUP_MESS_ERROR (0)	/* error message */
#define POPUP_MESS_INFO (1)	/* informational message */
#define POPUP_MESS_HELP (2)	/* a help message */
#define POPUP_MESS_PEN	(3)	/* parallel editing notification message */

/* strings used for window button widget names */
#define WSTOREWINDOW	"StoreWindow"
#define WCLOSEWINDOW	"CloseWindow"
#define WREFETCH	"RefetchWindow"
#define WPROMOTE	"PromoteVersion"
#define WSHOWGPD	"ShowGPD"
#define WSHOWHISTORY	"ShowHistory"
#define WEXPORTWINDOW	"ExportWindow"
#define WDUPLICATE	"DupWindow"
#define WSHOWGPD	"ShowGPD"
#define WSHOWHISTORY	"ShowHistory"
#define WDUMPREFSTR	"DumpRefStr"
#define WSHOWBT		"ShowBT"

/* strings used for command menu button widget names */
#define WEXPAND		"Expand ..."
#define WCUTANDPASTE	"Cut & Paste ..."
#define WITEMHISTORY	"Item History ..."
#define WUSERROOT	"User Root ..."
#define WHELPWINDOW	"Help Window ..."
#define WADDLINK	"Add Link"
#define WDBDUMP		"DBDump"
#define WSTOREALL	"Store All"
#define WCLOSEALL	"Close All"
#define WCLOSEAUX	"CloseAuxWins"
#define WLOGOUT		"Logout"

/* these are only needed if -DEXPERIMENT is included */
#define WCOMPARE	"Compare"
#ifdef EXPERIMENT
#define WPROPAGATE	"Propagate"
#define WCOMHIST	"Command History"
#endif	/* EXPERIMENT */

#endif /* AIMTYPES_H */
