/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	labelinfo.c
 *
 * SCCSINFO:		@(#)labelinfo.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  PEN pum group, 1992-05-18
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *
 * This file contains definitions for the functions which
 * manipulate the labelinfo structure.
 *
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_labelinfo.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_monerrors.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: LabelInfo *CreateLabelInfo()
 * 
 * Creates a head for a list of labels.
 *
 * Modifications:
 *      <list mods with name and date>
 */
LabelInfo *CreateLabelInfo()
{
    LabelInfo *labelinfop;
    
    if ((labelinfop = (LabelInfo *) malloc(sizeof(LabelInfo))) == NULL) {
	Error(ER_MALLOC, "CreateLabelInfo:");
	return(NULL);
    }
    labelinfop->infop = NULL;
    labelinfop->nextp = NULL;
    return(labelinfop);
}


/*  */
/**********************************************************************
 * Function: void *RetrieveInfo(LabelInfo *labelinfop, LABEL label)
 * 
 * Find info for a label
 *
 * Modifications:
 *      <list mods with name and date>
 */
void *RetrieveInfo(labelinfop, label)
    LabelInfo *labelinfop;
    LABEL label;
{
    while (labelinfop->nextp) {
	if (labelinfop->nextp->label == label) 
	    return(labelinfop->nextp->infop);
	labelinfop = labelinfop->nextp;
    }
    return(NULL);
}

/*  */
/**********************************************************************
 * Function: void SetInfo(LabelInfo *labelinfop, LABEL label, void *infop)
 *
 * Associates information with a label
 * 
 * Modifications:
 *      <list mods with name and date>
 */
void SetInfo(labelinfop, label, infop)
    LabelInfo *labelinfop;
    LABEL label;
    void *infop;
{
    LabelInfo *newp, *oldp;

    /* find and change labelinfo in list */
    while (labelinfop->nextp != NULL) {
	if (labelinfop->nextp->label == label) {
	    if (infop != NULL) 
		labelinfop->nextp->infop = infop;
	    else {
		/* remove label if info is NULL */
		oldp = labelinfop->nextp;
		labelinfop->nextp = labelinfop->nextp->nextp;
		free((FREEPTR *)oldp);
	    }
	    return;
	};
	labelinfop = labelinfop->nextp;
    }    

    /* create new labelinfo if no label was found */
    if ((newp = CreateLabelInfo()) == NULL) 
	return;
    newp->label = label;
    newp->infop = infop;
    labelinfop->nextp = newp;
}
