/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	getentry.c
 *
 * SCCSINFO:		@(#)getentry.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ???,  22 Dec, 1986
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *  This file contains GetEntry, ReadEntry, and Search
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"
#include "lincks.h"
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_getentry.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_monerrors.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: int GetEntry(LABEL label, INDEX table[], int fd)
 * 
 * Finds the index entry corresponding to the label.
 * Searches index table first. Then file.
 * Uses Hash, Search, ReadEntry, and Error
 * Returns FAIL if entry does not exist.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int GetEntry(label, table, fd)
  LABEL label;
  INDEX table[];
  int fd;
{
    int pos, newpos;

    /* Get table position and check that position valid */
    if ((pos = Hash(label)) < 0) {
        Error(ER_HASH, "GetEntry: Illegal hash result");
        return(FAIL);
    }

    /* find entry. Try table first then file. If in file, copy to table */
    if (table[pos].label != label) {
        if ((newpos = Search(label, table, pos)) < 0) {
	    if (table[pos].flags & LOCKED)
              if ((pos = Search((LABEL)0, table, pos)) < 0) {
		  Error(ER_IT_NOSPACE,
                        "getentry: no more space in index table");
		  return(FAIL);
	      }
            if ((ReadEntry(fd, label, &table[pos])) < 0)
	      return(FAIL);
        }
        else pos = newpos;
    }

    /* Return position in table */
    return(pos);
}

/*  */
/**********************************************************************
 * Function: int ReadEntry(int fd, LABEL label, INDEX *entry)
 * 
 * Reads an index entry from the file fd and places it
 * in entry after performing conversion
 * Uses ConvToSeek, ConvToIndex, and Error
 * Returns FAIL for any file format error
 *
 * Modifications:
 *      <list mods with name and date>
 */
int ReadEntry(fd, label, entry)
  int fd;
  LABEL label;
  INDEX *entry;
{
    off_t seekadr, adr;

    /* Convert label to valid seek address */
    if ((adr = ConvToSeek(label)) < 0) {
        Error(ER_SEEKADR, "ReadEntry: Illegal seek address");
        return(FAIL);
    }

    /* Seek to position in file */
    seekadr = lseek(fd, adr, L_SET);
    if (seekadr != adr) {
        Error(ER_LSEEK, "ReadEntry: Unsuccessful seek attempt");
        return(FAIL);
    }

    /* Get file entry */
    if (read(fd, (char *)entry, (IOSIZE_T)INDEXSIZE) != INDEXSIZE) {
        Error(ER_EOF, "ReadEntry: EOF reached unexpectedly");
        return(FAIL);
    }

    /* Return status. Entry returned through entry pointer */
    return(SUCCESS);
}

/*  */
/**********************************************************************
 * Function: int Search(LABEL label, INDEX table[], int pos)
 * 
 * Has two modes. If label is zero it searches from pos
 * to find first unlocked molecule within SEARCHDIST
 * Otherwise it will find a label in the index table within
 * limits of SEARCHDIST. Returns index table position if
 * successful or FAIL if not
 *
 * Modifications:
 *      <list mods with name and date>
 */
int Search(label, table, pos)
  LABEL label;
  INDEX table[];
  int pos;
{
    int i;

    if (label) {
        for (i=0; i<SEARCHDIST; ++i)
	  if (table[++pos].label == label) return(pos);
        return(FAIL);
    }
    else {
        for (i=0; i<SEARCHDIST; ++i)
	  if (!(table[++pos].flags & LOCKED)) return(pos);
        return(FAIL);
    }
}
