#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ncurses/ncurses.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>

#define PAGE_UP   0
#define PAGE_DN   1
#define UPDATE    2
#define SCROLL_UP 3
#define SCROLL_DN 4
#define INPAGE_UP 5
#define INPAGE_DN 6

struct file_pos {
  long position;
  struct file_pos *next;
  struct file_pos *prev;
  unsigned int marked;
  unsigned long lineno;
  char string[128];
};

struct config {
  char store_path[FILENAME_MAX];
};

struct file_pos *line;
int curr_pos, pair;
char filename[FILENAME_MAX];
int statusline,
    screen_width,
    screen_height;
long num_pages,
     last_search;

int get_line( int line );
void status_line( char *string );
void make_screen( int direction );
void add_name( FILE *output );
char *make_name( char *input_name );
void get_config( struct config *config ); 
char *get_magic( WINDOW *old_win, char *put_string );
long do_list( FILE *input );
long search( char *pattern );
void dialog( WINDOW *old_win, char *put_string );


