/*+-------------------------------------------------------------------------
	ttynaming.c - direct/modem tty name management
	wht@n4hgf.Mt-Park.GA.US

For now, meaningful only on SCO.  In the future, perhaps, we'll
manage an installation-dependent table of what line names
refer to the same device and which are modem, direct, etc.
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:08-21-1992-13:39-wht@n4hgf-rewire direct/modem device use */
/*:08-21-1992-04:47-wht@n4hgf-creation */

#include "ecu.h"

/*+-------------------------------------------------------------------------
	direct_tty(tty) - make non-modem line out of SCO ttyname
--------------------------------------------------------------------------*/
#ifdef NEED_TTY_NAME_CONVERSION
char *
direct_tty(tty)
char *tty;
{
	char stat_tty[64];

	register itmp;
	strncpy(stat_tty,tty,sizeof(stat_tty));
	stat_tty[sizeof(stat_tty) - 1] = 0;

	if((itmp = strlen(stat_tty)) > 2)
	{
		itmp--;
		if(
#if 0
			isdigit(stat_tty[itmp - 1]) &&
#endif
			isupper(stat_tty[itmp])
			)
		{
			stat_tty[itmp] = tolower(stat_tty[itmp]);
		}
	}

	return(stat_tty);

}	/* end of direct_tty */
#endif /* NEED_TTY_NAME_CONVERSION */

/*+-------------------------------------------------------------------------
	modem_tty(tty) - make modem line out of SCO ttyname
--------------------------------------------------------------------------*/
#ifdef NEED_TTY_NAME_CONVERSION
char *
modem_tty(tty)
char *tty;
{
	char stat_tty[64];

	register itmp;
	strncpy(stat_tty,tty,sizeof(stat_tty));
	stat_tty[sizeof(stat_tty) - 1] = 0;

	if((itmp = strlen(stat_tty)) > 2)
	{
		itmp--;
		if(
#if 0
			isdigit(stat_tty[itmp - 1]) &&
#endif
			islower(stat_tty[itmp])
			)
		{
			stat_tty[itmp] = toupper(stat_tty[itmp]);
		}
	}

	return(stat_tty);

}	/* end of modem_tty */
#endif /* NEED_TTY_NAME_CONVERSION */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of ttynaming.c */
