/* CHK=0x88E6 */
/*+-------------------------------------------------------------------------
	naptest.c - nap test suite
	wht@n4hgf.Mt-Park.GA.US

This little program is derived from my first nap program from XENIX days.
The M_XENIX code shows how predictable nap() behaves under XENIX 286
and 386.  It assumes HZ is 50.  It surely was nice when UNIX came out
with 100 HZ for 10 msec clock ticks.  60 HZ 16.6666666666666666666667
msec clock ticks are a bit nauseating.
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:06-26-1988-14:05-wht-creation */

#include <stdio.h>
#ifdef M_UNIX
#undef M_XENIX
#endif

#ifndef M_XENIX
#include <sys/param.h>
#endif

main(argc,argv,envp)
int argc;
char	**argv;
char	**envp;
{
	register int itmp;
	long nap(),ms;
	int cnt[8];

	for(itmp = 0; itmp < 8; itmp++)
		cnt[itmp] = 0;

#ifdef M_XENIX
	printf("making 1000 nap(20L) calls\n");
	for(itmp = 0; itmp < 1000; itmp++)
	{
		switch(nap((long)20))
		{
		case 0L:	cnt[0]++; break;
		case 20L:	cnt[1]++; break;
		case 40L:	cnt[2]++; break;
		case 60L:	cnt[3]++; break;
		case 80L:	cnt[4]++; break;
		case 100L:	cnt[5]++; break;
		case 120L:	cnt[6]++; break;
		default:	cnt[7]++; break;
		}
	}
	printf("return value buckets:\n");
	printf("0:%d 20:%d 40:%d 60:%d 80:%d 100:%d 120:%d other:%d\n",
	    cnt[0],cnt[1],cnt[2],cnt[3],cnt[4],cnt[5],cnt[6],cnt[7]);
#else
	printf("making 1000 nap(%ldL) calls\n",(1000 / HZ) + 1);
	for(itmp = 0; itmp < 1000; itmp++)
	{
		switch(ms = nap((long)(1000 / HZ) + 1))
		{
		case 0L:
			cnt[0]++; break;
		case (((1000 / HZ)    )  * 1):
		case (((1000 / HZ) + 1)  * 1):
			cnt[1]++; break;
		case (((1000 / HZ)    )  * 2):
		case (((1000 / HZ) + 1)  * 2):
			cnt[2]++; break;
		case (((1000 / HZ)    )  * 3):
		case (((1000 / HZ) + 1)  * 3):
			cnt[3]++; break;
		case (((1000 / HZ)    )  * 4):
		case (((1000 / HZ) + 1)  * 4):
			cnt[4]++; break;
		case (((1000 / HZ)    )  * 5):
		case (((1000 / HZ) + 1)  * 5):
			cnt[5]++; break;
		case (((1000 / HZ)    )  * 6):
		case (((1000 / HZ) + 1)  * 6):
			cnt[6]++; break;
		default:
			cnt[7]++; break;
		}
	}

	printf("return value buckets:\n");
	for(itmp = 0; itmp < 7; itmp++)
		printf("%d:%d ",(1000/HZ)*itmp,cnt[itmp]);
	printf("other:%d\n",cnt[7]);
#endif
	exit(0);

}	/* end of main */

/* vi: set tabstop=4 shiftwidth=4: */
