/+------------------------------------------------------------------
/ memmove.s
/
/ $Id: memmove.s,v 1.3 1991/06/05 19:15:44 chip Exp $
/
/ Implementation of memmove(), which is inexplicably missing
/ from the SCO Unix C library.
/
/ for profiling version,
/ m4 profile.s memmove.s > memmove_p.s  # order is important!
/ as -o memmove_p.o memmove_p.s
/ 
/ Note also that manually running memmove.s through m4 (instead of
/ using as -m) before assembling will also save 100 or so bytes in
/ the .o file for the non-profiling version.
/ 
/-------------------------------------------------------------------

	.globl	memmove
memmove:
ifdef(`PROFILE',`
	.bss
.L1:	.=.+4
	.text
	mov	$.L1,%edx
	.globl	_mcount
	call	_mcount
')
	push	%edi
	push	%esi
	mov	12(%esp),%edi
	mov	16(%esp),%esi
	mov	20(%esp),%ecx
	mov	%edi,%eax		/ return value: dest
	jcxz	mm_exit

	mov	%edi,%edx
	sub	%esi,%edx
	jb	mm_simple
	cmp	%edx,%ecx
	jb	mm_simple

	add	%ecx,%edi
	dec	%edi
	add	%ecx,%esi
	dec	%esi
	std
	rep; movsb
	cld
	jmp	mm_exit

mm_simple:
	cld
	mov	%ecx,%edx
	shr	$2,%ecx
	rep; movs
	mov	%edx,%ecx
	and	$3,%ecx
	rep; movsb

mm_exit:
	pop	%esi
	pop	%edi
	ret
