/*+----------------------------------------------------------------
	esdutil.c - ecu extended string descriptor manipulation
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	end_of_cmd(tesd)
	esd_null_terminate(tesd)
	esd_strip_trail_break(ztext)
	esdalloc(maxcb)
	esdcat(dest,suffix,realloc_ok)
	esdfgets(tesd,fileptr)
	esdfputs(tesd,fileptr,index_flag,nl_flag)
	esdfree(tesd)
	esdinit(tesd,cptr,maxcb)
	esdrealloc(tesd,maxcb)
	esdshow(tesd,title)
	esdstrcat(tesd,zstr)
	esdstrindex(esd1,esd2,index1_flag,index2_flag)
	esdzero(tesd)
	get_alpha_zstr(tesd,strbuf,strbuf_maxcb)
	get_alphanum_zstr(tesd,strbuf,strbuf_maxcb)
	get_cmd_char(tesd,pchar)
	get_numeric_value(tesd,value)
	get_numeric_zstr(tesd,strbuf,strbuf_maxcb)
	get_switches(tesd,switches,switches_max)
	get_word_zstr(tesd,strbuf,strbuf_maxcb)
	keyword_lookup(ktable,tesd)
	skip_cmd_break(tesd)
	skip_cmd_char(tesd,skipchar)
	skip_colon(tesd)
	skip_comma(tesd)
	skip_paren(tesd,fLeft)
	strindex(str1,str2)

This is old code; give me a break
-----------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:03-20-1992-06:26-wht@n4hgf-esdstrcat will grow an esd */
/*:08-25-1991-23:20-root@n4hgf2-get_switches could overflow result string */
/*:07-25-1991-12:57-wht@n4hgf-ECU release 3.10 */
/*:05-02-1991-04:12-wht@n4hgf-how did esdrealloc ever work? */
/*:04-23-1991-04:33-wht@n4hgf-function name reorganization */
/*:04-23-1991-04:33-wht@n4hgf-add esdcat */
/*:01-31-1991-14:49-wht@n4hgf-rework esdrealloc for speed */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "ecuerror.h"
#include "esd.h"

extern int errno;

/*+-------------------------------------------------------------------------
    esd_null_terminate(&esd)
    puts null at 'cb' position of string (standard esd always
    has one more byte in buffer than maxcb says)
--------------------------------------------------------------------------*/
void
esd_null_terminate(tesd)
register ESD *tesd;
{
	tesd->pb[tesd->cb] = 0;
}   /* end of esd_null_terminate */

/*+-----------------------------------------------------------------------
	esdzero(tesd)  zero an esd 
------------------------------------------------------------------------*/
void
esdzero(tesd)
register ESD *tesd;
{
	tesd->cb = 0;				/* current count == 0 */
	tesd->index = 0;			/* parse index to first position */
	tesd->old_index = 0;		/* parse index to first position */
	*tesd->pb = 0;				/* start with null terminated string */

}	/* end of esdzero */

/*+-----------------------------------------------------------------------
	esdinit(tesd,cptr,maxcb)  init an esd 
------------------------------------------------------------------------*/
void
esdinit(tesd,cptr,maxcb)
register ESD *tesd;
char *cptr;
register maxcb;
{
	tesd->pb = cptr;			/* pointer to string */
	tesd->maxcb = maxcb;		/* max characters in buffer */
	esdzero(tesd);

}	/* end of esdinit */

/*+-----------------------------------------------------------------------
	esdptr = esdalloc(maxcb)	allocate an esd and buffer
------------------------------------------------------------------------*/
ESD *
esdalloc(maxcb)
register maxcb;		/* desired maxcb */
{
register ESD *tesd;
register actual_cb;

	/* we get an extra character to ensure room for null past maxcb */
	actual_cb = maxcb + 1;
	if(actual_cb & 1)		/* even allocation */
		++actual_cb;

	if(!(tesd = (ESD *)malloc(sizeof(ESD))))
		return((ESD *)0); 	/* return NULL if failure */

	if(!(tesd->pb = malloc(actual_cb)))
	{
		free((char *)tesd);
		return((ESD *)0); 	/* return NULL if failure */
	}

	esdinit(tesd,tesd->pb,maxcb);
	return(tesd);

}	/* end of esdalloc */

/*+-----------------------------------------------------------------------
	esdptr = esdrealloc(maxcb)	- realloc an esd buffer

may only be used to enlarge an esd buffer
this used to use realloc(), which did a lot of unnecessary copying
also no more abnormal program termination on memory failure
------------------------------------------------------------------------*/
int
esdrealloc(tesd,maxcb)
ESD *tesd;
register maxcb;		/* desired maxcb */
{
register actual_cb;
char *newpb;

	if(!tesd || (tesd->maxcb > maxcb))
		return(eInternalLogicError);

	/* enforce our limit */
	if(maxcb > ESD_MAXSIZE)
		return(eBufferTooSmall);

	/* we get an extra character to ensure room for null past maxcb */
	actual_cb = maxcb + 1;
	if(actual_cb & 1)		/* even allocation */
		++actual_cb;

	if(!(newpb = malloc(actual_cb)))
		return(eNoMemory);

	if(tesd->cb)
		memcpy(newpb,tesd->pb,tesd->cb);

	free(tesd->pb);
	tesd->pb = newpb;
	tesd->maxcb = actual_cb;
	esd_null_terminate(tesd);
	return(0);

}	/* end of esdrealloc */

/*+-----------------------------------------------------------------------
	esdfree(esdptr)
------------------------------------------------------------------------*/
void
esdfree(tesd)
register ESD *tesd;
{
	if(tesd && tesd->pb)
	{
		free(tesd->pb);
		free((char *)tesd);
	}
	else
	{
		errno = ENOMEM;
		ff(se,"\r\n\r\nFREE_ESD FAILED. FATAL ERROR. SORRY.\r\n");
		termecu(TERMECU_XMTR_FATAL_ERROR);
	}
}

/*+-------------------------------------------------------------------------
    esdcat(dest,suffix,realloc_ok) - "strcat" for ESDs

  Append 'suffix' contents to 'dest'
  if realloc_ok true, expand 'dest' as necessary

  Returns: 0 - success
           eNoMemory
           eBufferTooSmall
--------------------------------------------------------------------------*/
int
esdcat(dest,suffix,realloc_ok)
ESD *dest;
ESD *suffix;
int realloc_ok;
{
	int erc = 0;
	int new_maxcb = dest->cb + suffix->cb;

	if(dest->maxcb < new_maxcb)
	{
		if(!realloc_ok)
			return(eBufferTooSmall);
		if(erc = esdrealloc(dest,new_maxcb))
			return(erc);
	}

	memcpy(dest->pb + dest->cb,suffix->pb,suffix->cb + 1);  /* catch null too */
	dest->cb += suffix->cb;

	return(0);

}   /* end of esdcat */

/*+-------------------------------------------------------------------------
    esdstrcat(tesd,zstr) - "strcat" for ESDs

similar to esdcat(), but with automatic esd growth
--------------------------------------------------------------------------*/
int
esdstrcat(tesd,zstr)
ESD *tesd;
char *zstr;
{
	register zstrlen = strlen(zstr);
	register erc = 0;

	if(zstrlen > (tesd->maxcb - tesd->cb))
	{
		if(erc = esdrealloc(tesd,tesd->cb + zstrlen))
			return(erc);
	}

	if(zstrlen)
	{
		strncpy(tesd->pb + tesd->cb,zstr,zstrlen);
		tesd->cb += zstrlen;
		esd_null_terminate(tesd);
	}

	return(erc);

}	/* end of esdstrcat */


/*+-------------------------------------------------------------------------
	esdshow(tesd,title)
--------------------------------------------------------------------------*/
void
esdshow(tesd,title)
ESD *tesd;
char *title;
{
register itmp;

	if(title && *title)
	{
		pputs(title);
		pputs("\n");
	}
	esd_null_terminate(tesd);
	pputs(tesd->pb);
	pputs("\n");
	for(itmp = 0; itmp <= tesd->cb; itmp++)
	{
		if(itmp == tesd->old_index)
			pputc('^');
		else if(itmp == tesd->index)
			pputc('^');
		else
			pputc(' ');
		if((itmp > tesd->old_index) && (itmp > tesd->index))
			break;
	}
#if 0
	pprintf(" o%d i%d c%d\n",tesd->old_index,tesd->index,tesd->cb);
#else
	pputs("\n");
#endif

}	/* end of esdshow */

/*+----------------------------------------------------------------
    strindex:  string index function

  Returns position of 'str2' in 'str1' if found
  If 'str2' is null, then 0 is returned (null matches anything)
  Returns -1 if not found
-----------------------------------------------------------------*/
int
strindex(str1,str2)
char *str1;	/* the (target) string to search */
char *str2;	/* the (comparand) string to search for */
{
register istr1 = 0;
register lstr2 = strlen(str2);
register char *mstr = str1;	/* the (target) string to search */

	if(*str2 == 0)			/* null string matches anything */
		return(0);

	while(*mstr)
	{
		if(*mstr == *str2)
		{ /* we have a first char match... does rest of string match? */
			if(!strncmp(mstr,str2,lstr2))
				return(istr1);		/* if so, return match position */
		}
		mstr++;
		istr1++;
	}

	return(-1);		/* if we exhaust target string, flunk */

}   /* end of strindex */

/*+-------------------------------------------------------------------------
	esdstrindex(esd1,esd2,index1_flag,index2_flag)

  Call strindex with esd1->pb and esd2->pb.
  If index1_flag != 0, esd1->pb + esd1->index passed
  If index2_flag != 0, esd2->pb + esd2->index passed
--------------------------------------------------------------------------*/
esdstrindex(esd1,esd2,index1_flag,index2_flag)
register ESD *esd1;
register ESD *esd2;
register index1_flag;
register index2_flag;
{
	return(strindex((index1_flag) ? esd1->pb : esd1->pb + esd1->index,
	    (index2_flag) ? esd2->pb : esd2->pb + esd2->index));

}	/* end of esdstrindex */

/*+----------------------------------------------------------------
    keyword_lookup(ktable,tesd)

  Lookup string in keyword_table struct array
  Returns table->key_token if 'tesd' found in
  'table', else -1

  Beware substrings.  "type","typedef" will both match "type"
-----------------------------------------------------------------*/
keyword_lookup(ktable,tesd)
register KEYTAB *ktable;
register char *tesd;
{
/* register plen = strlen(tesd); */

	while(ktable->key_word)
	{
/*		if(!strncmp(ktable->key_word,tesd,plen)) */
		if(!strcmp(ktable->key_word,tesd))
			return(ktable->key_token);
		++ktable;
	}   /* end of while */

	return(-1);     /* search failed */

}   /* end of keyword_lookup */

/*+----------------------------------------------------------------
    skip_cmd_break(tesd)

  Finds next non-break

  'tesd' is an esd with valid 'index' field
  Returns  0             index field points to non-break character
           eNoParameter  end of command found
-----------------------------------------------------------------*/
int
skip_cmd_break(tesd)
register ESD *tesd;
{
register cb = tesd->cb;
register index = tesd->index;
register char *pb = tesd->pb;

	while(index < cb)
	{
		if(!isspace(*(pb + index)))
			break;
		index++;
	}
	tesd->old_index = tesd->index = index;
	if(index >= cb)
		return(eNoParameter);
	return(0);

}   /* end of skip_cmd_break */

/*+-------------------------------------------------------------------------
	end_of_cmd(tesd) - return 1 if at end of command
--------------------------------------------------------------------------*/
int
end_of_cmd(tesd)
register ESD *tesd;
{
	if(skip_cmd_break(tesd) || (*(tesd->pb + tesd->index) == ';') ||
			(*(tesd->pb + tesd->index) == '#'))
		return(1);
	return(0);
}	/* end of end_of_cmd */

/*+-------------------------------------------------------------------------
    erc = skip_cmd_char(tesd,skipchar)
--------------------------------------------------------------------------*/
int
skip_cmd_char(tesd,skipchar)
register ESD *tesd;
register char skipchar;
{
int erc;

	if(erc = skip_cmd_break(tesd))
		return(erc);

	if(tesd->pb[tesd->index] == skipchar)
	{
		++tesd->index;
		return(0);
	}

	return(eSyntaxError);

}   /* end of skip_cmd_char */

/*+-------------------------------------------------------------------------
    erc = skip_colon(tesd)
--------------------------------------------------------------------------*/
int
skip_colon(tesd)
register ESD *tesd;
{
	register erc;

	if(erc = skip_cmd_break(tesd))
		return(erc);

	if(tesd->pb[tesd->index] == ':')
	{
		++tesd->index;
		return(0);
	}

	return(eCommaExpected);

}   /* end of skip_colon */

/*+-------------------------------------------------------------------------
    erc = skip_comma(tesd)
--------------------------------------------------------------------------*/
int
skip_comma(tesd)
register ESD *tesd;
{
	register erc;

	if(erc = skip_cmd_break(tesd))
		return(erc);

	if(tesd->pb[tesd->index] == ',')
	{
		++tesd->index;
		return(0);
	}

	return(eCommaExpected);

}   /* end of skip_comma */

/*+-------------------------------------------------------------------------
    erc = skip_paren(fparam,LEFT or RIGHT)
--------------------------------------------------------------------------*/
int
skip_paren(tesd,fLeft)
register ESD *tesd;
int fLeft;
{
register erc;
register char search = (fLeft) ? '(' : ')';

	if(erc = skip_cmd_break(tesd))
		return(erc);

	if(tesd->pb[tesd->index] == search)
	{
		tesd->index++;
		return(0);
	}
	return((fLeft) ? eMissingLeftParen : eMissingRightParen);

}   /* end of skip_paren */

/*+-------------------------------------------------------------------------
	get_cmd_char(tesd,pchar)
--------------------------------------------------------------------------*/
int
get_cmd_char(tesd,pchar)
register ESD *tesd;
char *pchar;
{
int erc;

	if(erc = skip_cmd_break(tesd))
		return(erc);
	*pchar = tesd->pb[tesd->index++];
	return(0);

}	/* end of get_cmd_char */

/*+----------------------------------------------------------------
    get_alpha_zstr(&esd,&strbuf,strbuf_maxcb)

  places next alphabetic string token [A-Za-z_] into
  the null-terminated 'strbuf' string.  returns 0 or -1
  or skip_cmd_break error codes
-----------------------------------------------------------------*/
int
get_alpha_zstr(tesd,strbuf,strbuf_maxcb)
ESD *tesd;
register char *strbuf;
int strbuf_maxcb;
{
register izstr;
register schar;
register char *pb = tesd->pb;

	if(izstr = skip_cmd_break(tesd))
		return(izstr);
	izstr = 0;
	while( (izstr < strbuf_maxcb-1) && (tesd->index < tesd->cb) )
	{
		schar = pb[tesd->index];
		if((!isalpha(schar)) && (schar != '_'))
			break;
		strbuf[izstr++] = schar;
		tesd->index++;
	}

	strbuf[izstr] = 0;
	return(izstr ? 0 : eBadParameter);

}   /* end of get_alpha_zstr */

/*+----------------------------------------------------------------
    get_alphanum_zstr(&esd,&strbuf,strbuf_maxcb)

  places next alphanumeric string token [A-Za-z0-9_]
  into the null-terminated 'strbuf' string.  returns 0
  or -1 or skip_cmd_break error codes
-----------------------------------------------------------------*/
int
get_alphanum_zstr(tesd,strbuf,strbuf_maxcb)
register ESD *tesd;
register char *strbuf;
int strbuf_maxcb;
{
int izstr = 0;
int schar;
register cb = tesd->cb;
register index;

	if(izstr = skip_cmd_break(tesd))
		return(izstr);

	index = tesd->index;
	while( (izstr < strbuf_maxcb-1) && (index < cb))
	{
		schar = tesd->pb[index++];
		if(isalnum(schar) || (schar == '_'))
			strbuf[izstr++] = schar;
		else
		{
			--index;
			break;
		}
	}

	tesd->index = index;
	strbuf[izstr]=0;
	return(izstr ? 0 : eBadParameter);

}   /* end of get_alphanum_zstr */

/*+----------------------------------------------------------------
    get_numeric_zstr(&esd,&strbuf,strbuf_maxcb)
    gets next numeric string token places it
    into the null-terminated 'strbuf' string.  returns 0 or -1 
    or skip_cmd_break error codes
-----------------------------------------------------------------*/
int
get_numeric_zstr(tesd,strbuf,strbuf_maxcb)
register ESD *tesd;
register char *strbuf;
register strbuf_maxcb;
{
	register izstr;
	register schar;

	if(izstr = skip_cmd_break(tesd))
		return(izstr);

	while( (izstr < strbuf_maxcb-1) && (tesd->index < tesd->cb) )
	{
		schar = tesd->pb[tesd->index++];
		if( isdigit(schar) )
			strbuf[izstr++]=schar;
		else
		{
			--tesd->index;
			break;
		}
	}

	strbuf[izstr]=0;
	return(izstr ? 0 : eBadParameter);

}   /* end of get_numeric_zstr */

/*+-----------------------------------------------------------------------
	get_numeric_value(tesd,&long_var)
------------------------------------------------------------------------*/
get_numeric_value(tesd,value)
register ESD *tesd;
register long *value;
{
register erc;
char buf[32];

	if(erc = get_numeric_zstr(tesd,buf,sizeof(buf)))
		return(erc);
	sscanf(buf,"%ld",value);
	return(0);

}	/* end of get_numeric_value */

/*+----------------------------------------------------------------
    get_word_zstr(&esd,&strbuf,strbuf_maxcb)

  gets next word (continuous string of characters without spaces
  or tabs) returns 0 or -1 or skip_cmd_break error codes
-----------------------------------------------------------------*/
int
get_word_zstr(tesd,strbuf,strbuf_maxcb)
register ESD *tesd;
register char *strbuf;
register strbuf_maxcb;
{
	register izstr;
	register schar;

	if(izstr = skip_cmd_break(tesd))
		return(izstr);

	strbuf_maxcb--;
	while((izstr < strbuf_maxcb) && (tesd->index < tesd->cb))
	{
		schar = tesd->pb[tesd->index++];
		if( (schar > 0x20) && (schar <= 0x7e))
			strbuf[izstr++]=schar;
		else
		{
			--tesd->index;
			break;
		}
	}

	strbuf[izstr]=0;
	return(izstr ? 0 : eBadParameter);

}   /* end of get_word_zstr */

/*+-------------------------------------------------------------------------
    esd_strip_trail_break(tesd)
--------------------------------------------------------------------------*/
void
esd_strip_trail_break(ztext)
register ESD *ztext;
{
	while(ztext->cb &&
		((ztext->pb[ztext->cb-1] == 0x20) || (ztext->pb[ztext->cb-1] == 0x20)))
	{
		ztext->cb--;
	}
}   /* end of esd_strip_trail_break */

/*+-------------------------------------------------------------------------
	esdfgets(&esd,fileptr)

  stdio read from FILE *fileptr into esd
  returns tesd->cb set up not including trailing nl, tesd->index == 0
--------------------------------------------------------------------------*/
int
esdfgets(tesd,fileptr)
register ESD *tesd;
register FILE *fileptr;
{
register char *cptr;

	tesd->cb = 0;
	if(!fgets(tesd->pb,tesd->maxcb+1,fileptr))
		return(eEOF);
	if(!(cptr = strchr(tesd->pb,0x0A)))
		return(eBufferTooSmall);
	tesd->cb = (int)(cptr - tesd->pb);
	esd_null_terminate(tesd);
	tesd->index = 0;
	tesd->old_index = 0;
	return(0);

}	/* end of esdfgets */

/*+-------------------------------------------------------------------------
	esdfputs(&esd,fileptr,index_flag,nl_flag)

  write esd contents to stdio FILE *fileptr
  if index_flag is true, write from tesd->index thru end of esd
  otherwise, from start of esd
  if nl_flag is true, append nl to write, else just esd contents
--------------------------------------------------------------------------*/
int
esdfputs(tesd,fileptr,index_flag,nl_flag)
register ESD *tesd;
FILE *fileptr;
int index_flag;
int nl_flag;
{
register char *cptr;
register write_length;

	if(index_flag)
	{
		cptr = &tesd->pb[tesd->index];
		write_length = tesd->cb - tesd->index;
	}
	else
	{
		cptr = tesd->pb;
		write_length = tesd->cb;
	}

	if(write_length)
		fwrite(cptr,write_length,1,fileptr);

	if(nl_flag)
		fputc(0x0A,fileptr);

	return(0);
}	/* end of esdfputs */

/*+-------------------------------------------------------------------------
    get_switches(tesd,switches,switches_max)
--------------------------------------------------------------------------*/
int
get_switches(tesd,switches,switches_max)
ESD *tesd;
char *switches;
int switches_max;
{
register erc;
register index;
register char *pb = tesd->pb;
int cb = tesd->cb;
char schar;

	*switches = 0;

	if(erc = skip_cmd_break(tesd))
		return(erc);

	index = tesd->index;
	if(*(pb + index) != '-')
		return(eNoSwitches);

	if(switches_max < 3)
		return(eSwitchesTooLong);

	switches_max--;			/* for trailing null */
	*switches++ = '-';
	switches_max--;
	index++;
	while(index < cb)
	{
		schar = *(pb + index++);
		if(switches_max > 0)
			*switches++ = schar;
		switches_max--;
		if(isspace(schar))
			break;
	}

	tesd->index = index;
	*switches = 0;
	return((switches_max < 0) ? eSwitchesTooLong : 0);

}   /* end of get_switches() */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of esdutil.c */
