/*+-----------------------------------------------------------------------
	ecuutil.c -- utility routines for extended calling unit
	wht@n4hgf.Mt-Park.GA.US


  Defined functions:
	arg_token(parsestr,termchars)
	ascii_name_to_hex(str3char)
	ascii_to_hex(ascii)
	build_arg_array(cmd,arg,arg_max_quan,narg_rtn)
	build_str_array(str,arg,str_max_quan,nstr_rtn)
	cfree(p,num,size)
	defeat_optimize_to_work_around_bug(would_be_optimized)
	disp_line_termio(fd,text)
	disp_stat(st)
	disp_termio(ttt,text)
	errno_text(err)
	find_shell_chars(command)
	get_curr_dir(cdir,cdir_max)
	get_home_dir(home_dir)
	hex_to_ascii_name(char_val)
	make_char_graphic(ch,incl_3char)
	make_ecu_subdir()
	mem_cpy(dest,src,len)
	mode_map(mode,mode_str)
	pad_zstr_to_len(zstr,len)
	perror_errmsg(str)
	rdchk(fd)
	skip_ld_break(zstr)
	str_classify(sc,str)
	str_token(parsestr,termchars)
	strip_trail_break(zstr)
	yes_or_no(strarg)

This module assumes the neo-standard 'mode_t' type is an unsigned
short and 'dev_t' is a short in accordance with tradition.  This
is, in fact, true with all the supported systems which have it as
of this writing.  This is just a test of the Brown Shirt Warning
System.  If this had been an actual Brown Shirt Alert, you would
have heard the noise of sickening thuds and breaking things nearby.

------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:05-11-1992-16:42-wht@gyro-fix WORKING_SELECT nap once and for all */
/*:05-08-1992-02:42-wht@n4hgf-select-based Nap was buggy on EINTR */
/*:04-05-1992-15:31-wht@n4hgf-no more use of memmove in any environment */
/*:02-22-1992-16:19-wht@n4hgf-build arg/str array now handles zero tokens */
/*:11-26-1991-19:36-wht@n4hgf-add str_classify and yes_or_no uses it */
/*:09-01-1991-12:46-wht@n4hgf2-show sun flow control bit */
/*:08-30-1991-20:09-wht@n4hgf2-sun Nap was not returning a value */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:08-17-1991-14:11-root@n4hgf-ascii_to_hex supports "csi" */
/*:08-13-1991-13:53-wht@n4hgf-UNIX and ISC nap() broken; XENIX still wins */
/*:07-25-1991-12:57-wht@n4hgf-ECU release 3.10 */
/*:04-16-1991-15:45-wht@n4hgf-gcc cannot use memmove */
/*:03-18-1991-22:31-wht@n4hgf-ISC 2.2 has mkdir() */
/*:02-03-1991-14:23-wht@n4hgf-hack workaround for get_home_dir under x286 */
/*:01-25-1991-16:23-wht@n4hgf-source name wrong in headers */
/*:12-26-1990-14:32-wht@n4hgf-use memmove or Duff's Device in mem_cpy() */
/*:12-04-1990-00:58-wht@n4hgf-allow alternating between str/arg_token */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "termecu.h"
#include "ecufork.h"
#include "ecukey.h"
#include "ecu_pwd.h"

#if defined(sun)
#undef ECHO
#undef NL0
#undef NL1
#undef TAB0
#undef TAB1
#undef TAB2
#undef XTABS
#undef CR0
#undef CR1
#undef CR2
#undef CR3
#undef FF0
#undef FF1
#undef BS0
#undef BS1
#undef TOSTOP
#undef FLUSHO
#undef PENDIN
#undef NOFLSH
#include <sys/ioctl.h>
#endif

#if defined(SVR4)
# include <sys/termiox.h>
extern int hx_flag;
#endif

char *getenv();

extern int errno;
extern char curr_dir[CURR_DIRSIZ];

char *str_token_static = (char *)0;

char *ascii_ctlstr =
"NULSOHSTXETXEOTENQACKBELBS HT NL VT FF CR SO SI DLEDC1DC2DC3DC4NAKSYNETBCANEM SUBESCFS GS RS US SP ";

/*+-------------------------------------------------------------------------
	mem_cpy(dest,src,len) - memcpy() with non-destructive overlapping copy

  use Duff's device for speed if memmove not available
--------------------------------------------------------------------------*/
void
mem_cpy(dest,src,len)
register char *dest;
register char *src;
register len;
{
#if 0 /* defined(M_UNIX) && !defined(DUFF)*/ /*  && !defined(__GNUC__) */
	/*
	 * memmove() clobbers regs that GCC wants to keep
	 * unless you use -fcall-save-bx
	 */
	memmove(dest,src,len);
#else
	/*
	 * for systems without memmove or with compiler that cannot use it
	 */

	register itmp = (len + 7) / 8;
	if(dest > src)
	{
		dest += len;
		src += len;
		switch(len % 8)
		{
		case 0:	do{	*--dest = *--src;
		case 7:		*--dest = *--src;
		case 6:		*--dest = *--src;
		case 5:		*--dest = *--src;
		case 4:		*--dest = *--src;
		case 3:		*--dest = *--src;
		case 2:		*--dest = *--src;
		case 1:		*--dest = *--src;
			 	}while(--itmp > 0);
		}
	}
	else
	{
		switch(len % 8)
		{
		case 0:	do{	*dest++ = *src++;
		case 7:		*dest++ = *src++;
		case 6:		*dest++ = *src++;
		case 5:		*dest++ = *src++;
		case 4:		*dest++ = *src++;
		case 3:		*dest++ = *src++;
		case 2:		*dest++ = *src++;
		case 1:		*dest++ = *src++;
			 	}while(--itmp > 0);
		}
	}
#endif
}	/* end of mem_cpy */

/*+-------------------------------------------------------------------------
	skip_ld_break(zstr) - skip leading spaces and tabs
--------------------------------------------------------------------------*/
char *
skip_ld_break(zstr)
register char *zstr;
{
	while(isspace(*zstr))
		zstr++;
	return(zstr);
}	/* end of skip_ld_break */

/*+-------------------------------------------------------------------------
	strip_trail_break(zstr) - strip leading spaces and tabs
--------------------------------------------------------------------------*/
void
strip_trail_break(zstr)
char *zstr;
{
	register int itmp = strlen(zstr);
	register char *zptr = zstr + itmp - 1;

	while(itmp && isspace(*zptr))
	{
		*zptr-- = 0;
		itmp--;
	}
}	/* end of strip_trail_break */

/*+-----------------------------------------------------------------------
	pad_zstr_to_len(zstr,len)

  pads with spaces to specified length, unless already longer than
  len in which case the string is truncated to 'len' characters.
------------------------------------------------------------------------*/
void
pad_zstr_to_len(zstr,len)
char *zstr;
int len;
{
	register izstr;

	izstr = strlen(zstr);
	if(izstr >= len)
		zstr[len] = 0;
	else
	{
		while(izstr < len)
			zstr[izstr++] = 0x20;
		zstr[izstr] = 0;
	}
}	/* end of pad_zstr_to_len */

/*+-----------------------------------------------------------------------
	arg_token(parsestr,termchars)

Get next token from string parsestr ((char *)0 on 2nd, 3rd, etc.
calls), where tokens are nonempty strings separated by runs of chars
from termchars.  Writes nulls into parsestr to end tokens.
termchars need not remain constant from call to call.

Treats multiple occurrences of a termchar as one delimiter (does not
allow null fields).
------------------------------------------------------------------------*/
char *
arg_token(parsestr,termchars)
char *parsestr;
char *termchars;
{
	register char *parseptr;
	char *token;

	if(!parsestr && !str_token_static)
		return((char *)0);

	if(parsestr)
	{
		str_token_static = (char *)0;
		parseptr = parsestr;
	}
	else
       parseptr = str_token_static;

	while(*parseptr)
	{
		if(!strchr(termchars,*parseptr))
			break;
		parseptr++;
	}

	if(!*parseptr)
	{
		str_token_static = (char *)0;
		return((char *)0);
	}

	token = parseptr;

	/*
	 * tokens beginning with apostrophe or quotes kept together
	 */
	if(*token == '\'')
	{
		token++;
		parseptr++;
		while(*parseptr)
		{
			if(*parseptr == '\'')
			{
				str_token_static = parseptr + 1;
				*parseptr = 0;
				return(token);
			}
			parseptr++;
		}
		str_token_static = (char *)0;
		return(token);
	}
	else if(*token == '"')
	{
		token++;
		parseptr++;
		while(*parseptr)
		{
			if(*parseptr == '"')
			{
				str_token_static = parseptr + 1;
				*parseptr = 0;
				return(token);
			}
			parseptr++;
		}
		str_token_static = (char *)0;
		return(token);
	}

	while(*parseptr)
	{
		if(strchr(termchars,*parseptr))
		{
			*parseptr = 0;
			str_token_static = parseptr + 1;
			while(*str_token_static)
			{
				if(!strchr(termchars,*str_token_static))
					break;
				str_token_static++;
			}
			return(token);
		}
		parseptr++;
	}
	str_token_static = (char *)0;
	return(token);
}	/* end of arg_token */

/*+-------------------------------------------------------------------------
	build_arg_array(cmd,arg,arg_max_quan,&narg)
--------------------------------------------------------------------------*/
void
build_arg_array(cmd,arg,arg_max_quan,narg_rtn)
char *cmd;
char **arg;
int arg_max_quan;
int *narg_rtn;
{
	register narg;

	str_token_static = (char *)0;
	memset((char *)arg,0,sizeof(char *) * arg_max_quan);
	if(!(arg[0] = arg_token(cmd," \t\r\n")))
	{
		*narg_rtn = 0;
		return;
	}

	for(narg = 1; narg < arg_max_quan; ++narg)
	{
		if(!(arg[narg] = arg_token((char *)0," \t\r\n"))) 
			break;
	}

	*narg_rtn = narg;

}	/* end of build_arg_array */

/*+-----------------------------------------------------------------------
	str_token(parsestr,termchars)

Get next token from string parsestr ((char *)0 on 2nd, 3rd, etc.
calls), where tokens are nonempty strings separated by runs of chars
from termchars.  Writes nulls into parsestr to end tokens.
termchars need not remain constant from call to call.

Treats each occurrence of a termchar as delimiter (allows null
fields).
------------------------------------------------------------------------*/
char *
str_token(parsestr,termchars)
char *parsestr;
char *termchars;
{
	register char *termptr;
	register char *parseptr;
	char *token;

	if(!parsestr && !str_token_static)
		return((char *)0);

	if(parsestr)
	{
		str_token_static = (char *)0;
		parseptr = parsestr;
	}
	else
       parseptr = str_token_static;

	while(*parseptr)
	{
		for(termptr = termchars; *termptr != 0; termptr++)
		{
			if(*parseptr == *termptr)
				goto FOUND_TERM;
		}
		if(!*termptr)
			break;
		parseptr++;
	}

	if(!*parseptr)
	{
		str_token_static = (char *)0;
		return((char *)0);
	}

FOUND_TERM:
	token = parseptr;
	while(*parseptr)
	{
		for(termptr = termchars; *termptr;)
		{
			if(*parseptr == *termptr++)
			{
				str_token_static = parseptr + 1;
				*parseptr = 0;
				return(token);
			}
		}
		parseptr++;
	}
	str_token_static = (char *)0;
	return(token);
}	/* end of str_token */

/*+-------------------------------------------------------------------------
	build_str_array(str,arg,arg_max_quan,&narg)
--------------------------------------------------------------------------*/
void
build_str_array(str,arg,arg_max_quan,narg_rtn)
char *str;
char **arg;
int arg_max_quan;
int *narg_rtn;
{
	register narg;

	str_token_static = (char *)0;
	memset((char *)arg,0,sizeof(char *) * arg_max_quan);
	if(!(arg[0] = str_token(str," \t\r\n")))
	{
		*narg_rtn = 0;
		return;
	}

	for(narg = 1; narg < arg_max_quan; ++narg)
	{
		if(!(arg[narg] = str_token((char *)0," \t\r\n"))) 
			break;
	}

	*narg_rtn = narg;

}	/* end of build_str_array */

/*+-----------------------------------------------------------------------
	make_char_graphic(character,incl_3char) - Make all chars "printable"

  returns pointer to a static string containing printable version
  of a character.  If control char, printed as "^A", etc.
  if incl_3char set true, then space + ASCII assignment (e.g. "NUL") is
  appended to the string for non-printable graphics
------------------------------------------------------------------------*/
char *
make_char_graphic(ch,incl_3char)
register char ch;
int incl_3char;
{
	static char gg[16];

	ch &= 0x7F;
	if((ch >= 0x20) && (ch < 0x7F))
	{
		gg[0] = ch; gg[1] = 0;
	}
	else
	{
		gg[0] = '^'; 
		if(ch == 0x7F)
		{
			gg[1] = '?';
			if(incl_3char)
				strcpy(&gg[2]," DEL");
			else
				gg[2] = 0;
		}
		else
		{
			gg[1] = ch + 0x40;
			if(incl_3char)
			{
				gg[2] = 0x20;
				strncpy(&gg[3],ascii_ctlstr + (ch * 3),3);
				gg[7] = 0;
			}
			else
				gg[2] = 0;
		}
	}
	return(gg);
}	/* end of make_char_graphic */

/*+-----------------------------------------------------------------------
	mode_map(mode,mode_str)	build drwxrwxrwx string
------------------------------------------------------------------------*/
char *
mode_map(mode,mode_str)
unsigned short mode;
char *mode_str;
{
	register unsigned ftype = mode & S_IFMT;
	register char *rtn;
	static char result[12];

	rtn = (mode_str == (char *)0) ? result : mode_str;

	/*               drwxrwxrwx */
	/*               0123456789 */
	strcpy(rtn,"----------");

	switch(ftype)
	{
		case S_IFIFO:	*rtn = 'p'; break; /* FIFO (named pipe) */
		case S_IFDIR:	*rtn = 'd'; break; /* directory */
		case S_IFCHR:	*rtn = 'c'; break; /* character special */
		case S_IFBLK:	*rtn = 'b'; break; /* block special */
		case S_IFREG:	*rtn = '-'; break; /* regular */

#if defined(S_IFLNK)
		case S_IFLNK:	*rtn = 'l'; break; /* symbolic link */
#endif
#if defined(S_IFSOCK)
		case S_IFSOCK:	*rtn = 's'; break; /* socket */
#endif

#if defined(S_IFNAM)
		case S_IFNAM:						/* name space entry */
#if defined(S_IFNAM)
			if(mode & S_INSEM)				/* semaphore */
			{
				*rtn = 's';
				break;
			}
#endif
#if defined(S_INSHD)
			if(mode & S_INSHD)				/* shared memory */
			{
				*rtn = 'm';
				break;
			}
			break;
#endif
#endif

		default:		*rtn = '?'; break;	/* ??? */
	}

	if(mode & 000400) *(rtn + 1) = 'r';
	if(mode & 000200) *(rtn + 2) = 'w';
	if(mode & 000100) *(rtn + 3) = 'x';
	if(mode & 004000) *(rtn + 3) = 's';
	if(mode & 000040) *(rtn + 4) = 'r';
	if(mode & 000020) *(rtn + 5) = 'w';
	if(mode & 000010) *(rtn + 6) = 'x';
	if(mode & 002000) *(rtn + 6) = 's';
	if(mode & 000004) *(rtn + 7) = 'r';
	if(mode & 000002) *(rtn + 8) = 'w';
	if(mode & 000001) *(rtn + 9) = 'x';
	if(mode & 001000) *(rtn + 9) = 't';

	return(rtn);

}	/* end of mode_map */

/*+-----------------------------------------------------------------------
	disp_termio(ttt)
  display termio 'ttt' on stderr
------------------------------------------------------------------------*/
void disp_termio(ttt,text)
struct termio *ttt;
char *text;
{
	register flag;
	register i_cc;
	register char *cptr;
	int dbits;
	char parity;

	pprintf("---------> %s\n",text);

	flag = ttt->c_iflag;
	pprintf(
"iflag: %07o IGNBRK:%d  BRKINT:%d  IGNPAR:%d  PARMRK:%d  INPCK:%d  ISTRIP:%d\n",
				flag,
				(flag & IGNBRK) ? 1 : 0,
				(flag & BRKINT) ? 1 : 0,
				(flag & IGNPAR) ? 1 : 0,
				(flag & PARMRK) ? 1 : 0,
				(flag & INPCK ) ? 1 : 0,
				(flag & ISTRIP) ? 1 : 0);
	pprintf("               INLCR:%d  IGNCR:%d  ICRNL:%d  IUCLC:%d  ",
				(flag & INLCR ) ? 1 : 0,
				(flag & IGNCR ) ? 1 : 0,
				(flag & ICRNL ) ? 1 : 0,
				(flag & IUCLC ) ? 1 : 0);
	pprintf("IXON:%d  IXANY:%d  IXOFF:%d\n",
				(flag & IXON  ) ? 1 : 0,
				(flag & IXANY ) ? 1 : 0,
				(flag & IXOFF ) ? 1 : 0);

	flag = ttt->c_oflag;
	pprintf("oflag: %07o OPOST:%d  OLCUC:%d  ONLCR:%d  OCRNL:%d  ",
				flag,
				(flag & OPOST ) ? 1 : 0,
				(flag & OLCUC ) ? 1 : 0,
				(flag & ONLCR ) ? 1 : 0,
				(flag & OCRNL ) ? 1 : 0);
	pprintf("ONOCR:%d  ONLRET:%d  OFDEL:%d\n",
				(flag & ONOCR ) ? 1 : 0,
				(flag & ONLRET) ? 1 : 0,
				(flag & OFDEL ) ? 1 : 0);

	flag = ttt->c_cflag;
	pprintf("cflag: %07o ",ttt->c_cflag);
	switch(flag & CBAUD)
	{
		case B0:	cptr = "HUP"; break;
		case B50:	cptr = "50"; break;
		case B75:	cptr = "75"; break;
		case B110:	cptr = "110"; break;
		case B134:	cptr = "134.5"; break;
		case B150:	cptr = "150"; break;
		case B200:	cptr = "200"; break;
		case B300:	cptr = "300"; break;
		case B600:	cptr = "600"; break;
		case B1200:	cptr = "1200"; break;
		case B1800:	cptr = "1800"; break;
		case B2400:	cptr = "2400"; break;
		case B4800:	cptr = "4800"; break;
		case B9600:	cptr = "9600"; break;
#if defined(B19200)
		case B19200:cptr = "19200"; break;
#endif
#if defined(B38400)
		case B38400:cptr = "38400"; break;
#endif
		default:	
			switch(flag & CBAUD)
			{
				case EXTA:	cptr = "EXTA"; break;
				case EXTB:	cptr = "EXTB"; break;
				default:	cptr = "????"; break;
			}
	}
	dbits = 5 + ((flag & CSIZE) >> 4);
	parity = (flag & PARENB) ? ((flag & PARODD) ? 'O' : 'E') : 'N';
	pprintf("%s-%d-%c-%d ",cptr,dbits,parity,(flag & CSTOPB) ? 2 : 1);
	switch(flag & CS8)
	{
		case CS8: pputs("CS8 "); break;
		case CS7: pputs("CS7 "); break;
		case CS6: pputs("CS6 "); break;
		case CS5: pputs("CS5 "); break;
	}
	pprintf("CREAD:%d  HUPCL:%d  CLOCAL:%d",
				(flag & CREAD ) ? 1 : 0,
				(flag & HUPCL ) ? 1 : 0,
				(flag & CLOCAL) ? 1 : 0);
#if defined(RTSFLOW) /* SCO */
	pprintf(" RTSFLOW:%d  CTSFLOW:%d",
				(flag & RTSFLOW ) ? 1 : 0,
				(flag & CTSFLOW ) ? 1 : 0);
#endif
#if defined(CRTSFL) /* SCO 3.2v4 */
	pprintf("\n               CRTSFL:%d",
				(flag & CRTSFL ) ? 1 : 0);
#endif
#if defined(RTSXOFF) /* SVR4 */
	pprintf(" RTSXOFF:%d  CTSXON:%d",
				(hx_flag & RTSXOFF ) ? 1 : 0,
				(hx_flag & CTSXON ) ? 1 : 0);
#endif
#ifdef CRTSCTS /* sun */
	pprintf(" CRTSCTS:%d",(flag & CRTSCTS) ? 1 : 0);
#endif
	pprintf("\n");

	flag = ttt->c_lflag;
	pprintf("lflag: %07o ISIG:%d  ICANON:%d  XCASE:%d  ECHO:%d  ECHOE:%d\n",
				flag,
				(flag & ISIG  ) ? 1 : 0,
				(flag & ICANON) ? 1 : 0,
				(flag & XCASE ) ? 1 : 0,
				(flag & ECHO  ) ? 1 : 0,
				(flag & ECHOE ) ? 1 : 0);
	pprintf("               ECHOK:%d  ECHONL:%d  NOFLSH:%d",
				(flag & ECHOK ) ? 1 : 0,
				(flag & ECHONL) ? 1 : 0,
				(flag & NOFLSH) ? 1 : 0);

#if defined(XCLUDE)
	pprintf("  XCLUDE:%d",(flag & XCLUDE) ? 1 : 0);
#endif
	pputs("\n");

	pprintf("ctl chars: ");
	for(i_cc = 0; i_cc < NCC; i_cc++)
		pprintf("%02x   ",ttt->c_cc[i_cc]);
	pputs("  (hex)\n");
	pputs("           INTR QUIT ERAS KILL EOF  EOL  ");
	pputs("EOL2 SWTCH  VMIN-EOF VTIME-EOL\n");

}	/* end of disp_termio */

/*+-------------------------------------------------------------------------
	disp_stat(st)
--------------------------------------------------------------------------*/
void
disp_stat(st)
struct stat *st;
{
	char mdmap[32];
	mode_map(st->st_mode,mdmap);
	pprintf("mode: %s ",mdmap);
	pprintf("inode: %5u  dev: %3u rdev: %u,%u (0x%04x)\n",
	    (uint)st->st_ino,(uint)st->st_dev,
	    (ushort)st->st_rdev >> 8,(ushort)st->st_rdev & 0xFF,
	    (ushort)st->st_rdev);

}	/* end of disp_stat */

/*+-----------------------------------------------------------------------
	disp_line_termio(fd)

Get current termio structure for file descriptor fd
and display on stderr
------------------------------------------------------------------------*/
void
disp_line_termio(fd,text)
int fd;		/* file descriptor */
char *text;
{
	struct termio fd_termio;
	struct stat fd_stat;
	char text2[128];

	ioctl(fd,TCGETA,&fd_termio);
	sprintf(text2,"fd: %d  %s",fd,text);
	disp_termio(&fd_termio,text2);
	fstat(fd,&fd_stat);
	disp_stat(&fd_stat);

}	/* end of disp_line_termio */

/*+-----------------------------------------------------------------------
	ascii_name_to_hex(str3char)

  return value of ascii ctl char name (e.g., "NUL") 0 - 0x1F
  support CSI "ascii" 0x9B (for ESC + '[' ANSI)
  returns -1 if input not valid
------------------------------------------------------------------------*/
ascii_name_to_hex(str3char)
char *str3char;
{
	register char *cptr = ascii_ctlstr;
	register intval;

	if((strlen(str3char) == 3) && (ulcmpb(str3char,"del") < 0))
		return(0x7F);
	if((strlen(str3char) == 3) && (ulcmpb(str3char,"csi") < 0))
		return(0x9B);

	for(intval = 0; intval <= SPACE; intval++)
	{
		if(	(to_lower(*str3char) == to_lower(*cptr))				&&
			(to_lower(*(str3char + 1)) == to_lower(*(cptr + 1)))	&&
			((to_lower(*(str3char + 2)) == to_lower(*(cptr + 2)))	||
			(*(cptr + 2) == ' ')))
		{
			return(intval);
		}
		cptr += 3;
	}

	return(-1);

}	/* end of ascii_name_to_hex */

/*+-------------------------------------------------------------------------
	ascii_to_hex(ascii)
--------------------------------------------------------------------------*/
int
ascii_to_hex(ascii)
char *ascii;
{
	int hexval;
	if(strlen(ascii) == 1)
		return(*ascii);
	else if(!strncmp(ascii,"0x",2))
	{
		sscanf(ascii + 2,"%x",&hexval);
		return(hexval & 0xFF);
	}
	else if(*ascii == '^')
		return(*(ascii + 1) & 0x1F);
	else
		return(ascii_name_to_hex(ascii));
}	/* end of ascii_to_hex */

/*+-------------------------------------------------------------------------
	hex_to_ascii_name(char_val)

  Returns pointer to static string containing three character ASCII
  name for control character followed by a null.
--------------------------------------------------------------------------*/
char *
hex_to_ascii_name(char_val)
char char_val;
{
	static char ascii_name[4];

	char_val &= 0x7F;

	if(char_val == 0x7F)
		strcpy(ascii_name,"DEL");
	else if(char_val > SPACE)
	{
		ascii_name[0] = char_val;
		ascii_name[1] = 0;
	}
	else
	{
		strncpy(ascii_name,ascii_ctlstr + (char_val * 3),3);
		ascii_name[3] = 0;
	}

	return(ascii_name);

}	/* end of hex_to_ascii_name */

/*+-------------------------------------------------------------------------
	get_curr_dir(cdir,cdir_max) - get current directory into 'cdir'
--------------------------------------------------------------------------*/
int
get_curr_dir(cdir,cdir_max)
char *cdir;
int cdir_max;
{
	FILE *popen();
	FILE *pipefp = popen("/bin/pwd","r");
	int itmp;

	strcpy(cdir,".");
	if(!pipefp)
		return(-1);
	fgets(cdir,cdir_max,pipefp);
	if((itmp = strlen(cdir)) && (*(cdir + itmp - 1) == 0x0A))
		*(cdir + itmp - 1) = 0;
	fclose(pipefp);
	return(0);
}	/* end of get_curr_dir */

/*+-----------------------------------------------------------------------
	get_home_dir(home_dir) - get user home directory
------------------------------------------------------------------------*/
get_home_dir(home_dir)
char *home_dir;
{
	static char home_directory[256] = "";
	struct passwd *pwent;
	char *cptr;

	if(home_directory[0])
	{
		strcpy(home_dir,home_directory);
		return(0);
	}

	if(cptr = getenv("HOME"))			/* x286 seems to blow up ... */
	{									/* ... in pwent code ... hmmm */
		strcpy(home_directory,cptr);
		strcpy(home_dir,cptr);
		return(0);
	}

	if(!(pwent = getpwuid(getuid())))
	{
		pperror("cannot get pwent for you!!");
		termecu(TERMECU_PWENT_ERROR);
	}
	strcpy(home_directory,pwent->pw_dir);
	strcpy(home_dir,pwent->pw_dir);
	endpwent();
	return(0);

}	/* end of get_home_dir */

/*+-------------------------------------------------------------------------
	make_ecu_subdir()
must be called early in execution before wierd tty states set, etc.
--------------------------------------------------------------------------*/
void
make_ecu_subdir()
{
	int itmp;
	struct stat fst;
	char s256[256];
	char s258[258];

	get_home_dir(s256);
	strcat(s256,"/.ecu");
	if((!(itmp = stat(s256,&fst))) && ((fst.st_mode & S_IFMT) != S_IFDIR))
	{
		ff(se,"~/.ecu is not a directory. Rename the file and try again.\n\n");
		exit(1);
	}
	if(itmp)		/* if stat failed, try to make the directory */
	{
		strcpy(s258,s256);
		strcat(s258,"/x");
		errno = ENOENT;
		if(make_dirs(s258))
		{
			if(stat(s256,&fst))
			{
				ff(se,"cannot make ~/.ecu subdirectory.\n");
				perror(s256);
				exit(1);
			}
		}
	}
	chmod(s256,0700);
}	/* end of make_ecu_subdir */

/*+-------------------------------------------------------------------------
	str_classify(sc,str) - classify a string and return value

Use the STR_CLASSIFY structure to classify a string (convert str to
lexical token or error code) and return the value;  use last token
in table if no string matches
--------------------------------------------------------------------------*/
str_classify(sc,str)
STR_CLASSIFY *sc;
char *str;
{
	while(sc->str)
	{
		if(minunique(sc->str,str,sc->min_ch))
			return(sc->token);
		sc++;
	}
	return(sc->token);
}	/* end of str_classify */

/*+-------------------------------------------------------------------------
	yes_or_no(strarg) - lenient yes/no, on/off

  Returns 1 if first char is 'Y' or 'y'
	or if strarg is numeric returns the numeric value
	or if strarg is alpha == "on" returns 1
  Returns 0 otherwise
--------------------------------------------------------------------------*/
int
yes_or_no(strarg)
char *strarg;
{
	static STR_CLASSIFY sc[] = {
		{ "yes",	1,1 },
		{ "on",		2,1 },
		{ "no",		1,0 },
		{ "off",	3,0 },
		{ (char *)0,0,0 },
	};

	if(isdigit(*strarg))
		return(atoi(strarg));
	else
		return(str_classify(sc,strarg));

}	/* end of yes_or_no */

/*+-------------------------------------------------------------------------
	find_shell_chars(command) - search for shell metacharacters

returns 1 if found
--------------------------------------------------------------------------*/
int
find_shell_chars(command)
char *command;
{
	register schar;
	register cchar;
	register char *scptr;
	static char shell_chars[] = "\\\"~;*?'`{}[]$";

	while(cchar = *command++)
	{
		scptr = shell_chars;
		while(schar = *scptr++)
			if(schar == cchar)
				return(1);
	}
	return(0);
}	/* end of find_shell_chars */

/*+-------------------------------------------------------------------------
	errno_text(err) - safe sys_errlist lookup
--------------------------------------------------------------------------*/
char *
errno_text(err)
int err;
{
	static char errant[32];

	if((unsigned)err <= (unsigned)sys_nerr)
		return(sys_errlist[errno]);
	sprintf(errant,"errno %d",errno);
	return(errant);

}	/* end of errno_text */

/*+-------------------------------------------------------------------------
	perror_errmsg(str)
--------------------------------------------------------------------------*/
void
perror_errmsg(str)
char *str;
{
	extern char errmsg[];

	sprintf(errmsg,"%s: %s",str,errno_text(errno));
}	/* end of perror_errmsg */

/*+-------------------------------------------------------------------------
	cfree(p,num,size) - fix bug in XENIX -lmalloc
--------------------------------------------------------------------------*/
#if defined(M_XENIX) && defined(XENIX_MALLOC_LIB_BUG)
cfree(p,num,size)
char *p;
int num;
int size;
{
	free(p);
}	/* end of cfree */
#endif

/*+-------------------------------------------------------------------------
	defeat_optimize_to_work_around_bug(would_be_optimized)

work around for GCC 1.39 optimization bug (see ecufkey.c)
This bug was fixed in gcc 1.40
--------------------------------------------------------------------------*/
#if defined(__GNUC__) && !defined(GCC140)
void
defeat_optimize_to_work_around_bug(would_be_optimized)
int *would_be_optimized;
{
	;	/* do absolutely nothing */
}	/* end of defeat_optimize_to_work_around_bug */

#endif /* __GNUC__ */

/*+-------------------------------------------------------------------------
	rdchk(fd) - for systems without it but with FIONREAD
--------------------------------------------------------------------------*/
#if defined(sun) || defined(NO_RDCHK)
int
rdchk(fd)
int fd;
{
	int chars_waiting;

	if(ioctl(fd,FIONREAD,&chars_waiting))
		return(0);
	else
		return(!!chars_waiting);
}	/* end of rdchk */
#endif

/* end of ecuutil.c */
/* vi: set tabstop=4 shiftwidth=4: */
