/*+-------------------------------------------------------------------------
	ecutime.c -- ecu time-related functions
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	epoch_secs_to_str(epoch_secs,type,buf)
	get_day(zflag)
	get_elapsed_time(elapsed_seconds)
	get_month(zflag)
	get_tod(type,buf)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu_types.h"
#include <time.h>
#include <sys/timeb.h>

struct tm *gmtime();
struct tm *localtime();

/*+-------------------------------------------------------------------------
	get_month(zflag) - month 1-12 - zflag true for UTC (Z)), else local time
--------------------------------------------------------------------------*/
int
get_month(zflag)
int zflag;
{
	long epoch_secs = time((long *)0);
	struct tm *tod = (zflag) ? gmtime(&epoch_secs) : localtime(&epoch_secs);
	return(tod->tm_mon + 1);

}	/* end of get_month */

/*+-------------------------------------------------------------------------
	get_day(zflag) - day 0-6 - zflag true for UTC (Z)), else local time
--------------------------------------------------------------------------*/
int
get_day(zflag)
int zflag;
{
	long epoch_secs = time((long *)0);
	struct tm *tod = (zflag) ? gmtime(&epoch_secs) : localtime(&epoch_secs);
	return(tod->tm_wday);

}	/* end of get_day */

/*+-----------------------------------------------------------------------
	char *epoch_secs_to_str(epoch_secs,type,buf)

  time of day types:
	0		hh:mm
	1		hh:mm:ss
	2		mm-dd-yyyy hh:mm
	3		mm-dd-yyyy hh:mm:ss
	4		mm-dd-yyyy hh:mm:ss (UTC hh:mm)
	5		mm-dd-yyyy
	6		hh:mmZ
	7		hh:mm:ssZ
	8		mm-dd-yyyy (UTC date)

	returns 'buf' address

------------------------------------------------------------------------*/
char *
epoch_secs_to_str(epoch_secs,type,buf)
long epoch_secs;
int type;
char *buf;
{
	struct tm *tod;

	if(type < 6)
		tod = localtime(&epoch_secs);
	else
		tod = gmtime(&epoch_secs);

	switch(type)
	{
		default:
		case 6:
		case 0:
			sprintf(buf,"%02d:%02d",tod->tm_hour,tod->tm_min);
			if(type == 6)
				strcat(buf,"Z");
			break;

		case 7:
		case 1:
			sprintf(buf,"%02d:%02d:%02d",tod->tm_hour,tod->tm_min,tod->tm_sec);
			if(type == 7)
				strcat(buf,"Z");
			break;

		case 2:
			sprintf(buf,"%02d-%02d-%04d %02d:%02d",
				tod->tm_mon + 1,tod->tm_mday,tod->tm_year + 1900,
				tod->tm_hour,tod->tm_min);
			break;

		case 3:
			sprintf(buf,"%02d-%02d-%04d %02d:%02d:%02d",
				tod->tm_mon + 1,tod->tm_mday,tod->tm_year + 1900,
				tod->tm_hour,tod->tm_min,tod->tm_sec);
			break;

		case 4:
			sprintf(buf,"%02d-%02d-%04d %02d:%02d:%02d",
				tod->tm_mon + 1,tod->tm_mday,tod->tm_year + 1900,
				tod->tm_hour,tod->tm_min,tod->tm_sec);
			tod = gmtime(&epoch_secs);
			sprintf(&buf[strlen(buf) ]," (UTC %02d:%02d)",
				tod->tm_hour,tod->tm_min);
			break;

		case 8:
		case 5:
			sprintf(buf,"%02d-%02d-%04d",
				tod->tm_mon + 1,tod->tm_mday,tod->tm_year + 1900);
			break;

	}

	return(buf);
}	/* end of epoch_secs_to_str */

/*+-----------------------------------------------------------------------
	char *get_tod(type,buf)

  time of day types:
	0		hh:mm
	1		hh:mm:ss
	2		mm-dd-yyyy hh:mm
	3		mm-dd-yyyy hh:mm:ss
	4		mm-dd-yyyy hh:mm:ss (UTC hh:mm)
	5		mm-dd-yyyy
	6		hh:mmZ
	7		hh:mm:ssZ
	8		mm-dd-yyyy (UTC date)

	returns 'buf' address

------------------------------------------------------------------------*/
char *
get_tod(type,buf)
int type;
char *buf;
{
	return(epoch_secs_to_str(time((long *)0),type,buf));
}	/* end of get_tod */

/*+-----------------------------------------------------------------------
	char *get_elapsed_time(elapsed_seconds)
	"hh:mm:ss" returned
  static string address is returned
------------------------------------------------------------------------*/
char *
get_elapsed_time(elapsed_seconds)
long elapsed_seconds;
{
	static char elapsed_time_str[40];
	long hh,mm,ss;

	hh = elapsed_seconds / 3600;
	elapsed_seconds -= hh * 3600;
	mm = elapsed_seconds / 60L;
	elapsed_seconds -= mm * 60L;
	ss = elapsed_seconds;

	sprintf(elapsed_time_str,"%02ld:%02ld:%02ld",hh,mm,ss);
	return(elapsed_time_str);
}	/* end of get_elapsed_time */

/* end of ecutime.c */
/* vi: set tabstop=4 shiftwidth=4: */
