/* #define ALPHA */
/* #define BETA */
/*+-----------------------------------------------------------------------
	ecunumrev.c - revision numbers
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	build_revision_string()

------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-16-1992-14:13-wht@n4hgf-add M and F version qualifiers */
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:11-16-1991-17:05-wht@n4hgf-better development "x" rev numbering */
/*:08-28-1991-14:07-wht@n4hgf2-SVR4 cleanup by aega84!lh */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:07-12-1991-14:14-wht@n4hgf-GCC140 differentiation */
/*:04-27-1991-01:52-wht@n4hgf-overhaul revision numbers */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "patchlevel.h"

#if defined(M_UNIX)
#undef M_XENIX
#endif

char *numeric_revision = "3";

/*
 * this is not a patchlevel, but a "sub-patchlevel" to keep my life sane
 */
#if defined(WHT) || defined(ALPHA) || defined(BETA)
char *numeric_devrev = "00";
#else
char *numeric_devrev = "";
#endif
char *revstr = "";

/*+-------------------------------------------------------------------------
	build_revision_string()
--------------------------------------------------------------------------*/
void
build_revision_string()
{
	int itmp;
	char s128[128];

	sprintf(s128,"%s%s.%02d",
		(itmp = strlen(numeric_devrev)) ? 
#ifdef ALPHA
			"ALPHA-"
#else
#ifdef BETA
			"BETA-"
#else
			"x"
#endif
#endif
			: "",
		numeric_revision,PATCHLEVEL);

	if(itmp)
	{
		strcat(s128,".");
		strcat(s128,numeric_devrev);
	}

	strcat(s128,"-");

#if defined(M_I286)
	strcat(s128,"286");
#else
#if defined(M_I386) || defined(i386) && (!defined(sun) && !defined(SVR4))
	strcat(s128,"386");
#	if defined(M_XENIX)
#		if defined(WORKING_SELECT)
			 strcat(s128,"s");
#		else
			 strcat(s128,"n");
#		endif /* WORKING_SELECT */
#	endif /* M_XENIX */
#	if defined(M_UNIX)
		strcat(s128,"u");
#	endif /* M_UNIX */
#	if defined(ISC)
		strcat(s128,"i");
#	endif /* ISC */
#else
#if defined(sun)
	strcat(s128,"sun");
#else
#if defined(SVR4)
#   if defined(ESIXSVR4)
#      define found_one
	   strcat(s128,"eSVR4");
#   endif
#   if defined(ISCSVR4)
#      define found_one
	   strcat(s128,"iSVR4");
#   endif
#   if !defined(found_one)
       strcat(s128,"SVR4");
#   endif /* found_one */
#   undef    found_one
#else
porting_attention_needed_here;
#endif /* SVR4 */
#endif /* sun */
#endif /* M_I386 || i386 */
#endif /* M_I286 */

#if defined(__GNUC__)
#if defined(GCC140)
	strcat(s128,"G");
#else
	strcat(s128,"g");
#endif
#if __STDC__
	strcat(s128,"A");
#endif
#endif /*  */

#ifdef MORSE
	strcat(s128,"M");
#endif /* WHT */
#ifdef FASI
	strcat(s128,"F");
#endif /* WHT */
#ifdef WHT
	strcat(s128,"*");
#endif /* WHT */

#ifndef CONFIG
	strcat(s128," wht@n4hgf");
#endif

	if(!(revstr = malloc(strlen(s128) + 1)))
	{
		fprintf(stderr,"out of memory so early!?\n");
		exit(255);
	}
	strcpy(revstr,s128);

}	/* end of build_revision_string */

/* vi: set tabstop=4 shiftwidth=4: */
