// Thought you'd get C, but you ended up looking at a -*- C++ -*- header file.
//
// 	@(#)seadifGraph.h 1.5 01/06/93 Delft University of Technology
// 

#ifndef __SEADIFGRAPH_H
#define __SEADIFGRAPH_H

#include <sdfGraph.h>

//////////////////////////////////////////////////////////////////////////////
//				     grNet                                  //
//////////////////////////////////////////////////////////////////////////////
// We must be able to build a set of grNet objects, that's why we derive from
// setElmt. A set of grNets is a bus (actually: anotherBus).
//
class grNet: public gNet, public setElmt
{
public:
   grNet(NETPTR n);
   virtual void print() {gNet::print(); setElmt::print();}
};

gNet *new_grNet(NETPTR sdfnet);	// used by buildCircuitGraph() in makebus.C;

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//				  anotherBus                                //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
// This class holds a set of grNets that form one bus. We also derive from
// setElmt so that we can have a set of buses.
class anotherBus: public set, public setElmt
{
private:
   char *_busName;
public:
   anotherBus(char *busName);
   ~anotherBus();
   STRING busName() {return _busName;}
   virtual void print() {set::print(); setElmt::print();}
};

#endif // __SEADIFGRAPH_H
