static char *SccsId = "@(#)prExt.c 4.2 (TU-Delft) 06/26/92";
/**********************************************************

Name/Version      : xsls/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 12-May-1992
Modified by       : 
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern int out_indent;
extern int language;
extern int tog_comma;
extern int tog_pnod;
extern int tog_nnod;
extern int tog_nodnbr;

extern struct cir *beg_extl;

prExt ()
{
    struct cir *extl;
    struct model_info *newNetw ();

    for (extl = beg_extl; extl != NULL; extl = extl -> next) {
	prExtHead (newNetw (extl -> name, extl -> proj, extl -> orig_name, 1));
    }
}

prExtHead (ntw)
struct model_info *ntw;
{
    struct cir_term *t;
    struct term_ref *tref;
    int currTermType = -1;
    int firstinode;
    char par[64];
    char *p;
    int outPos ();

    oprint (0, "\n");

    switch (language) {
	case SLS:
	    oprint (0, "extern network ");
	    break;
	case SPICE:
	    break;
	case SIMON:
	    break;
	case EDIF:
	    break;
    }

    oprint (0, ntw -> name);
    oprint (0, " ");

    if (language == SLS) {
	if (ntw -> terms == NULL) {
	    oprint (0, "()");
	    oprint (0, "\n");
	    return;
	}
	oprint (0, "(");
    }

    out_indent = outPos ();
    
    if (language == SLS)
	oprint (0, "terminal ");

    if (tog_pnod || tog_nnod) {
	if (tog_pnod) {
	    if (language == EDIF) oprint (0, "(port ");
	    nmprint (0, "pbulk", 0, NULL, NULL, 0, tog_nodnbr, 1);
	    if (language == EDIF) oprint (0, ")");
	}
	if (tog_nnod) {
	    if (tog_pnod) {
		if (tog_comma) {
		    oprint (1, ",");
		}
		oprint (0, " ");
	    }
	    if (language == EDIF) oprint (0, "(port ");
	    nmprint (0, "nbulk", 0, NULL, NULL, 0, tog_nodnbr, 1);
	    if (language == EDIF) oprint (0, ")");
	}
	if (ntw -> terms != NULL) {
	    if (tog_comma) {
		oprint (1, ",");
	    }
	    oprint (0, " ");
	}
    }

    firstinode = 1;

    for (tref = ntw -> terms; tref != NULL; tref = tref -> next) {
	t = tref -> t;

	if (language == SIMON) {

	    if (tref -> type == INPUT
		|| tref -> type == INREAD) {

		if (currTermType == -1) {
		    oprint (0, "i(");
		    firstinode = 1;
		}
		currTermType = tref -> type;
	    }
	    else if (tref -> type == INOUT) {
		if (currTermType >= 0 
		    && currTermType != INOUT) {
		    oprint (0, ") ");
		}
		if (currTermType != INOUT) {
		    oprint (0, "io(");
		    firstinode = 1;
		}
		currTermType = tref -> type;
	    }
	    else if (tref -> type == OUTPUT) {
		if (currTermType >= 0 
		    && currTermType != OUTPUT) {
		    oprint (0, ") ");
		}
		if (currTermType != OUTPUT) {
		    oprint (0, "o(");
		    firstinode = 1;
		}
		currTermType = tref -> type;
	    }
	}

	if (firstinode) {
	    firstinode = 0;
	}
	else {
	    if (tog_comma) {
		oprint (1, ",");
	    }
	    oprint (0, " ");
	}

	if (language == EDIF) oprint (0, "(port ");
	nmprint (0, t -> term_name, t -> term_dim, 
		 t -> term_lower, t -> term_upper, 1, tog_nodnbr, 1);
	if (language == EDIF) oprint (0, ")");
    }

    if (language == SLS || language == SIMON) 
	oprint (1, ")");
    if (language == EDIF) {

	if (ntw -> param != NULL) {
	    p = ntw -> param;
	    while (*p != '\0') {
		sscanf (p, "%s", par);
		oprint (0, "(parameter ");
		oprint (0, par);
		/*
		if (strcmp (ntw -> name, "res") == 0 && par[0] == 'v') {
		    oprint (0, "(number 0)");
		    oprint (0, "(unit RESISTANCE)");
		}
		else if (strcmp (ntw -> name, "cap") == 0 && par[0] == 'v') {
		    oprint (0, "(number 0)");
		    oprint (0, "(unit CAPACITANCE)");
		}
		else if (par[0] == 'w' && par[1] == '\0') {
		    oprint (0, "(number (e 1 -6))");
		    oprint (0, "(unit DISTANCE)");
		}
		else if (par[0] == 'l' && par[1] == '\0') {
		    oprint (0, "(number (e 1 -6))");
		    oprint (0, "(unit DISTANCE)");
		}
		else {
		*/
		    oprint (0, "(number)");
		/*
		}
		*/
		oprint (0, ")");
		while (*p != '\0' && *p != ' ')
		    p++;
		if (*p == ' ') p++;
	    }
	}
	oprint (0, ")");
    }
    else
	oprint (0, "\n");
    out_indent = 0;
}
