/* SccsId = "@(#)define.h 4.3 (TU-Delft) 03/20/91" */
/**********************************************************

Name/Version      : xsls/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 16-Feb-1987
Modified by       : A.J. van Genderen
Modification date : 16-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/

#define PALLOC(ptr, nel, type)      {                                          \
	if (nel == 0) ptr = NULL; \
	else \
	if ((ptr = (type *)calloc( (unsigned)(nel), sizeof(type))) == NULL) {  \
	    fprintf (stderr, "Cannot allocate storage\n");                     \
	    die ();                                                            \
        }                                                                      }

#define REPALLOC(ptr, nel, type)      {                                        \
	if (nel == 0) ptr = NULL; \
	else \
	if ((ptr = (type *)realloc((char *)ptr,                                \
				   (unsigned)(nel) * sizeof(type))) == NULL) { \
	    fprintf (stderr, "Cannot allocate storage\n");                     \
	    die ();                                                            \
        }                                                                      }

#define FREE(ptr)                  {                                           \
	if (ptr != NULL) {                                                     \
	    cfree( (char *)ptr );                                              \
	    ptr = NULL;                                                        \
	}                                                                      }

#define OPENR(fp, fn, must)     {                                              \
	if ( ( fp = fopen (fn, "r") ) == NULL && must) {                       \
	    fprintf (stderr, "Cannot read %s\n", fn);                          \
	    die ();                                                            \
	}                                                                      }

#define OPENW(fp, fn)           {                                              \
	if ( ( fp = fopen (fn, "w") ) == NULL) {                               \
	    fprintf (stderr, "Cannot write %s\n", fn);                         \
	    die ();                                                            \
	}                                                                      }

#define CLOSE(fp)                { fclose (fp); }

#define SLS     0
#define SPICE   1
#define ESPICE  2
#define SIMON   3
#define EDIF    4

#define OUTPUT  0
#define INPUT   1
#define INREAD  2
#define INOUT   3
