static char *SccsId = "@(#)selKeys.c 4.3 (TU-Delft) 05/26/92";
/**********************************************************

Name/Version      : tecc/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <signal.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

static int *sMaskCond;
static int *eMaskCond;

selectKeys ()
{
    int i;
    struct layCondRef * cond;
    struct layerRef * nextKey;
    struct layerRef * lastKey;
    int nextMask;
    int nextOccur;
    int maxCnt;
    int stop;

    ALLOC (sMaskCond, procdata -> nomasks, int);
    for (i = 0; i < procdata -> nomasks; i++) {
	sMaskCond[i] = 0;
    }
    ALLOC (eMaskCond, procdata -> nomasks, int);
    for (i = 0; i < procdata -> nomasks; i++) {
	eMaskCond[i] = 0;
    }

    for (i = 0; i < res_cnt; i++) {
	cond = ress [ i ].cond;
	countCond (cond);
    }

    for (i = 0; i < tor_cnt; i++) {
	cond = tors [ i ].cond;
	countCond (cond);
    }

    for (i = 0; i < con_cnt; i++) {
	cond = cons [ i ].cond;
	countCond (cond);
    }

    for (i = 0; i < cap_cnt; i++) {
	cond = caps [ i ].cond;
	countCond (cond);
    }

    for (i = 0; i < vdim_cnt; i++) {
	cond = vdms [ i ].cond;
	countCond (cond);
    }

    for (i = 0; i < shape_cnt; i++) {
	cond = shps [ i ].cond;
	countCond (cond);
    }

    /* keylist == NULL */

    stop = 0;
    while (!stop) {

	maxCnt = 0;
	nextMask = -1;

        for (i = 0; i < procdata -> nomasks; i++) {
	    if (sMaskCond [i] > maxCnt) {
		maxCnt = sMaskCond [i];
		nextMask = i;
		nextOccur = SURFACE;
	    }
	}

        for (i = 0; i < procdata -> nomasks; i++) {
	    if (eMaskCond [i] > maxCnt) {
		maxCnt = eMaskCond [i];
		nextMask = i;
		nextOccur = EDGE;
	    }
	}

	/* only surface and edge layers will be included in the
	   key list */

	if (nextMask < 0)
	    stop = 1;
	else {
	    ALLOC (nextKey, 1, struct layerRef);
	    ALLOC (nextKey -> lay, 1, struct layer);
	    nextKey -> lay -> mask = nextMask;
	    switch (nextOccur) {
		case SURFACE :
		    sMaskCond[ nextMask ] = -1;
		    break;
		case EDGE :
		    eMaskCond[ nextMask ] = -1;
		    break;
	    }
	    nextKey -> lay -> occurrence = nextOccur;
	    if (keylist == NULL) {
		keylist = nextKey;
	    }
	    else {
		lastKey -> next = nextKey;
	    }
	    lastKey = nextKey;
	    lastKey -> next = NULL;
	}
    }
}

countCond (cond)
struct layCondRef * cond;
{
    while (cond != NULL) {

	if (cond -> layC -> lay -> occurrence == SURFACE)
	    sMaskCond [cond -> layC -> lay -> mask]++;
	else if (cond -> layC -> lay -> occurrence == EDGE) 
	    eMaskCond [cond -> layC -> lay -> mask]++;

	/* only surface and edge layers will be included in the
	   key list */

	cond = cond -> next;
    }
}
